/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Map;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Cacheable;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.fao.geonet.domain.Constants;
import org.fao.geonet.domain.Localized;
import org.fao.geonet.entitylistener.SelectionEntityListenerManager;

@Entity
@Access(value=AccessType.PROPERTY)
@Cacheable
@Table(name="Selections")
@EntityListeners(value={SelectionEntityListenerManager.class})
@SequenceGenerator(name="selection_id_seq", initialValue=100, allocationSize=1)
public class Selection
extends Localized
implements Serializable {
    static final String ID_SEQ_NAME = "selection_id_seq";
    private int _id;
    private String _name;
    private char watchable = (char)110;

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="selection_id_seq")
    public int getId() {
        return this._id;
    }

    public void setId(int id) {
        this._id = id;
    }

    @Column(nullable=false)
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    @ElementCollection(fetch=FetchType.LAZY, targetClass=String.class)
    @CollectionTable(joinColumns={@JoinColumn(name="idDes")}, name="SelectionsDes")
    @MapKeyColumn(name="langId", length=5)
    @Column(name="label", nullable=false)
    @JsonProperty(value="label")
    public Map<String, String> getLabelTranslations() {
        return super.getLabelTranslations();
    }

    @JsonIgnore
    @Column(name="isWatchable", length=1, nullable=false)
    protected char getWatchable_JPAWorkaround() {
        return this.watchable;
    }

    protected void setWatchable_JPAWorkaround(char watchable) {
        this.watchable = watchable;
    }

    @Transient
    @JsonProperty(value="watchable")
    public boolean isWatchable() {
        return Constants.toBoolean_fromYNChar(this.getWatchable_JPAWorkaround());
    }

    public Selection setWatchable(boolean watchable) {
        this.setWatchable_JPAWorkaround(Constants.toYN_EnabledChar(watchable));
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Selection category = (Selection)o;
        return this._id == category._id;
    }

    public int hashCode() {
        return this._id;
    }
}

