/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNEntryHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNMerger;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNDiffConflictChoiceStyle;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNObjectsPool;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNEntryHandler;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry16;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLogImpl;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLogRunner;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNMerger;
import org.tmatesoft.svn.core.wc.ISVNMergerFactory;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNMergeFileSet;
import org.tmatesoft.svn.core.wc.SVNMergeResult;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SVNAdminArea {
    protected static final String ADM_KILLME = "KILLME";
    private static volatile boolean ourIsCleanupSafe;
    protected Map myBaseProperties;
    protected Map myProperties;
    protected Map myWCProperties;
    protected Map myEntries;
    protected boolean myWasLocked;
    private ISVNCommitParameters myCommitParameters;
    private Map myRevertProperties;
    private File myDirectory;
    private SVNWCAccess myWCAccess;
    private File myAdminRoot;
    private int myWCFormatVersion;

    public static synchronized void setSafeCleanup(boolean safe) {
        ourIsCleanupSafe = safe;
    }

    public static synchronized boolean isSafeCleanup() {
        return ourIsCleanupSafe;
    }

    public abstract boolean isLocked() throws SVNException;

    public abstract boolean isVersioned();

    protected abstract boolean isEntryPropertyApplicable(String var1);

    public abstract boolean lock(boolean var1) throws SVNException;

    public abstract boolean unlock() throws SVNException;

    public abstract SVNVersionedProperties getBaseProperties(String var1) throws SVNException;

    public abstract SVNVersionedProperties getRevertProperties(String var1) throws SVNException;

    public abstract SVNVersionedProperties getWCProperties(String var1) throws SVNException;

    public abstract SVNVersionedProperties getProperties(String var1) throws SVNException;

    public abstract void saveVersionedProperties(SVNLog var1, boolean var2) throws SVNException;

    public abstract void installProperties(String var1, SVNProperties var2, SVNProperties var3, SVNLog var4, boolean var5, boolean var6) throws SVNException;

    public abstract void saveWCProperties(boolean var1) throws SVNException;

    public abstract void saveEntries(boolean var1) throws SVNException;

    public abstract String getThisDirName();

    public abstract boolean hasPropModifications(String var1) throws SVNException;

    public abstract boolean hasProperties(String var1) throws SVNException;

    public abstract SVNAdminArea createVersionedDirectory(File var1, String var2, String var3, String var4, long var5, boolean var7, SVNDepth var8) throws SVNException;

    public abstract void postCommit(String var1, long var2, boolean var4, boolean var5, SVNErrorCode var6) throws SVNException;

    public abstract void handleKillMe() throws SVNException;

    public abstract boolean hasTreeConflict(String var1) throws SVNException;

    public abstract SVNTreeConflictDescription getTreeConflict(String var1) throws SVNException;

    public abstract void addTreeConflict(SVNTreeConflictDescription var1) throws SVNException;

    public abstract SVNTreeConflictDescription deleteTreeConflict(String var1) throws SVNException;

    public abstract void setFileExternalLocation(String var1, SVNURL var2, SVNRevision var3, SVNRevision var4, SVNURL var5) throws SVNException;

    public abstract int getFormatVersion();

    public void updateURL(String rootURL, boolean recursive) throws SVNException {
        SVNWCAccess wcAccess = this.getWCAccess();
        Iterator ents = this.entries(false);
        while (ents.hasNext()) {
            SVNEntry entry = (SVNEntry)ents.next();
            if (!this.getThisDirName().equals(entry.getName()) && entry.isDirectory() && recursive) {
                SVNAdminArea childDir = wcAccess.retrieve(this.getFile(entry.getName()));
                if (childDir == null) continue;
                String childURL = SVNPathUtil.append(rootURL, SVNEncodingUtil.uriEncode(entry.getName()));
                childDir.updateURL(childURL, recursive);
                continue;
            }
            entry.setURL(this.getThisDirName().equals(entry.getName()) ? rootURL : SVNPathUtil.append(rootURL, SVNEncodingUtil.uriEncode(entry.getName())));
        }
        this.saveEntries(false);
    }

    public boolean hasTextModifications(String name, boolean forceComparision) throws SVNException {
        return this.hasTextModifications(name, forceComparision, true, false);
    }

    public boolean hasTextModifications(String name, boolean forceComparison, boolean compareTextBase, boolean compareChecksum) throws SVNException {
        File baseFile;
        File textFile = this.getFile(name);
        SVNFileType fileType = SVNFileType.getType(textFile);
        if (fileType != SVNFileType.FILE && fileType != SVNFileType.SYMLINK) {
            return false;
        }
        if (fileType == SVNFileType.SYMLINK) {
            forceComparison = true;
        }
        SVNEntry entry = null;
        if (!forceComparison) {
            boolean compare = false;
            try {
                entry = this.getEntry(name, false);
            }
            catch (SVNException svne) {
                compare = true;
            }
            if (!compare && entry == null) {
                compare = true;
            }
            if (!compare && this.isEntryPropertyApplicable("svn:entry:working-size") && entry.getWorkingSize() != -1L && SVNFileUtil.getFileLength(textFile) != entry.getWorkingSize()) {
                compare = true;
            }
            if (!compare) {
                String textTime = entry.getTextTime();
                if (textTime == null) {
                    compare = true;
                } else {
                    long tstamp;
                    long textTimeAsLong = SVNDate.parseDateAsMilliseconds(textTime);
                    if (textTimeAsLong != (tstamp = SVNFileUtil.getFileLastModified(textFile))) {
                        compare = true;
                    }
                }
            }
            if (!compare) {
                return false;
            }
        }
        if (!(baseFile = this.getBaseFile(name, false)).isFile()) {
            return true;
        }
        boolean differs = this.compareAndVerify(textFile, baseFile, compareTextBase, compareChecksum);
        if (!differs && this.isLocked()) {
            SVNHashMap attributes = new SVNHashMap();
            attributes.put("svn:entry:working-size", Long.toString(SVNFileUtil.getFileLength(textFile)));
            attributes.put("svn:entry:text-time", SVNDate.formatDate(new Date(SVNFileUtil.getFileLastModified(textFile))));
            this.modifyEntry(name, attributes, true, false);
        }
        return differs;
    }

    public boolean hasVersionedFileTextChanges(File file, File baseFile, boolean compareTextBase) throws SVNException {
        return this.compareAndVerify(file, baseFile, compareTextBase, false);
    }

    public String getRelativePath(SVNAdminArea anchor) {
        String absoluteAnchor = anchor.getRoot().getAbsolutePath();
        String ownAbsolutePath = this.getRoot().getAbsolutePath();
        String relativePath = ownAbsolutePath.substring(absoluteAnchor.length());
        if ((relativePath = relativePath.replace(File.separatorChar, '/')).startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        if (relativePath.endsWith("/")) {
            relativePath = relativePath.substring(0, relativePath.length() - 1);
        }
        return relativePath;
    }

    public boolean tweakEntry(String name, String newURL, String reposRoot, long newRevision, boolean remove) throws SVNException {
        boolean rewrite = false;
        SVNEntry entry = this.getEntry(name, true);
        if (entry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "No such entry: ''{0}''", (Object)name);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (!(newURL == null || entry.getURL() != null && newURL.equals(entry.getURL()))) {
            rewrite = true;
            entry.setURL(newURL);
        }
        if (reposRoot != null && (entry.getRepositoryRootURL() == null || !reposRoot.equals(entry.getRepositoryRoot())) && entry.getURL() != null && SVNPathUtil.isAncestor(reposRoot, entry.getURL())) {
            boolean setReposRoot = true;
            if (this.getThisDirName().equals(entry.getName())) {
                Iterator entries = this.entries(true);
                while (entries.hasNext()) {
                    SVNEntry childEntry = (SVNEntry)entries.next();
                    if (childEntry.getRepositoryRoot() != null || childEntry.getURL() == null || SVNPathUtil.isAncestor(reposRoot, entry.getURL())) continue;
                    setReposRoot = false;
                    break;
                }
            }
            if (setReposRoot) {
                rewrite = true;
                entry.setRepositoryRoot(reposRoot);
            }
        }
        if (!(newRevision < 0L || entry.isScheduledForAddition() || entry.isScheduledForReplacement() || entry.isCopied() || entry.getRevision() == newRevision)) {
            rewrite = true;
            entry.setRevision(newRevision);
        }
        if (remove && (entry.isDeleted() || entry.isAbsent() && entry.getRevision() != newRevision)) {
            this.deleteEntry(name);
            rewrite = true;
        }
        return rewrite;
    }

    public boolean isKillMe() {
        return this.getAdminFile(ADM_KILLME).isFile();
    }

    public boolean markResolved(String name, boolean text, boolean props, SVNConflictChoice conflictChoice) throws SVNException {
        File file;
        SVNEntry entry = this.getEntry(name, true);
        if (entry == null) {
            return false;
        }
        String autoResolveSource = null;
        File autoResolveSourceFile = null;
        boolean removeSource = false;
        if (conflictChoice == SVNConflictChoice.BASE) {
            autoResolveSource = entry.getConflictOld();
        } else if (conflictChoice == SVNConflictChoice.MINE_FULL) {
            autoResolveSource = entry.getConflictWorking();
        } else if (conflictChoice == SVNConflictChoice.THEIRS_FULL) {
            autoResolveSource = entry.getConflictNew();
        } else if (conflictChoice == SVNConflictChoice.THEIRS_CONFLICT || conflictChoice == SVNConflictChoice.MINE_CONFLICT) {
            if (entry.getConflictOld() != null && entry.getConflictNew() != null && entry.getConflictWorking() != null) {
                SVNDiffConflictChoiceStyle style;
                String conflictOld = entry.getConflictOld();
                String conflictNew = entry.getConflictNew();
                String conflictWorking = entry.getConflictWorking();
                ISVNMergerFactory factory = this.myWCAccess.getOptions().getMergerFactory();
                File conflictOldFile = SVNPathUtil.isAbsolute(conflictOld) ? new File(conflictOld) : this.getFile(conflictOld);
                File conflictNewFile = SVNPathUtil.isAbsolute(conflictNew) ? new File(conflictNew) : this.getFile(conflictNew);
                File conflictWorkingFile = SVNPathUtil.isAbsolute(conflictWorking) ? new File(conflictWorking) : this.getFile(conflictWorking);
                byte[] conflictStart = ("<<<<<<< " + conflictWorking).getBytes();
                byte[] conflictEnd = (">>>>>>> " + conflictNew).getBytes();
                byte[] separator = "=======".getBytes();
                ISVNMerger merger = factory.createMerger(conflictStart, separator, conflictEnd);
                SVNDiffConflictChoiceStyle sVNDiffConflictChoiceStyle = style = conflictChoice == SVNConflictChoice.THEIRS_CONFLICT ? SVNDiffConflictChoiceStyle.CHOOSE_LATEST : SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED;
                if (merger instanceof DefaultSVNMerger) {
                    DefaultSVNMerger defaultMerger = (DefaultSVNMerger)merger;
                    defaultMerger.setDiffConflictStyle(style);
                }
                autoResolveSourceFile = SVNAdminUtil.createTmpFile(this);
                SVNMergeFileSet mergeFileSet = new SVNMergeFileSet(this, null, conflictOldFile, conflictWorkingFile, name, conflictNewFile, autoResolveSourceFile, null, null);
                String localLabel = ".working";
                String baseLabel = ".old";
                String latestLabel = ".new";
                mergeFileSet.setMergeLabels(baseLabel, localLabel, latestLabel);
                merger.mergeText(mergeFileSet, false, null);
                mergeFileSet.dispose();
                removeSource = true;
            }
        } else if (conflictChoice != SVNConflictChoice.MERGED) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Invalid 'conflict_result' argument");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (autoResolveSource != null) {
            autoResolveSourceFile = this.getFile(autoResolveSource);
        }
        if (autoResolveSourceFile != null) {
            SVNFileUtil.copyFile(autoResolveSourceFile, this.getFile(name), false);
            if (removeSource) {
                SVNFileUtil.deleteFile(autoResolveSourceFile);
            }
        }
        if (!text && !props) {
            return false;
        }
        boolean filesDeleted = false;
        boolean updateEntry = false;
        if (text && entry.getConflictOld() != null) {
            file = this.getFile(entry.getConflictOld());
            filesDeleted |= file.isFile();
            updateEntry = true;
            SVNFileUtil.deleteFile(file);
        }
        if (text && entry.getConflictNew() != null) {
            file = this.getFile(entry.getConflictNew());
            filesDeleted |= file.isFile();
            updateEntry = true;
            SVNFileUtil.deleteFile(file);
        }
        if (text && entry.getConflictWorking() != null) {
            file = this.getFile(entry.getConflictWorking());
            filesDeleted |= file.isFile();
            updateEntry = true;
            SVNFileUtil.deleteFile(file);
        }
        if (props && entry.getPropRejectFile() != null) {
            file = this.getFile(entry.getPropRejectFile());
            filesDeleted |= file.isFile();
            updateEntry = true;
            SVNFileUtil.deleteFile(file);
        }
        if (updateEntry) {
            if (text) {
                entry.setConflictOld(null);
                entry.setConflictNew(null);
                entry.setConflictWorking(null);
            }
            if (props) {
                entry.setPropRejectFile(null);
            }
            this.saveEntries(false);
        }
        return filesDeleted;
    }

    public void restoreFile(String name) throws SVNException {
        boolean needsLock;
        SVNVersionedProperties props = this.getProperties(name);
        SVNEntry entry = this.getEntry(name, true);
        boolean special = props.getPropertyValue("svn:special") != null;
        File src = this.getBaseFile(name, false);
        File dst = this.getFile(name);
        SVNTranslator.translate(this, name, SVNFileUtil.getBasePath(src), SVNFileUtil.getBasePath(dst), true);
        boolean executable = props.getPropertyValue("svn:executable") != null;
        boolean bl = needsLock = props.getPropertyValue("svn:needs-lock") != null;
        if (needsLock) {
            SVNFileUtil.setReadonly(dst, entry.getLockToken() == null);
        }
        if (executable) {
            SVNFileUtil.setExecutable(dst, true);
        }
        this.markResolved(name, true, false, SVNConflictChoice.MERGED);
        if (this.myWCAccess.getOptions().isUseCommitTimes() && !special) {
            entry.setTextTime(entry.getCommittedDate());
            long tstamp = SVNDate.parseDate(entry.getCommittedDate()).getTime();
            SVNFileUtil.setLastModified(dst, tstamp);
        } else {
            long tstamp = System.currentTimeMillis();
            SVNFileUtil.setLastModified(dst, tstamp);
            entry.setTextTime(SVNDate.formatDate(new Date(dst.lastModified())));
        }
        this.saveEntries(false);
    }

    public SVNStatusType mergeProperties(String name, SVNProperties serverBaseProps, SVNProperties propDiff, String localLabel, String latestLabel, boolean baseMerge, boolean dryRun, SVNLog log) throws SVNException {
        SVNVersionedProperties working = this.getProperties(name);
        SVNVersionedProperties base = this.getBaseProperties(name);
        return this.mergeProperties(name, serverBaseProps, base.asMap(), working.asMap(), propDiff, localLabel, latestLabel, baseMerge, dryRun, log);
    }

    public SVNStatusType mergeProperties(String name, SVNProperties serverBaseProps, SVNProperties baseProps, SVNProperties workingProps, SVNProperties propDiff, String localLabel, String latestLabel, boolean baseMerge, boolean dryRun, SVNLog log) throws SVNException {
        localLabel = localLabel == null ? "(modified)" : localLabel;
        latestLabel = latestLabel == null ? "(latest)" : latestLabel;
        byte[] conflictStart = ("<<<<<<< " + localLabel).getBytes();
        byte[] conflictEnd = (">>>>>>> " + latestLabel).getBytes();
        byte[] separator = "=======".getBytes();
        ISVNMergerFactory factory = this.myWCAccess.getOptions().getMergerFactory();
        ISVNMerger merger = factory.createMerger(conflictStart, separator, conflictEnd);
        propDiff = propDiff == null ? new SVNProperties() : propDiff;
        SVNMergeResult result = merger.mergeProperties(name, workingProps, baseProps, serverBaseProps, propDiff, this, log, baseMerge, dryRun);
        return result.getMergeStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNStatusType mergeText(String localPath, File base, File latest, File copyFromText, String localLabel, String baseLabel, String latestLabel, SVNProperties propChanges, boolean dryRun, SVNDiffOptions options, SVNLog log) throws SVNException {
        SVNMergeResult mergeResult;
        String thisPath;
        String copyFromTextPath;
        SVNEntry entry = this.getEntry(localPath, false);
        if (entry == null && copyFromText == null) {
            return SVNStatusType.MISSING;
        }
        boolean saveLog = log == null;
        log = log == null ? this.getLog() : log;
        SVNVersionedProperties props = this.getProperties(localPath);
        String mimeType = null;
        if (propChanges != null && propChanges.containsName("svn:mime-type")) {
            mimeType = propChanges.getStringValue("svn:mime-type");
        } else if (copyFromText == null) {
            mimeType = props.getStringPropertyValue("svn:mime-type");
        }
        localLabel = localLabel == null ? ".working" : localLabel;
        baseLabel = baseLabel == null ? ".old" : baseLabel;
        latestLabel = latestLabel == null ? ".new" : latestLabel;
        byte[] conflictStart = ("<<<<<<< " + localLabel).getBytes();
        byte[] conflictEnd = (">>>>>>> " + latestLabel).getBytes();
        byte[] separator = "=======".getBytes();
        ISVNMergerFactory factory = this.myWCAccess.getOptions().getMergerFactory();
        ISVNMerger merger = factory.createMerger(conflictStart, separator, conflictEnd);
        String workingText = localPath;
        if (copyFromText != null && (workingText = (copyFromTextPath = copyFromText.getAbsolutePath().replace(File.separatorChar, '/')).substring((thisPath = this.getRoot().getAbsolutePath().replace(File.separatorChar, '/')).length())).startsWith("/")) {
            workingText = workingText.substring(1);
        }
        File tmpTarget = SVNTranslator.detranslateWorkingCopy(this, workingText, propChanges, false);
        base = SVNTranslator.maybeUpdateTargetEOLs(this, base, propChanges);
        File resultFile = SVNAdminUtil.createTmpFile(this);
        SVNMergeFileSet mergeFileSet = new SVNMergeFileSet(this, log, base, tmpTarget, localPath, latest, resultFile, copyFromText, mimeType);
        mergeFileSet.setMergeLabels(baseLabel, localLabel, latestLabel);
        try {
            mergeResult = merger.mergeText(mergeFileSet, dryRun, options);
        }
        finally {
            if (dryRun) {
                SVNFileUtil.deleteFile(resultFile);
            }
        }
        mergeFileSet.dispose();
        if (saveLog) {
            log.save();
        }
        return mergeResult.getMergeStatus();
    }

    public InputStream getBaseFileForReading(String name, boolean tmp) throws SVNException {
        String path = tmp ? "tmp/" : "";
        path = path + "text-base/" + name + ".svn-base";
        File baseFile = this.getAdminFile(path);
        return SVNFileUtil.openFileForReading(baseFile, SVNLogType.WC);
    }

    public OutputStream getBaseFileForWriting(String name) throws SVNException {
        final String fileName = name;
        final File tmpFile = this.getBaseFile(name, true);
        try {
            final OutputStream os = SVNFileUtil.openFileForWriting(tmpFile);
            return new OutputStream(){
                private String myName;
                private File myTmpFile;
                {
                    this.myName = fileName;
                    this.myTmpFile = tmpFile;
                }

                public void write(int b) throws IOException {
                    os.write(b);
                }

                public void write(byte[] b) throws IOException {
                    os.write(b);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    os.write(b, off, len);
                }

                public void close() throws IOException {
                    os.close();
                    File baseFile = SVNAdminArea.this.getBaseFile(this.myName, false);
                    try {
                        SVNFileUtil.rename(this.myTmpFile, baseFile);
                    }
                    catch (SVNException e) {
                        throw new IOException(e.getMessage());
                    }
                    SVNFileUtil.setReadonly(baseFile, true);
                }
            };
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Your .svn/tmp directory may be missing or corrupt; run 'svn cleanup' and try again");
            SVNErrorManager.error(err, SVNLogType.WC);
            return null;
        }
    }

    public String getPropertyTime(String name) {
        String path = this.getThisDirName().equals(name) ? "dir-props" : "props/" + name + ".svn-work";
        File file = this.getAdminFile(path);
        return SVNDate.formatDate(new Date(SVNFileUtil.getFileLastModified(file)));
    }

    public SVNLog getLog() {
        int index = 0;
        File logFile = null;
        File tmpFile = null;
        while ((logFile = this.getAdminFile("log" + (index == 0 ? "" : "." + index))).exists()) {
            ++index;
        }
        tmpFile = this.getAdminFile("tmp/log" + (index == 0 ? "" : "." + index));
        return new SVNLogImpl(logFile, tmpFile, this);
    }

    public void runLogs() throws SVNException {
        this.runLogs(false);
    }

    public void runLogs(boolean rerun) throws SVNException {
        SVNLogRunner runner = new SVNLogRunner(rerun);
        int index = 0;
        SVNLogImpl log = null;
        runner.logStarted(this);
        try {
            File logFile = null;
            while (true) {
                if (this.getWCAccess() != null) {
                    this.getWCAccess().checkCancelled();
                }
                if (((SVNLog)(log = new SVNLogImpl(logFile = this.getAdminFile("log" + (index == 0 ? "" : "." + index)), null, this))).exists()) {
                    log.run(runner);
                    SVNAdminArea.markLogProcessed(logFile);
                    ++index;
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            runner.logFailed(this);
            if (e instanceof SVNException) {
                throw (SVNException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new SVNException(SVNErrorMessage.create(SVNErrorCode.UNKNOWN), e);
        }
        runner.logCompleted(this);
        File[] logsFiles = this.getAdminDirectory().listFiles();
        if (logsFiles != null) {
            for (int i = 0; i < logsFiles.length; ++i) {
                if (!logsFiles[i].getName().startsWith("log") || !logsFiles[i].isFile()) continue;
                SVNFileUtil.deleteFile(logsFiles[i]);
            }
        }
    }

    public void removeFromRevisionControl(String name, boolean deleteWorkingFiles, boolean reportInstantError) throws SVNException {
        this.getWCAccess().checkCancelled();
        boolean isFile = !this.getThisDirName().equals(name);
        boolean leftSomething = false;
        SVNEntry entry = this.getVersionedEntry(name, true);
        if (isFile) {
            SVNErrorMessage err;
            boolean wcSpecial;
            File path = this.getFile(name);
            boolean bl = wcSpecial = this.getProperties(name).getPropertyValue("svn:special") != null;
            boolean localSpecial = !SVNFileUtil.symlinksSupported() ? false : SVNFileType.getType(path) == SVNFileType.SYMLINK;
            boolean textModified = false;
            if (wcSpecial || !localSpecial) {
                textModified = this.hasTextModifications(name, false);
                if (reportInstantError && textModified) {
                    err = SVNErrorMessage.create(SVNErrorCode.WC_LEFT_LOCAL_MOD, "File ''{0}'' has local modifications", (Object)path);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
            SVNPropertiesManager.deleteWCProperties(this, name, false);
            this.deleteEntry(name);
            this.saveEntries(false);
            SVNFileUtil.deleteFile(this.getFile(SVNAdminUtil.getTextBasePath(name, false)));
            SVNFileUtil.deleteFile(this.getFile(SVNAdminUtil.getPropBasePath(name, entry.getKind(), false)));
            SVNFileUtil.deleteFile(this.getFile(SVNAdminUtil.getPropPath(name, entry.getKind(), false)));
            if (deleteWorkingFiles) {
                if (textModified || !wcSpecial && localSpecial) {
                    err = SVNErrorMessage.create(SVNErrorCode.WC_LEFT_LOCAL_MOD);
                    SVNErrorManager.error(err, SVNLogType.WC);
                } else if (this.myCommitParameters == null || this.myCommitParameters.onFileDeletion(path)) {
                    SVNFileUtil.deleteFile(path);
                }
            }
        } else {
            SVNEntry dirEntryInParent;
            SVNEntry dirEntry = this.getEntry(this.getThisDirName(), false);
            dirEntry.setIncomplete(true);
            this.saveEntries(false);
            SVNPropertiesManager.deleteWCProperties(this, this.getThisDirName(), false);
            Iterator entries = this.entries(false);
            while (entries.hasNext()) {
                String entryName;
                SVNEntry nextEntry = (SVNEntry)entries.next();
                String string = entryName = this.getThisDirName().equals(nextEntry.getName()) ? null : nextEntry.getName();
                if (nextEntry.isFile()) {
                    try {
                        this.removeFromRevisionControl(entryName, deleteWorkingFiles, reportInstantError);
                        continue;
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) {
                            if (reportInstantError) {
                                throw e;
                            }
                            leftSomething = true;
                            continue;
                        }
                        throw e;
                    }
                }
                if (entryName == null || !nextEntry.isDirectory()) continue;
                File entryPath = this.getFile(entryName);
                if (this.getWCAccess().isMissing(entryPath) || nextEntry.getDepth() == SVNDepth.EXCLUDE) {
                    this.deleteEntry(entryName);
                    continue;
                }
                try {
                    SVNAdminArea entryArea = this.getWCAccess().retrieve(entryPath);
                    entryArea.removeFromRevisionControl(this.getThisDirName(), deleteWorkingFiles, reportInstantError);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) {
                        if (reportInstantError) {
                            throw e;
                        }
                        leftSomething = true;
                        continue;
                    }
                    throw e;
                }
            }
            if (!this.getWCAccess().isWCRoot(this.getRoot()) && (dirEntryInParent = this.getWCAccess().retrieve(this.getRoot().getParentFile()).getEntry(this.getRoot().getName(), false)).getDepth() != SVNDepth.EXCLUDE) {
                this.getWCAccess().retrieve(this.getRoot().getParentFile()).deleteEntry(this.getRoot().getName());
                this.getWCAccess().retrieve(this.getRoot().getParentFile()).saveEntries(false);
            }
            this.destroyAdminArea();
            if (deleteWorkingFiles && !leftSomething && (this.myCommitParameters == null || this.myCommitParameters.onDirectoryDeletion(this.getRoot())) && !this.getRoot().delete()) {
                leftSomething = true;
            }
        }
        if (leftSomething && this.myCommitParameters == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_LEFT_LOCAL_MOD);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    public void extendLockToTree() throws SVNException {
        final boolean writeLock = this.isLocked();
        ISVNEntryHandler entryHandler = new ISVNEntryHandler(){

            public void handleEntry(File path, SVNEntry entry) throws SVNException {
                block4: {
                    if (entry.isDirectory() && !entry.getName().equals(SVNAdminArea.this.getThisDirName())) {
                        try {
                            SVNAdminArea area = SVNAdminArea.this.getWCAccess().probeTry(path, SVNAdminArea.this.isLocked(), -1);
                            if (writeLock && area != null && !area.isLocked()) {
                                area.lock(false);
                            }
                        }
                        catch (SVNException svne) {
                            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LOCKED) break block4;
                            throw svne;
                        }
                    }
                }
            }

            public void handleError(File path, SVNErrorMessage error) throws SVNException {
                SVNErrorManager.error(error, SVNLogType.WC);
            }
        };
        this.getWCAccess().walkEntries(this.getRoot(), entryHandler, false, SVNDepth.INFINITY);
    }

    public void foldScheduling(String name, Map attributes, boolean force) throws SVNException {
        SVNErrorMessage err;
        if (!attributes.containsKey("svn:entry:schedule") || force) {
            return;
        }
        String schedule = (String)attributes.get("svn:entry:schedule");
        schedule = "".equals(schedule) ? null : schedule;
        SVNEntry entry = this.getEntry(name, true);
        if (entry == null) {
            if ("add".equals(schedule)) {
                return;
            }
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "''{0}'' is not under version control", (Object)name);
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        SVNEntry thisDirEntry = this.getEntry(this.getThisDirName(), true);
        if (!this.getThisDirName().equals(entry.getName()) && thisDirEntry.isScheduledForDeletion()) {
            if ("add".equals(schedule)) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "Can''t add ''{0}'' to deleted directory; try undeleting its parent directory first", (Object)name);
                SVNErrorManager.error(err, SVNLogType.WC);
            } else if ("replace".equals(schedule)) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "Can''t replace ''{0}'' in deleted directory; try undeleting its parent directory first", (Object)name);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        if (entry.isAbsent() && "add".equals(schedule)) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "''{0}'' is marked as absent, so it cannot be scheduled for addition", (Object)name);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if ("add".equals(entry.getSchedule())) {
            if ("delete".equals(schedule)) {
                if (!entry.isDeleted()) {
                    this.deleteEntry(name);
                } else {
                    attributes.put("svn:entry:schedule", null);
                }
            } else {
                attributes.remove("svn:entry:schedule");
            }
        } else if ("delete".equals(entry.getSchedule())) {
            if ("delete".equals(schedule)) {
                attributes.remove("svn:entry:schedule");
            } else if ("add".equals(schedule)) {
                attributes.put("svn:entry:schedule", "replace");
            }
        } else if ("replace".equals(entry.getSchedule())) {
            if ("delete".equals(schedule)) {
                attributes.put("svn:entry:schedule", "delete");
            } else if ("add".equals(schedule) || "replace".equals(schedule)) {
                attributes.remove("svn:entry:schedule");
            }
        } else if ("add".equals(schedule) && !entry.isDeleted()) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "Entry ''{0}'' is already under version control", (Object)name);
            SVNErrorManager.error(err, SVNLogType.WC);
        } else if (schedule == null) {
            attributes.remove("svn:entry:schedule");
        }
    }

    public SVNEntry modifyEntry(String name, Map attributes, boolean save, boolean force) throws SVNException {
        if (name == null) {
            name = this.getThisDirName();
        }
        boolean deleted = false;
        if (attributes.containsKey("svn:entry:schedule")) {
            SVNEntry entryBefore = this.getEntry(name, true);
            this.foldScheduling(name, attributes, force);
            SVNEntry entryAfter = this.getEntry(name, true);
            if (entryBefore != null && entryAfter == null) {
                deleted = true;
            }
        }
        SVNEntry entry = null;
        if (!deleted) {
            SVNEntry rootEntry;
            entry = this.getEntry(name, true);
            if (entry == null) {
                entry = this.addEntry(name);
            }
            Iterator atts = attributes.keySet().iterator();
            while (atts.hasNext()) {
                String attName = (String)atts.next();
                if (this.isEntryPropertyApplicable(attName)) continue;
                atts.remove();
            }
            entry.applyChanges(attributes);
            if (!entry.isDirectory() && (rootEntry = this.getEntry(this.getThisDirName(), true)) != null) {
                if (!SVNRevision.isValidRevisionNumber(entry.getRevision())) {
                    entry.setRevision(rootEntry.getRevision());
                }
                if (entry.getURL() == null) {
                    entry.setParentURL(rootEntry.getURL());
                }
                if (entry.getRepositoryRoot() == null) {
                    entry.setRepositoryRoot(rootEntry.getRepositoryRoot());
                }
                if (entry.getUUID() == null && !entry.isScheduledForAddition() && !entry.isScheduledForReplacement()) {
                    entry.setUUID(rootEntry.getUUID());
                }
                if (this.isEntryPropertyApplicable("svn:entry:cachable-props") && entry.getCachableProperties() == null) {
                    entry.setCachableProperties(rootEntry.getCachableProperties());
                }
            }
            if (attributes.containsKey("svn:entry:schedule")) {
                if (entry.isScheduledForDeletion()) {
                    entry.setCopied(false);
                    entry.setCopyFromRevision(-1L);
                    entry.setCopyFromURL(null);
                } else {
                    entry.setKeepLocal(false);
                }
            }
        }
        if (save) {
            this.saveEntries(false);
        }
        return entry;
    }

    public void deleteEntry(String name) throws SVNException {
        Map entries = this.loadEntries();
        if (entries != null) {
            entries.remove(name);
        }
    }

    public SVNEntry getEntry(String name, boolean hidden) throws SVNException {
        Map entries = this.loadEntries();
        if (entries != null && entries.containsKey(name)) {
            SVNEntry entry = (SVNEntry)entries.get(name);
            if (!hidden && entry.isHidden()) {
                return null;
            }
            return entry;
        }
        return null;
    }

    public SVNEntry getVersionedEntry(String name, boolean hidden) throws SVNException {
        SVNEntry entry = this.getEntry(name, hidden);
        if (entry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", (Object)this.getFile(name));
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return entry;
    }

    public SVNEntry addEntry(String name) throws SVNException {
        Map entries = this.loadEntries();
        if (entries == null) {
            entries = this.myEntries = new SVNHashMap();
        }
        SVNEntry entry = entries.containsKey(name) ? (SVNEntry)entries.get(name) : new SVNEntry16(this, name);
        entries.put(name, entry);
        return entry;
    }

    public Iterator entries(boolean hidden) throws SVNException {
        Map entries = this.loadEntries();
        if (entries == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList copy = new ArrayList(entries.values());
        if (!hidden) {
            Iterator iterator = copy.iterator();
            while (iterator.hasNext()) {
                SVNEntry entry = (SVNEntry)iterator.next();
                if (!entry.isHidden()) continue;
                iterator.remove();
            }
        }
        return copy.iterator();
    }

    public Map getEntries() throws SVNException {
        return this.loadEntries();
    }

    public void cleanup() throws SVNException {
        this.getWCAccess().checkCancelled();
        Iterator entries = this.entries(false);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            if (entry.getKind() == SVNNodeKind.DIR && !this.getThisDirName().equals(entry.getName())) {
                File childDir = this.getFile(entry.getName());
                if (!childDir.isDirectory()) continue;
                try {
                    SVNAdminArea child = this.getWCAccess().open(childDir, true, true, 0);
                    child.cleanup();
                    continue;
                }
                catch (SVNException e) {
                    if (e instanceof SVNCancelException) {
                        throw e;
                    }
                    if (SVNAdminArea.isSafeCleanup()) continue;
                    throw e;
                }
            }
            this.hasPropModifications(entry.getName());
            if (entry.getKind() != SVNNodeKind.FILE) continue;
            this.hasTextModifications(entry.getName(), false);
        }
        if (this.isKillMe()) {
            this.removeFromRevisionControl(this.getThisDirName(), true, false);
        } else {
            this.runLogs(true);
        }
        SVNFileUtil.deleteAll(this.getAdminFile("tmp"), false);
    }

    public boolean hasTextConflict(String name) throws SVNException {
        SVNEntry entry = this.getEntry(name, false);
        if (entry == null || entry.getKind() != SVNNodeKind.FILE) {
            return false;
        }
        boolean conflicted = false;
        if (entry.getConflictNew() != null) {
            boolean bl = conflicted = SVNFileType.getType(this.getFile(entry.getConflictNew())) == SVNFileType.FILE;
        }
        if (!conflicted && entry.getConflictWorking() != null) {
            boolean bl = conflicted = SVNFileType.getType(this.getFile(entry.getConflictWorking())) == SVNFileType.FILE;
        }
        if (!conflicted && entry.getConflictOld() != null) {
            conflicted = SVNFileType.getType(this.getFile(entry.getConflictOld())) == SVNFileType.FILE;
        }
        return conflicted;
    }

    public boolean hasPropConflict(String name) throws SVNException {
        SVNEntry entry = this.getEntry(name, false);
        if (entry != null && entry.getPropRejectFile() != null) {
            return SVNFileType.getType(this.getFile(entry.getPropRejectFile())) == SVNFileType.FILE;
        }
        return false;
    }

    public File getRoot() {
        return this.myDirectory;
    }

    public File getAdminTempDirectory() {
        return this.getAdminFile("tmp");
    }

    public File getAdminDirectory() {
        return this.myAdminRoot;
    }

    public File getAdminFile(String name) {
        return new File(this.getAdminDirectory(), name);
    }

    public File getFile(String name) {
        if (name == null) {
            return null;
        }
        return new File(this.getRoot(), name);
    }

    public SVNWCAccess getWCAccess() {
        return this.myWCAccess;
    }

    public void setWCAccess(SVNWCAccess wcAccess) {
        this.myWCAccess = wcAccess;
    }

    public void closeVersionedProperties() {
        this.myProperties = null;
        this.myBaseProperties = null;
    }

    public void closeWCProperties() {
        this.myWCProperties = null;
    }

    public void closeEntries() {
        this.myEntries = null;
    }

    public File getBaseFile(String name, boolean tmp) {
        String path = tmp ? "tmp/" : "";
        path = path + "text-base/" + name + ".svn-base";
        return this.getAdminFile(path);
    }

    public int getWorkingCopyFormatVersion() {
        return this.myWCFormatVersion;
    }

    public void setWorkingCopyFormatVersion(int wcFormatVersion) {
        this.myWCFormatVersion = wcFormatVersion;
    }

    public void close() {
    }

    protected abstract void writeEntries(Writer var1) throws IOException, SVNException;

    protected abstract Map fetchEntries() throws SVNException;

    protected abstract boolean readExtraOptions(BufferedReader var1, SVNEntry var2) throws SVNException, IOException;

    protected abstract int writeExtraOptions(Writer var1, String var2, SVNEntry var3, int var4) throws SVNException, IOException;

    protected SVNAdminArea(File dir) {
        this.myDirectory = dir;
        this.myAdminRoot = new File(dir, SVNFileUtil.getAdminDirectoryName());
    }

    public File getBasePropertiesFile(String name, boolean tmp) {
        String path = !tmp ? "" : "tmp/";
        path = path + (this.getThisDirName().equals(name) ? "dir-prop-base" : "prop-base/" + name + ".svn-base");
        File propertiesFile = this.getAdminFile(path);
        return propertiesFile;
    }

    public File getRevertPropertiesFile(String name, boolean tmp) {
        String path = !tmp ? "" : "tmp/";
        path = path + (this.getThisDirName().equals(name) ? "dir-prop-revert" : "prop-base/" + name + ".svn-revert");
        File propertiesFile = this.getAdminFile(path);
        return propertiesFile;
    }

    public File getPropertiesFile(String name, boolean tmp) {
        String path = !tmp ? "" : "tmp/";
        path = path + (this.getThisDirName().equals(name) ? "dir-props" : "props/" + name + ".svn-work");
        File propertiesFile = this.getAdminFile(path);
        return propertiesFile;
    }

    protected Map loadEntries() throws SVNException {
        if (this.myEntries != null) {
            return this.myEntries;
        }
        this.myEntries = this.fetchEntries();
        if (this.myEntries != null) {
            SVNAdminArea.resolveDefaults(this.myEntries);
        }
        return this.myEntries;
    }

    protected Map getBasePropertiesStorage(boolean create) {
        if (this.myBaseProperties == null && create) {
            this.myBaseProperties = new SVNHashMap();
        }
        return this.myBaseProperties;
    }

    protected Map getRevertPropertiesStorage(boolean create) {
        if (this.myRevertProperties == null && create) {
            this.myRevertProperties = new SVNHashMap();
        }
        return this.myRevertProperties;
    }

    protected Map getPropertiesStorage(boolean create) {
        if (this.myProperties == null && create) {
            this.myProperties = new SVNHashMap();
        }
        return this.myProperties;
    }

    protected Map getWCPropertiesStorage(boolean create) {
        if (this.myWCProperties == null && create) {
            this.myWCProperties = new SVNHashMap();
        }
        return this.myWCProperties;
    }

    public static String asString(String[] array, String delimiter) {
        String str = null;
        if (array != null) {
            str = "";
            for (int i = 0; i < array.length; ++i) {
                str = str + array[i];
                if (i >= array.length - 1) continue;
                str = str + delimiter;
            }
        }
        return str;
    }

    public static String[] fromString(String str, String delimiter) {
        if (str == null) {
            return new String[0];
        }
        LinkedList<String> list = new LinkedList<String>();
        int startInd = 0;
        int ind = -1;
        while ((ind = str.indexOf(delimiter, startInd)) != -1) {
            list.add(str.substring(startInd, ind));
            for (startInd = ind; startInd < str.length() && str.charAt(startInd) == ' '; ++startInd) {
            }
        }
        if (startInd < str.length()) {
            list.add(str.substring(startInd));
        }
        return list.toArray(new String[list.size()]);
    }

    public void commit(String target, SVNCommitInfo info, SVNProperties wcPropChanges, boolean removeLock, boolean recursive, boolean removeChangelist, Collection explicitCommitPaths, ISVNCommitParameters params) throws SVNException {
        SVNAdminArea anchor = this.getWCAccess().retrieve(this.getWCAccess().getAnchor());
        String path = this.getRelativePath(anchor);
        String string = path = this.getThisDirName().equals(target) ? path : SVNPathUtil.append(path, target);
        if (!explicitCommitPaths.contains(path)) {
            File committedFile;
            SVNEntry entry = this.getEntry(target, true);
            if (entry != null && entry.getCopyFromURL() != null) {
                return;
            }
            if (entry != null && entry.isFile() && entry.isScheduledForAddition() && !(committedFile = this.getBaseFile(target, true)).isFile()) {
                return;
            }
        }
        SVNLog log = this.getLog();
        String checksum = null;
        if (!this.getThisDirName().equals(target)) {
            log.logRemoveRevertFile(target, this, true);
            log.logRemoveRevertFile(target, this, false);
            File baseFile = this.getBaseFile(target, true);
            SVNFileType baseType = SVNFileType.getType(baseFile);
            if (baseType == SVNFileType.NONE) {
                baseFile = this.getBaseFile(target, false);
                baseType = SVNFileType.getType(baseFile);
            }
            if (baseType == SVNFileType.FILE) {
                checksum = SVNFileUtil.computeChecksum(baseFile);
            }
            recursive = false;
        }
        SVNProperties command = new SVNProperties();
        if (info != null) {
            command.put("name", target);
            command.put(SVNProperty.shortPropertyName("svn:entry:committed-rev"), Long.toString(info.getNewRevision()));
            command.put(SVNProperty.shortPropertyName("svn:entry:committed-date"), SVNDate.formatDate(info.getDate()));
            command.put(SVNProperty.shortPropertyName("svn:entry:last-author"), info.getAuthor());
            log.addCommand("modify-entry", command, false);
            command.clear();
        }
        if (checksum != null) {
            command.put("name", target);
            command.put(SVNProperty.shortPropertyName("svn:entry:checksum"), checksum);
            log.addCommand("modify-entry", command, false);
            command.clear();
        }
        if (removeLock) {
            command.put("name", target);
            log.addCommand("delete-lock", command, false);
            command.clear();
        }
        if (removeChangelist) {
            command.put("name", target);
            log.addCommand("delete-changelist", command, false);
            command.clear();
        }
        command.put("name", target);
        command.put("revision", info == null ? null : Long.toString(info.getNewRevision()));
        if (!explicitCommitPaths.contains(path)) {
            command.put("implicit", "true");
        }
        log.addCommand("committed", command, false);
        command.clear();
        if (wcPropChanges != null && !wcPropChanges.isEmpty()) {
            for (String propName : wcPropChanges.nameSet()) {
                SVNPropertyValue propValue = wcPropChanges.getSVNPropertyValue(propName);
                command.put("name", target);
                command.put("propname", propName);
                command.put("propval", propValue);
                log.addCommand("modify-wcprop", command, false);
                command.clear();
            }
        }
        log.save();
        this.runLogs();
        if (recursive) {
            Iterator ents = this.entries(true);
            while (ents.hasNext()) {
                SVNEntry parentEntry;
                SVNEntry entry = (SVNEntry)ents.next();
                if (entry.isThisDir() || entry.getDepth() == SVNDepth.EXCLUDE) continue;
                if (entry.getKind() == SVNNodeKind.DIR) {
                    File childPath = this.getFile(entry.getName());
                    SVNAdminArea childDir = this.getWCAccess().retrieve(childPath);
                    if (childDir == null) continue;
                    childDir.commit(this.getThisDirName(), info, null, removeLock, true, removeChangelist, explicitCommitPaths, params);
                    continue;
                }
                if (entry.isScheduledForDeletion() && (parentEntry = this.getEntry(this.getThisDirName(), true)).isScheduledForReplacement()) continue;
                this.commit(entry.getName(), info, null, removeLock, false, removeChangelist, explicitCommitPaths, params);
            }
        }
    }

    public void walkThisDirectory(ISVNEntryHandler handler, boolean showHidden, SVNDepth depth) throws SVNException {
        File thisDir = this.getRoot();
        SVNEntry thisEntry = this.getEntry(this.getThisDirName(), showHidden);
        if (thisEntry == null) {
            handler.handleError(thisDir, SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Directory ''{0}'' has no THIS_DIR entry", (Object)thisDir));
            return;
        }
        try {
            handler.handleEntry(thisDir, thisEntry);
        }
        catch (SVNException svne) {
            handler.handleError(thisDir, svne.getErrorMessage());
        }
        if (depth == SVNDepth.EMPTY) {
            return;
        }
        Iterator entries = this.entries(showHidden);
        while (entries.hasNext()) {
            this.getWCAccess().checkCancelled();
            SVNEntry entry = (SVNEntry)entries.next();
            if (this.getThisDirName().equals(entry.getName())) continue;
            File childPath = this.getFile(entry.getName());
            if (entry.isFile() || depth.compareTo(SVNDepth.IMMEDIATES) >= 0) {
                try {
                    handler.handleEntry(childPath, entry);
                }
                catch (SVNException svne) {
                    handler.handleError(childPath, svne.getErrorMessage());
                }
            }
            if (!entry.isDirectory() || entry.isHidden() || depth.compareTo(SVNDepth.IMMEDIATES) < 0) continue;
            SVNAdminArea childArea = null;
            SVNDepth depthBelowHere = depth;
            if (depth == SVNDepth.IMMEDIATES) {
                depthBelowHere = SVNDepth.EMPTY;
            }
            try {
                childArea = this.getWCAccess().retrieve(childPath);
            }
            catch (SVNException svne) {
                handler.handleError(childPath, svne.getErrorMessage());
            }
            if (childArea == null) continue;
            childArea.walkThisDirectory(handler, showHidden, depthBelowHere);
        }
    }

    public void setCommitParameters(ISVNCommitParameters commitParameters) {
        this.myCommitParameters = commitParameters;
    }

    protected void setLocked(boolean locked) {
        this.myWasLocked = locked;
    }

    private void destroyAdminArea() throws SVNException {
        if (!this.isLocked()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Write-lock stolen in ''{0}''", (Object)this.getRoot());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNFileUtil.deleteAll(this.getAdminDirectory(), this.getWCAccess());
        this.getWCAccess().closeAdminArea(this.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void markLogProcessed(File logFile) throws SVNException {
        SVNFileUtil.setReadonly(logFile, false);
        OutputStream os = null;
        try {
            os = SVNFileUtil.openFileForWriting(logFile);
        }
        finally {
            if (os != null) {
                SVNFileUtil.closeFile(os);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean compareAndVerify(File text, File baseFile, boolean compareTextBase, boolean checksum) throws SVNException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void resolveDefaults(Map entries) throws SVNException {
        SVNErrorMessage err;
        SVNEntry defaultEntry = (SVNEntry)entries.get("");
        if (defaultEntry == null) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Missing default entry");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (defaultEntry.getRevision() < 0L) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_REVISION, "Default entry has no revision number");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (defaultEntry.getURL() == null) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Default entry is missing no URL");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        for (String name : entries.keySet()) {
            SVNEntry entry = (SVNEntry)entries.get(name);
            if (entry == null || entry == defaultEntry || entry.isDirectory() || !entry.isFile()) continue;
            if (entry.getRevision() < 0L) {
                entry.setRevision(defaultEntry.getRevision());
            }
            if (entry.getURL() == null) {
                entry.setURL(SVNPathUtil.append(defaultEntry.getURL(), SVNEncodingUtil.uriEncode(entry.getName())));
            }
            if (entry.getUUID() == null && !entry.isScheduledForAddition() && !entry.isScheduledForReplacement()) {
                entry.setUUID(defaultEntry.getUUID());
            }
            if (entry.getCachableProperties() != null) continue;
            entry.setCachableProperties(defaultEntry.getCachableProperties());
        }
    }

    protected abstract SVNVersionedProperties formatBaseProperties(SVNProperties var1);

    protected abstract SVNVersionedProperties formatProperties(SVNEntry var1, SVNProperties var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createFormatFile(File formatFile, boolean createMyself) throws SVNException {
        OutputStream os = null;
        try {
            formatFile = createMyself ? this.getAdminFile("format") : formatFile;
            os = SVNFileUtil.openFileForWriting(formatFile);
            os.write(String.valueOf(this.getFormatVersion()).getBytes("UTF-8"));
            os.write(10);
        }
        catch (IOException e) {
            try {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e, SVNLogType.WC);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(os);
                throw throwable;
            }
            SVNFileUtil.closeFile(os);
        }
        SVNFileUtil.closeFile(os);
    }

    public SVNAdminArea formatWC(SVNAdminArea adminArea) throws SVNException {
        File logFile = adminArea.getAdminFile("log");
        SVNFileType type = SVNFileType.getType(logFile);
        if (type == SVNFileType.FILE) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "Changing working copy format failed: found a log file at '" + logFile + "'");
            return adminArea;
        }
        SVNLog log = this.getLog();
        SVNProperties command = new SVNProperties();
        command.put("format", String.valueOf(this.getFormatVersion()));
        log.addCommand("upgrade-format", command, false);
        command.clear();
        this.setWCAccess(adminArea.getWCAccess());
        this.myEntries = new SVNHashMap();
        Map basePropsCache = this.getBasePropertiesStorage(true);
        Map propsCache = this.getPropertiesStorage(true);
        Iterator entries = adminArea.entries(true);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            SVNEntry16 newEntry = new SVNEntry16(this.createEntryHashMap(entry.asMap()), this, entry.getName());
            this.myEntries.put(entry.getName(), newEntry);
            if (entry.getKind() != SVNNodeKind.FILE && !adminArea.getThisDirName().equals(entry.getName())) continue;
            SVNVersionedProperties srcBaseProps = adminArea.getBaseProperties(entry.getName());
            SVNVersionedProperties dstBaseProps = this.formatBaseProperties(srcBaseProps.asMap());
            basePropsCache.put(entry.getName(), dstBaseProps);
            dstBaseProps.setModified(true);
            SVNVersionedProperties srcProps = adminArea.getProperties(entry.getName());
            SVNVersionedProperties dstProps = this.formatProperties(entry, srcProps.asMap());
            propsCache.put(entry.getName(), dstProps);
            dstProps.setModified(true);
            this.handleCharsetProperty(adminArea, log, newEntry, dstBaseProps);
            this.handlePropTime(log, newEntry);
            SVNVersionedProperties wcProps = adminArea.getWCProperties(entry.getName());
            if (wcProps == null) continue;
            log.logChangedWCProperties(entry.getName(), wcProps.asMap());
        }
        this.saveVersionedProperties(log, true);
        log.save();
        if (this.getFormatVersion() != 4) {
            SVNFileUtil.deleteFile(this.getAdminFile("README.txt"));
            SVNFileUtil.deleteFile(this.getAdminFile("empty-file"));
            SVNFileUtil.deleteAll(this.getAdminFile("wcprops"), true);
            SVNFileUtil.deleteAll(this.getAdminFile("tmp/wcprops"), true);
            SVNFileUtil.deleteAll(this.getAdminFile("dir-wcprops"), true);
            SVNFileUtil.deleteAll(this.getAdminFile("all-wcprops"), true);
        } else {
            this.getAdminFile("wcprops").mkdir();
            this.getAdminFile("tmp/wcprops").mkdir();
            SVNFileUtil.createEmptyFile(this.getAdminFile("empty-file"));
            SVNAdminUtil.createReadmeFile(this.getAdminDirectory());
        }
        this.runLogs();
        return this;
    }

    private void handleCharsetProperty(SVNAdminArea adminArea, SVNLog log, SVNEntry entry, SVNVersionedProperties baseProps) throws SVNException {
        SVNProperties command = new SVNProperties();
        SVNPropertyValue charsetProp = baseProps.getPropertyValue("svnkit:charset");
        String mimeType = baseProps.getStringPropertyValue("svn:mime-type");
        String currentCharset = charsetProp == null ? null : charsetProp.getString();
        if ((currentCharset = SVNTranslator.getCharset(currentCharset, mimeType, this.getAdminFile(entry.getName()).toString(), this.getWCAccess().getOptions())) != null && !SVNProperty.isUTF8(currentCharset)) {
            File detranslatedFile = SVNAdminUtil.createTmpFile(this, "detranslated", ".tmp", true);
            String detranslatedPath = SVNPathUtil.getRelativePath(this.getRoot().getAbsolutePath(), detranslatedFile.getAbsolutePath());
            File tmpCharsetPropFile = SVNAdminUtil.createTmpFile(this, "props", ".tmp", true);
            String tmpCharsetPropPath = SVNPathUtil.getRelativePath(this.getRoot().getAbsolutePath(), tmpCharsetPropFile.getAbsolutePath());
            if (this.getFormatVersion() == 9) {
                baseProps.setPropertyValue("svnkit:charset", SVNPropertyValue.create("UTF-8"));
                SVNWCProperties propFile = new SVNWCProperties(tmpCharsetPropFile, tmpCharsetPropPath);
                propFile.setProperties(baseProps.asMap());
                baseProps.setPropertyValue("svnkit:charset", charsetProp);
                File tmpBaseFile = SVNAdminUtil.createTmpFile(this, entry.getName(), ".tmp", true);
                String tmpBasePath = SVNPathUtil.getRelativePath(this.getRoot().getAbsolutePath(), tmpBaseFile.getAbsolutePath());
                command.put("name", SVNAdminUtil.getPropBasePath(entry.getName(), SVNNodeKind.FILE, false));
                command.put("dest", tmpBasePath);
                log.addCommand("cp", command, false);
                command.clear();
                command.put("name", tmpCharsetPropPath);
                command.put("dest", SVNAdminUtil.getPropBasePath(entry.getName(), SVNNodeKind.FILE, false));
                log.addCommand("mv", command, false);
                command.clear();
                command.put("name", entry.getName());
                command.put("dest", detranslatedPath);
                log.addCommand("cp-and-detranslate", command, false);
                command.clear();
                command.put("dest", SVNAdminUtil.getPropBasePath(entry.getName(), SVNNodeKind.FILE, false));
                command.put("name", tmpBasePath);
                log.addCommand("mv", command, false);
                command.clear();
                command.put("name", detranslatedPath);
                command.put("dest", entry.getName());
                log.addCommand("cp-and-translate", command, false);
                command.clear();
                command.put("name", detranslatedPath);
                log.addCommand("rm", command, false);
                command.clear();
            } else if (adminArea.getFormatVersion() == 9) {
                command.put("name", entry.getName());
                command.put("dest", detranslatedPath);
                log.addCommand("cp-and-detranslate", command, false);
                command.clear();
                baseProps.setPropertyValue("svnkit:charset", SVNPropertyValue.create("UTF-8"));
                SVNWCProperties propFile = new SVNWCProperties(tmpCharsetPropFile, tmpCharsetPropPath);
                propFile.setProperties(baseProps.asMap());
                baseProps.setPropertyValue("svnkit:charset", charsetProp);
                command.put("name", tmpCharsetPropPath);
                command.put("dest", SVNAdminUtil.getPropBasePath(entry.getName(), SVNNodeKind.FILE, false));
                log.addCommand("mv", command, false);
                command.clear();
                command.put("name", detranslatedPath);
                command.put("dest", entry.getName());
                log.addCommand("cp-and-translate", command, false);
                command.clear();
                command.put("name", detranslatedPath);
                log.addCommand("rm", command, false);
                command.clear();
            }
        }
    }

    private void handlePropTime(SVNLog log, SVNEntry entry) throws SVNException {
        if (this.getFormatVersion() == 4) {
            return;
        }
        SVNProperties command = new SVNProperties();
        command.put("name", entry.getName());
        command.put(SVNProperty.shortPropertyName("svn:entry:prop-time"), SVNDate.formatDate(new Date(0L), true));
        log.addCommand("modify-entry", command, false);
    }

    public void postUpgradeFormat(int format) throws SVNException {
        if (format == this.getFormatVersion()) {
            this.createFormatFile(null, true);
            return;
        }
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Unexpected format number:\n   expected: {0}\n     actual: {1}", new Object[]{new Integer(this.getFormatVersion()), new Integer(format)});
        SVNErrorManager.error(err, SVNLogType.WC);
    }

    protected SVNHashMap createEntryHashMap(Map map) {
        if (this.getObjectsPool() != null) {
            return new SVNEntryHashMap(map, this.getObjectsPool());
        }
        return new SVNHashMap(map);
    }

    public SVNObjectsPool getObjectsPool() {
        return this.myWCAccess != null ? this.myWCAccess.getObjectsPool() : null;
    }
}

