/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;

public class ValueFactoryImpl
implements ValueFactory {
    private int _lastBNodeId = 0;
    private static final String BNODE_PREFIX = "node";

    public ValueFactoryImpl() {
    }

    public ValueFactoryImpl(String documentURI) {
        this();
        this.setDocumentURI(documentURI);
    }

    public URI createURI(String uri) {
        return new URIImpl(uri);
    }

    public URI createURI(String namespace, String localName) {
        return new URIImpl(namespace, localName);
    }

    public BNode createBNode() {
        return new BNodeImpl(BNODE_PREFIX + this._lastBNodeId++);
    }

    public BNode createBNode(String nodeId) {
        return new BNodeImpl(nodeId);
    }

    public Literal createLiteral(String value) {
        return new LiteralImpl(value);
    }

    public Literal createLiteral(String value, String language) {
        return new LiteralImpl(value, language);
    }

    public Literal createLiteral(String value, URI datatype) {
        return new LiteralImpl(value, datatype);
    }

    public Literal createLiteral(String value, String language, String datatype) {
        if (datatype != null) {
            URI dtURI = this.createURI(datatype);
            return this.createLiteral(value, dtURI);
        }
        if (language != null) {
            return this.createLiteral(value, language);
        }
        return this.createLiteral(value);
    }

    public Statement createStatement(Resource subject, URI predicate, Value object) {
        return new StatementImpl(subject, predicate, object);
    }

    public void setDocumentURI(String uri) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to get MD5 instance: " + e.getMessage());
        }
        messageDigest.update(uri.getBytes());
        byte[] md5code = messageDigest.digest();
        StringBuffer sb = new StringBuffer(32);
        for (int i = 0; i < md5code.length; ++i) {
            String hexString;
            int b = md5code[i];
            if (b < 0) {
                b += 256;
            }
            if ((hexString = Integer.toHexString(b).toUpperCase()).length() == 1) {
                sb.append('0');
            }
            sb.append(hexString);
        }
    }
}

