/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.ldap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.fao.geonet.domain.LDAPUser;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.kernel.security.ldap.AbstractLDAPUserDetailsContextMapper;
import org.fao.geonet.utils.Log;

public class LDAPUserDetailsContextMapper
extends AbstractLDAPUserDetailsContextMapper {
    @Override
    protected void setProfilesAndPrivileges(Profile defaultProfile, String defaultGroup, Map<String, ArrayList<String>> userInfo, LDAPUser userDetails) {
        List ldapProfiles = userInfo.get(((String[])this.mapping.get("profile"))[0]);
        if (ldapProfiles != null) {
            Collections.sort(ldapProfiles);
            for (String profile : ldapProfiles) {
                if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                    Log.debug((String)"geonetwork.ldap", (Object)("  User profile " + profile + " found in attribute " + ((String[])this.mapping.get("profile"))[0]));
                }
                this.addProfile(userDetails, profile, null);
            }
        }
        if (userDetails.getUser().getProfile() == null) {
            if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                Log.debug((String)"geonetwork.ldap", (Object)("  No profile defined in LDAP, using default profile " + defaultProfile));
            }
            userDetails.getUser().setProfile(defaultProfile);
        }
        if (userDetails.getUser().getProfile() != Profile.Administrator) {
            List ldapGroups = userInfo.get(((String[])this.mapping.get("privilege"))[0]);
            if (ldapGroups != null) {
                for (String group : ldapGroups) {
                    if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                        Log.debug((String)"geonetwork.ldap", (Object)("  Define group privilege for group " + group + " as " + userDetails.getUser().getProfile()));
                    }
                    userDetails.addPrivilege(group, userDetails.getUser().getProfile());
                }
            }
            if (userDetails.getPrivileges().size() == 0 && defaultGroup != null) {
                if (Log.isDebugEnabled((String)"geonetwork.ldap")) {
                    Log.debug((String)"geonetwork.ldap", (Object)("  No privilege defined, setting privilege for group " + defaultGroup + " as " + userDetails.getUser().getProfile()));
                }
                userDetails.addPrivilege(defaultGroup, userDetails.getUser().getProfile());
            }
        }
    }
}

