/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.ldap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.directory.Attributes;
import org.fao.geonet.domain.LDAPUser;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.kernel.security.ldap.LDAPRole;
import org.fao.geonet.kernel.security.ldap.LDAPRoleConverter;
import org.fao.geonet.utils.Log;

public class LDAPRoleConverterGroupNameParser
implements LDAPRoleConverter {
    private Pattern ldapMembershipQueryParser;
    private int groupIndexInPattern;
    private int profileIndexInPattern;
    Map<String, Profile> profileMapping;

    @Override
    public List<LDAPRole> convert(Map<String, ArrayList<String>> userInfo, LDAPUser userDetails, String ldapGroupName, Attributes LdapGroupAttributes) throws Exception {
        if (this.ldapMembershipQueryParser == null) {
            return new ArrayList<LDAPRole>();
        }
        Matcher matcher = this.ldapMembershipQueryParser.matcher(ldapGroupName);
        if (!matcher.matches()) {
            return new ArrayList<LDAPRole>();
        }
        String group = matcher.group(this.groupIndexInPattern);
        String profile_str = matcher.group(this.getProfileIndexInPattern());
        Profile profile = this.getProfile(profile_str);
        if (profile == null) {
            return new ArrayList<LDAPRole>();
        }
        Log.debug((String)"geonetwork.ldap", (Object)("for ldap user " + userDetails.getUsername() + " for LDAP group " + ldapGroupName + " gives group= " + group + " with profile= " + profile.name()));
        ArrayList<LDAPRole> result = new ArrayList<LDAPRole>(1);
        result.add(new LDAPRole(group, profile));
        return result;
    }

    public Profile getProfile(String pname) {
        if (this.profileMapping != null && this.profileMapping.containsKey(pname)) {
            return this.profileMapping.get(pname);
        }
        Profile p = Profile.findProfileIgnoreCase((String)pname);
        return p;
    }

    public String getLdapMembershipQueryParser() {
        return this.ldapMembershipQueryParser.toString();
    }

    public void setLdapMembershipQueryParser(String ldapMembershipQueryParser) {
        this.ldapMembershipQueryParser = Pattern.compile(ldapMembershipQueryParser);
    }

    public int getGroupIndexInPattern() {
        return this.groupIndexInPattern;
    }

    public void setGroupIndexInPattern(int groupIndexInPattern) {
        this.groupIndexInPattern = groupIndexInPattern;
    }

    public int getProfileIndexInPattern() {
        return this.profileIndexInPattern;
    }

    public void setProfileIndexInPattern(int profileIndexInPattern) {
        this.profileIndexInPattern = profileIndexInPattern;
    }

    public Map<String, Profile> getProfileMapping() {
        return this.profileMapping;
    }

    public void setProfileMapping(Map<String, Profile> profileMapping) {
        this.profileMapping = profileMapping;
    }
}

