/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import java.io.Closeable;
import java.util.List;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Util;
import org.fao.geonet.services.util.SearchDefaults;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public abstract class MetaSearcher
implements Closeable {
    private int _from;
    private int _to;
    private boolean _valid = false;

    protected static void addElement(Element root, String name, String value) {
        root.addContent((Content)new Element(name).setText(value));
    }

    public abstract void search(ServiceContext var1, Element var2, ServiceConfig var3) throws Exception;

    public abstract Element present(ServiceContext var1, Element var2, ServiceConfig var3) throws Exception;

    public abstract List<Document> presentDocuments(ServiceContext var1, Element var2, ServiceConfig var3) throws Exception;

    public abstract int getSize();

    public abstract Element getSummary() throws Exception;

    public abstract long getVersionToken();

    @Override
    public abstract void close();

    protected void initSearchRange(ServiceContext srvContext) {
        this._from = 1;
        try {
            Element defaultSearch = SearchDefaults.getDefaultSearch(srvContext, null);
            this._to = Integer.parseInt(defaultSearch.getChildText("hitsPerPage"));
        }
        catch (Exception e) {
            this._to = 10;
        }
    }

    protected void updateSearchRange(Element request) {
        this._from = this.readFrom(request);
        this._to = this.readTo(request);
        int count = this.getSize();
        if (this._from > count) {
            this._from = count + 1;
            this._to = count;
        } else {
            this._from = this._from > count ? count : this._from;
            this._to = this._to > count ? count : this._to;
        }
    }

    protected int readFrom(Element request) {
        return this.loadParam(request, "from", this._from);
    }

    protected int readTo(Element request) {
        return this.loadParam(request, "to", this._to);
    }

    private int loadParam(Element request, String name, int defaultVal) {
        String sFrom = request.getChildText(name);
        if (sFrom != null) {
            try {
                return Integer.parseInt(sFrom);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Bad '" + name + "' parameter: " + sFrom);
            }
        }
        return defaultVal;
    }

    protected int getFrom() {
        return this._from;
    }

    protected int getTo() {
        return this._to;
    }

    protected boolean isValid() {
        return this._valid;
    }

    public Element get(ServiceContext srvContext, Element request, ServiceConfig config) throws Exception {
        String id = Util.getParam((Element)request, (String)"id");
        int from = this._from;
        int to = this._to;
        Element req = new Element("request");
        MetaSearcher.addElement(req, "from", id);
        MetaSearcher.addElement(req, "to", id);
        Element result = this.present(srvContext, req, config);
        this._from = from;
        this._to = to;
        for (Object o : result.getChildren()) {
            Element child = (Element)o;
            if (child.getName().equals("summary")) continue;
            return child;
        }
        return null;
    }
}

