/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import java.util.Map;
import jeeves.JeevesCacheManager;
import org.fao.geonet.kernel.search.JSONLocCacheLoader;
import org.fao.geonet.kernel.search.Translator;
import org.springframework.context.ConfigurableApplicationContext;

public class JSONLocTranslator
implements Translator {
    private static final long serialVersionUID = 1L;
    private Map<String, String> translations;
    private String keyPrefix = "";

    public JSONLocTranslator(ConfigurableApplicationContext context, String langCode, String keyPrefix) throws Exception {
        this.keyPrefix = keyPrefix == null ? "" : keyPrefix;
        this.translations = JeevesCacheManager.findInEternalCache(JSONLocCacheLoader.cacheKey(langCode), new JSONLocCacheLoader(context, langCode));
    }

    @Override
    public String translate(String key) {
        if (this.translations == null) {
            return key;
        }
        String value = this.translations.get(this.keyPrefix + key);
        if (value != null && !value.trim().isEmpty()) {
            return value;
        }
        return key;
    }
}

