/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.schema;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.fao.geonet.kernel.schema.AttributeEntry;
import org.fao.geonet.kernel.schema.ElementInfo;
import org.fao.geonet.kernel.schema.Logger;
import org.jdom.Element;

class SimpleContentEntry {
    public String base;
    public ArrayList<AttributeEntry> alAttribs = new ArrayList();
    public List<String> alAttribGroups = new ArrayList<String>();
    public boolean restriction = false;

    public SimpleContentEntry(Element el, Path file, String targetNS, String targetNSPrefix) {
        this(new ElementInfo(el, file, targetNS, targetNSPrefix));
    }

    public SimpleContentEntry(ElementInfo ei) {
        this.handleAttribs(ei);
        this.handleChildren(ei);
    }

    private void handleAttribs(ElementInfo ei) {
    }

    private void handleChildren(ElementInfo ei) {
        List children = ei.element.getChildren();
        for (Element elChild : children) {
            if (elChild.getName().equals("extension")) {
                this.handleExtension(elChild, ei);
                continue;
            }
            if (elChild.getName().equals("restriction")) {
                this.handleExtension(elChild, ei);
                continue;
            }
            Logger.log();
        }
    }

    private void handleExtension(Element el, ElementInfo ei) {
        this.restriction = false;
        this.base = el.getAttributeValue("base");
        List extension = el.getChildren();
        for (Element elExt : extension) {
            String elName = elExt.getName();
            if (elName.equals("attribute")) {
                this.alAttribs.add(new AttributeEntry(elExt, ei.file, ei.targetNS, ei.targetNSPrefix));
                continue;
            }
            if (elName.equals("attributeGroup")) {
                String attribGroup = elExt.getAttributeValue("ref");
                if (attribGroup == null) {
                    throw new IllegalArgumentException("'ref' is null for element in <attributeGroup> of SimpleContent with extension base " + this.base);
                }
                this.alAttribGroups.add(attribGroup);
                continue;
            }
            Logger.log();
        }
    }
}

