/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import java.util.Collections;
import java.util.Map;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.ThesaurusFinder;

public class SingleThesaurusFinder
implements ThesaurusFinder {
    private final Thesaurus thesaurus;

    public SingleThesaurusFinder(Thesaurus thesaurus) {
        this.thesaurus = thesaurus;
    }

    @Override
    public boolean existsThesaurus(String name) {
        return this.thesaurus.getKey().equals(name);
    }

    @Override
    public Thesaurus getThesaurusByName(String thesaurusName) {
        if (this.existsThesaurus(thesaurusName)) {
            return this.thesaurus;
        }
        return null;
    }

    @Override
    public Thesaurus getThesaurusByConceptScheme(String conceptSchemeUri) {
        if (this.thesaurus.hasConceptScheme(conceptSchemeUri)) {
            return this.thesaurus;
        }
        return null;
    }

    @Override
    public Map<String, Thesaurus> getThesauriMap() {
        return Collections.singletonMap(this.thesaurus.getKey(), this.thesaurus);
    }
}

