/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.apps;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import org.dlib.tools.FullTokenizer;
import org.fao.geonet.Constants;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class MakeISO {
    public static void main(String[] args) throws Exception {
        String line;
        if (args.length != 1) {
            System.err.println("usage: makeISO file");
            System.exit(1);
        }
        FileInputStream is = new FileInputStream(new File(args[0]));
        FileOutputStream os = new FileOutputStream(new File(args[0] + ".sql"));
        BufferedReader ir = new BufferedReader(new InputStreamReader((InputStream)is, Constants.ENCODING));
        Element root = new Element("mapping");
        HashSet<String> set = new HashSet<String>();
        while ((line = ir.readLine()) != null) {
            FullTokenizer ft = new FullTokenizer(line, "|");
            String longCode = ft.nextToken();
            ft.nextToken();
            String shortCode = ft.nextToken();
            if (shortCode.length() != 2) continue;
            if (set.contains(shortCode)) {
                System.out.println("Skipped short code : " + shortCode);
                continue;
            }
            set.add(shortCode);
            Element elem = new Element("map");
            elem.setAttribute("longCode", longCode);
            elem.setAttribute("shortCode", shortCode);
            root.addContent((Content)elem);
        }
        String xml = Xml.getString((Document)new Document(root));
        BufferedWriter ow = new BufferedWriter(new OutputStreamWriter((OutputStream)os, Constants.ENCODING));
        ow.write(xml);
        ir.close();
        ow.close();
    }
}

