/*
 * Decompiled with CFR 0.152.
 */
package jeeves.monitor;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ResourceTracker {
    private static final Lock trackerLock = new ReentrantLock(false);
    private final Multimap<Object, Exception> resourceAccessTracker = LinkedHashMultimap.create();
    private final Multimap<Object, Exception> directOpenResourceAccessTracker = LinkedHashMultimap.create();

    private void open(Object resource, Multimap<Object, Exception> tracker) {
    }

    public void openResource(Object resource) {
        this.open(resource, this.resourceAccessTracker);
    }

    public void openDirectResource(Object resource) {
        this.open(resource, this.directOpenResourceAccessTracker);
    }

    private LinkedHashMultimap<Object, Exception> get(Multimap<Object, Exception> tracker) {
        try {
            trackerLock.lock();
            LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create(tracker);
            return linkedHashMultimap;
        }
        finally {
            trackerLock.unlock();
        }
    }

    public LinkedHashMultimap<Object, Exception> getDirectOpenResources() {
        return this.get(this.directOpenResourceAccessTracker);
    }

    public Multimap<Object, Exception> getOpenResources() {
        return this.get(this.resourceAccessTracker);
    }

    public void removeAll(Object resource) {
        try {
            trackerLock.lock();
            this.resourceAccessTracker.removeAll(resource);
            this.directOpenResourceAccessTracker.removeAll(resource);
        }
        finally {
            trackerLock.unlock();
        }
    }

    public void clean() {
        try {
            trackerLock.lock();
            this.resourceAccessTracker.clear();
            this.directOpenResourceAccessTracker.clear();
        }
        finally {
            trackerLock.unlock();
        }
    }
}

