/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.groovy.dataformat;

import groovy.xml.FactorySupport;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.camel.spi.DataFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractXmlDataFormat
implements DataFormat {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractXmlDataFormat.class);
    private static final ErrorHandler DEFAULT_HANDLER = new DefaultErrorHandler();
    private boolean namespaceAware = true;
    private boolean keepWhitespace;
    private ErrorHandler errorHandler = DEFAULT_HANDLER;

    public AbstractXmlDataFormat(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    protected SAXParser newSaxParser() throws Exception {
        SAXParserFactory factory = FactorySupport.createSaxParserFactory();
        factory.setNamespaceAware(this.namespaceAware);
        factory.setValidating(false);
        return factory.newSAXParser();
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public boolean isKeepWhitespace() {
        return this.keepWhitespace;
    }

    public void setKeepWhitespace(boolean keepWhitespace) {
        this.keepWhitespace = keepWhitespace;
    }

    private static class DefaultErrorHandler
    implements ErrorHandler {
        private DefaultErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            LOG.warn("Warning occured during parsing", (Throwable)exception);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }
    }
}

