/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.provider.SimpleExample;

import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.InformationFragment;
import org.jzkit.search.util.RecordModel.InformationFragmentImpl;
import org.jzkit.search.util.RecordModel.RecordFormatSpecification;
import org.jzkit.search.util.ResultSet.AbstractIRResultSet;
import org.jzkit.search.util.ResultSet.IFSNotificationTarget;
import org.jzkit.search.util.ResultSet.IRResultSet;
import org.jzkit.search.util.ResultSet.IRResultSetException;
import org.jzkit.search.util.ResultSet.IRResultSetInfo;

public class ExampleResultSet
extends AbstractIRResultSet
implements IRResultSet {
    private static Log log = LogFactory.getLog(ExampleResultSet.class);
    int num_hits = 0;

    public ExampleResultSet() {
        Random r = new Random();
        this.num_hits = r.nextInt(1000);
        log.debug((Object)("num_hits=" + this.num_hits));
    }

    public InformationFragment[] getFragment(int starting_fragment, int count, RecordFormatSpecification spec) throws IRResultSetException {
        InformationFragment[] result = new InformationFragment[count];
        for (int i = 0; i < count; ++i) {
            result[i] = new InformationFragmentImpl(starting_fragment + 1, "REPO", "COLL", null, "<oai-dc><title>Hello</title></oai-dc>", new ExplicitRecordFormatSpecification("string::F"));
        }
        return result;
    }

    public void asyncGetFragment(int starting_fragment, int count, RecordFormatSpecification spec, IFSNotificationTarget target) {
        try {
            InformationFragment[] result = this.getFragment(starting_fragment, count, spec);
            target.notifyRecords(result);
        }
        catch (IRResultSetException irrse) {
            target.notifyError("bib-1", new Integer(0), "Problem obtaining result records", irrse);
        }
    }

    public int getFragmentCount() {
        return this.num_hits;
    }

    public int getRecordAvailableHWM() {
        return this.num_hits;
    }

    public void close() {
    }

    public IRResultSetInfo getResultSetInfo() {
        return new IRResultSetInfo(this.getResultSetName(), this.getFragmentCount(), this.getStatus());
    }
}

