/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;

public class XmlElementReader
implements Iterator<Element> {
    static final HashMap<String, Integer> attrTypes = new HashMap(32);
    private XMLEventReader reader;
    private XMLEvent currentEvent;
    private Stack<QName> elementNameStack;
    private MatchExpression matchExpression;

    public XmlElementReader(InputStream source, String path, List<org.jdom.Namespace> namespaces) throws XMLStreamException, FactoryConfigurationError {
        this.reader = XMLInputFactory.newInstance().createXMLEventReader(source);
        this.matchExpression = new MatchExpression(path, namespaces);
        this.elementNameStack = new Stack();
        this.findNext();
    }

    private static int resolveAttrType(String typeStr) {
        Integer I;
        if (typeStr != null && typeStr.length() > 0 && (I = attrTypes.get(typeStr)) != null) {
            return I;
        }
        return 0;
    }

    @Override
    public boolean hasNext() {
        return this.reader.hasNext();
    }

    @Override
    public Element next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Element result = this.readElement();
        this.findNext();
        return result;
    }

    @Override
    public void remove() {
    }

    private void findNext() {
        while (this.reader.hasNext()) {
            this.currentEvent = (XMLEvent)this.reader.next();
            if (this.currentEvent.getEventType() == 1) {
                this.elementNameStack.push(this.currentEvent.asStartElement().getName());
            } else if (this.currentEvent.getEventType() == 2) {
                this.elementNameStack.pop();
            }
            if (this.currentEvent.getEventType() != 1 || !this.matchExpression.matches(this.elementNameStack.toArray(new QName[0]))) continue;
            this.elementNameStack.pop();
            return;
        }
    }

    private Element readElement() {
        Element element = this.createElement(this.currentEvent);
        this.currentEvent = (XMLEvent)this.reader.next();
        while (this.currentEvent.getEventType() != 2) {
            switch (this.currentEvent.getEventType()) {
                case 12: {
                    element.addContent((Content)new CDATA(this.currentEvent.asCharacters().getData()));
                    break;
                }
                case 4: 
                case 6: {
                    element.addContent((Content)new Text(this.currentEvent.asCharacters().getData()));
                    break;
                }
                case 5: {
                    element.addContent((Content)new Comment(this.currentEvent.asCharacters().getData()));
                    break;
                }
                case 9: {
                    EntityReference er = (EntityReference)this.currentEvent;
                    element.addContent((Content)new EntityRef(er.getName(), er.getDeclaration().getPublicId(), er.getDeclaration().getSystemId()));
                    break;
                }
                case 3: {
                    javax.xml.stream.events.ProcessingInstruction pi = (javax.xml.stream.events.ProcessingInstruction)this.currentEvent;
                    element.addContent((Content)new ProcessingInstruction(pi.getTarget(), pi.getData()));
                    break;
                }
                case 1: {
                    element.addContent((Content)this.readElement());
                    break;
                }
                default: {
                    throw new IllegalStateException("Not a recognized value");
                }
            }
            this.currentEvent = (XMLEvent)this.reader.next();
        }
        return element;
    }

    private Element createElement(XMLEvent event) {
        Element result = null;
        String nsURI = event.asStartElement().getName().getNamespaceURI();
        String elemPrefix = event.asStartElement().getName().getPrefix();
        String ln = event.asStartElement().getName().getLocalPart();
        result = nsURI == null || nsURI.length() == 0 ? (elemPrefix == null || elemPrefix.length() == 0 ? new Element(ln) : new Element(ln, elemPrefix, "")) : new Element(ln, elemPrefix, nsURI);
        Iterator<Namespace> nss = event.asStartElement().getNamespaces();
        while (nss.hasNext()) {
            Namespace ns = nss.next();
            String prefix = ns.getPrefix();
            if (prefix.equals(elemPrefix)) continue;
            result.addNamespaceDeclaration(org.jdom.Namespace.getNamespace((String)prefix, (String)ns.getNamespaceURI()));
        }
        Iterator<javax.xml.stream.events.Attribute> atts = event.asStartElement().getAttributes();
        while (atts.hasNext()) {
            javax.xml.stream.events.Attribute att = atts.next();
            String prefix = att.getName().getPrefix();
            org.jdom.Namespace ns = prefix == null || prefix.length() == 0 ? org.jdom.Namespace.NO_NAMESPACE : result.getNamespace(prefix);
            Attribute attr = new Attribute(att.getName().getLocalPart(), att.getValue(), XmlElementReader.resolveAttrType(att.getDTDType()), ns);
            result.setAttribute(attr);
        }
        return result;
    }

    static {
        attrTypes.put("CDATA", 1);
        attrTypes.put("cdata", 1);
        attrTypes.put("ID", 2);
        attrTypes.put("id", 2);
        attrTypes.put("IDREF", 3);
        attrTypes.put("idref", 3);
        attrTypes.put("IDREFS", 4);
        attrTypes.put("idrefs", 4);
        attrTypes.put("ENTITY", 5);
        attrTypes.put("entity", 5);
        attrTypes.put("ENTITIES", 6);
        attrTypes.put("entities", 6);
        attrTypes.put("NMTOKEN", 7);
        attrTypes.put("nmtoken", 7);
        attrTypes.put("NMTOKENS", 8);
        attrTypes.put("nmtokens", 8);
        attrTypes.put("NOTATION", 9);
        attrTypes.put("notation", 9);
        attrTypes.put("ENUMERATED", 10);
        attrTypes.put("enumerated", 10);
    }

    private static class EqualityTest
    extends NameTest {
        private QName name;

        public EqualityTest(String nameTest, List<org.jdom.Namespace> namespaces) {
            String[] nameParts = nameTest.split(":");
            if (nameParts.length == 1) {
                this.name = new QName(nameParts[0]);
            } else {
                this.getQName(namespaces, nameParts[0], nameParts[1]);
            }
        }

        private void getQName(List<org.jdom.Namespace> namespaces, String prefix, String localName) {
            for (org.jdom.Namespace namespace : namespaces) {
                if (!prefix.equals(namespace.getPrefix())) continue;
                this.name = new QName(namespace.getURI(), localName, prefix);
                return;
            }
            throw new IllegalArgumentException("Namespace prefix not defined");
        }

        @Override
        public boolean matches(QName name) {
            return this.name.equals(name);
        }
    }

    private static class WildcardTest
    extends NameTest {
        @Override
        public boolean matches(QName name) {
            return true;
        }
    }

    private static abstract class NameTest {
        private NameTest() {
        }

        public static NameTest newTest(String nameTest, List<org.jdom.Namespace> namespaces) {
            if (nameTest.equals("*")) {
                return new WildcardTest();
            }
            return new EqualityTest(nameTest, namespaces);
        }

        public abstract boolean matches(QName var1);
    }

    private static class MatchExpression {
        private boolean absolute;
        private NameTest[] tests;

        public MatchExpression(String path, List<org.jdom.Namespace> namespaces) {
            if (path.startsWith("/")) {
                this.absolute = true;
                path = path.replaceFirst("/", "");
            } else {
                this.absolute = false;
            }
            String[] nameTests = path.split("/");
            ArrayList<NameTest> tests = new ArrayList<NameTest>();
            for (String nameTest : nameTests) {
                tests.add(NameTest.newTest(nameTest, namespaces));
            }
            this.tests = tests.toArray(new NameTest[0]);
        }

        public boolean matches(QName[] names) {
            if (this.absolute && names.length != this.tests.length) {
                return false;
            }
            if (this.tests.length > names.length) {
                return false;
            }
            int i = names.length - 1;
            for (int j = this.tests.length - 1; i >= 0 && j >= 0; --i, --j) {
                if (this.tests[j].matches(names[i])) continue;
                return false;
            }
            return true;
        }
    }
}

