/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.fields;

import io.searchbox.action.AbstractAction;
import io.searchbox.action.GenericResultAbstractAction;
import io.searchbox.client.config.ElasticsearchVersion;
import java.util.HashMap;

public class FieldCapabilities
extends GenericResultAbstractAction {
    protected FieldCapabilities(Builder builder) {
        super(builder);
        this.indexName = builder.index;
        HashMap<String, Object> fieldStatsBody = new HashMap<String, Object>();
        fieldStatsBody.put("fields", builder.fields);
        this.payload = fieldStatsBody;
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    protected String buildURI(ElasticsearchVersion elasticsearchVersion) {
        String buildURI = super.buildURI(elasticsearchVersion);
        if (buildURI.isEmpty()) {
            return "_field_caps";
        }
        return buildURI + "/_field_caps";
    }

    public static class Builder
    extends AbstractAction.Builder<FieldCapabilities, Builder> {
        private String index;
        private Object fields;

        public Builder(Object fields) {
            this.fields = fields;
        }

        public Builder setIndex(String index) {
            this.index = index;
            return this;
        }

        public Builder setLevel(String level) {
            this.parameters.put((Object)"level", (Object)level);
            return this;
        }

        @Override
        public FieldCapabilities build() {
            return new FieldCapabilities(this);
        }
    }
}

