/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.ES6ModuleLoader;
import com.google.javascript.jscomp.Es6ToEs3Converter;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ProcessCommonJSModules;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public final class ProcessEs6Modules
extends NodeTraversal.AbstractPostOrderCallback {
    private static final String MODULE_SLASH = "/";
    private static final String MODULE_NAME_SEPARATOR = "\\$";
    private static final String MODULE_NAME_PREFIX = "module$";
    private static final String DEFAULT_EXPORT_NAME = "$jscompDefaultExport";
    private final ES6ModuleLoader loader;
    private final Compiler compiler;
    private int scriptNodeCount = 0;
    private Map<String, NameNodePair> exportMap = new LinkedHashMap<String, NameNodePair>();
    private Map<String, ModuleOriginalNamePair> importMap = new HashMap<String, ModuleOriginalNamePair>();
    private Set<String> classes = new HashSet<String>();
    private Set<String> typedefs = new HashSet<String>();
    private Set<String> alreadyRequired = new HashSet<String>();
    private boolean isEs6Module;
    private boolean reportDependencies;

    public ProcessEs6Modules(Compiler compiler, ES6ModuleLoader loader, boolean reportDependencies) {
        this.compiler = compiler;
        this.loader = loader;
        this.reportDependencies = reportDependencies;
    }

    public void processFile(Node root) {
        ProcessCommonJSModules.FindGoogProvideOrGoogModule finder = new ProcessCommonJSModules.FindGoogProvideOrGoogModule();
        NodeTraversal.traverse(this.compiler, root, finder);
        if (finder.isFound()) {
            return;
        }
        this.isEs6Module = false;
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isImport()) {
            this.isEs6Module = true;
            this.visitImport(t, n, parent);
        } else if (n.isExport()) {
            this.isEs6Module = true;
            this.visitExport(t, n, parent);
        } else if (n.isScript()) {
            ++this.scriptNodeCount;
            this.visitScript(t, n);
        }
    }

    private void visitImport(NodeTraversal t, Node importDecl, Node parent) {
        String importName = importDecl.getLastChild().getString();
        String loadAddress = this.loader.locate(importName, t.getInput());
        try {
            this.loader.load(loadAddress);
        }
        catch (ES6ModuleLoader.LoadFailedException e) {
            this.compiler.report(t.makeError(importDecl, ES6ModuleLoader.LOAD_ERROR, importName));
        }
        String moduleName = ProcessEs6Modules.toModuleName(loadAddress);
        LinkedHashSet<String> namesToRequire = new LinkedHashSet<String>();
        for (Node child : importDecl.children()) {
            if (child.isEmpty() || child.isString()) continue;
            if (child.isName()) {
                this.importMap.put(child.getString(), new ModuleOriginalNamePair(moduleName, "default"));
                namesToRequire.add("default");
                continue;
            }
            if (child.getType() == 166) {
                for (Node grandChild : child.children()) {
                    String origName = grandChild.getFirstChild().getString();
                    namesToRequire.add(origName);
                    if (grandChild.getChildCount() == 2) {
                        this.importMap.put(grandChild.getLastChild().getString(), new ModuleOriginalNamePair(moduleName, origName));
                        continue;
                    }
                    this.importMap.put(origName, new ModuleOriginalNamePair(moduleName, origName));
                }
                continue;
            }
            Preconditions.checkState((child.getType() == 168 ? 1 : 0) != 0, (String)"Expected an IMPORT_STAR node, but was: %s", (Object[])new Object[]{child});
            this.importMap.put(child.getString(), new ModuleOriginalNamePair(moduleName, ""));
        }
        Node script = NodeUtil.getEnclosingScript(parent);
        if (this.alreadyRequired.add(moduleName)) {
            Node require = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "goog.require"), IR.string(moduleName)));
            require.copyInformationFromForTree(importDecl);
            script.addChildToFront(require);
            if (this.reportDependencies) {
                t.getInput().addRequire(moduleName);
            }
        }
        parent.removeChild(importDecl);
        this.compiler.reportCodeChange();
    }

    private void visitExport(NodeTraversal t, Node export, Node parent) {
        if (export.getBooleanProp(62)) {
            Node child = export.getFirstChild();
            String name = null;
            if (child.isFunction()) {
                name = NodeUtil.getFunctionName(child);
            } else if (child.isClass()) {
                name = NodeUtil.getClassName(child);
            }
            if (name != null) {
                Node decl = child.cloneTree();
                decl.setJSDocInfo(export.getJSDocInfo());
                parent.replaceChild(export, decl);
                this.exportMap.put("default", new NameNodePair(name, child));
            } else {
                Node var = IR.var(IR.name(DEFAULT_EXPORT_NAME), export.removeFirstChild());
                var.useSourceInfoIfMissingFromForTree(export);
                parent.replaceChild(export, var);
                this.exportMap.put("default", new NameNodePair(DEFAULT_EXPORT_NAME, child));
            }
        } else if (export.getBooleanProp(63)) {
            this.compiler.report(JSError.make(export, Es6ToEs3Converter.CANNOT_CONVERT_YET, "Wildcard export"));
        } else if (export.getChildCount() == 2) {
            Node moduleIdentifier = export.getLastChild();
            Node importNode = new Node(165, moduleIdentifier.cloneNode());
            importNode.copyInformationFrom(export);
            parent.addChildBefore(importNode, export);
            this.visit(t, importNode, parent);
            String loadAddress = this.loader.locate(moduleIdentifier.getString(), t.getInput());
            String moduleName = ProcessEs6Modules.toModuleName(loadAddress);
            for (Node exportSpec : export.getFirstChild().children()) {
                String nameFromOtherModule = exportSpec.getFirstChild().getString();
                String exportedName = exportSpec.getLastChild().getString();
                this.exportMap.put(exportedName, new NameNodePair(moduleName + "." + nameFromOtherModule, exportSpec));
            }
            parent.removeChild(export);
        } else {
            if (export.getFirstChild().getType() == 170) {
                for (Node exportSpec : export.getFirstChild().children()) {
                    Node origName = exportSpec.getFirstChild();
                    this.exportMap.put(exportSpec.getChildCount() == 2 ? exportSpec.getLastChild().getString() : origName.getString(), new NameNodePair(origName.getString(), exportSpec));
                }
                parent.removeChild(export);
            } else {
                Node maybeName;
                Node declaration = export.getFirstChild();
                for (int i = 0; i < declaration.getChildCount() && (maybeName = declaration.getChildAtIndex(i)).isName() && (!declaration.isClass() || i <= 0); ++i) {
                    String name = maybeName.getString();
                    Var v = t.getScope().getVar(name);
                    if (v == null || v.isGlobal()) {
                        this.exportMap.put(name, new NameNodePair(name, maybeName));
                    }
                    if (declaration.isClass()) {
                        this.classes.add(name);
                    }
                    if (export.getJSDocInfo() == null || !export.getJSDocInfo().hasTypedefType()) continue;
                    this.typedefs.add(name);
                }
                declaration.setJSDocInfo(export.getJSDocInfo());
                export.setJSDocInfo(null);
                parent.replaceChild(export, declaration.detachFromParent());
            }
            this.compiler.reportCodeChange();
        }
    }

    private void visitScript(NodeTraversal t, Node script) {
        JSDocInfoBuilder jsDocInfo;
        if (!this.isEs6Module) {
            return;
        }
        Preconditions.checkArgument((this.scriptNodeCount == 1 ? 1 : 0) != 0, (Object)"ProcessEs6Modules supports only one invocation per CompilerInput / script node");
        this.rewriteRequires(script);
        String moduleName = ProcessEs6Modules.toModuleName(this.loader.getLoadAddress(t.getInput()));
        if (!this.exportMap.isEmpty()) {
            Node objectlit = IR.objectlit(new Node[0]);
            Node node = IR.var(IR.name(moduleName), objectlit).useSourceInfoIfMissingFromForTree(script);
            script.addChildToBack(node);
        }
        for (Map.Entry entry : this.exportMap.entrySet()) {
            String exportedName = (String)entry.getKey();
            String withSuffix = ((NameNodePair)entry.getValue()).name;
            Node nodeForSourceInfo = ((NameNodePair)entry.getValue()).nodeForSourceInfo;
            Node getProp = IR.getprop(IR.name(moduleName), IR.string(exportedName));
            if (this.typedefs.contains(exportedName)) {
                JSDocInfoBuilder builder = new JSDocInfoBuilder(true);
                JSTypeExpression typeExpr = new JSTypeExpression(IR.string(exportedName), script.getSourceFileName());
                builder.recordTypedef(typeExpr);
                JSDocInfo info = builder.build();
                getProp.setJSDocInfo(info);
                Node exprResult = IR.exprResult(getProp).useSourceInfoIfMissingFromForTree(nodeForSourceInfo);
                script.addChildToBack(exprResult);
                continue;
            }
            Node assign = IR.assign(getProp, NodeUtil.newQName(this.compiler, withSuffix));
            Node exprResult = IR.exprResult(assign).useSourceInfoIfMissingFromForTree(nodeForSourceInfo);
            if (this.classes.contains(exportedName)) {
                JSDocInfoBuilder builder = new JSDocInfoBuilder(true);
                builder.recordConstancy();
                JSDocInfo info = builder.build();
                assign.setJSDocInfo(info);
            }
            script.addChildToBack(exprResult);
        }
        NodeTraversal.traverse(this.compiler, script, new RenameGlobalVars(moduleName));
        if (!this.exportMap.isEmpty()) {
            Node googProvide = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "goog.provide"), IR.string(moduleName)));
            script.addChildToFront(googProvide.copyInformationFromForTree(script));
            if (this.reportDependencies) {
                t.getInput().addProvide(moduleName);
            }
        }
        JSDocInfoBuilder jSDocInfoBuilder = jsDocInfo = script.getJSDocInfo() == null ? new JSDocInfoBuilder(false) : JSDocInfoBuilder.copyFrom(script.getJSDocInfo());
        if (!jsDocInfo.isPopulatedWithFileOverview()) {
            jsDocInfo.recordFileOverview("");
        }
        jsDocInfo.recordSuppressions((Set<String>)ImmutableSet.of((Object)"missingProvide", (Object)"missingRequire"));
        script.setJSDocInfo(jsDocInfo.build());
        this.exportMap.clear();
        this.compiler.reportCodeChange();
    }

    private void rewriteRequires(Node script) {
        NodeTraversal.traverse(this.compiler, script, new NodeTraversal.AbstractShallowCallback(){

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (n.isCall() && n.getFirstChild().matchesQualifiedName("goog.require") && parent.isName()) {
                    this.visitRequire(n, parent);
                }
            }

            private void visitRequire(Node requireCall, Node parent) {
                String namespace = requireCall.getLastChild().getString();
                Node replacement = NodeUtil.newQName(ProcessEs6Modules.this.compiler, namespace).srcrefTree(requireCall);
                parent.replaceChild(requireCall, replacement);
                Node varNode = parent.getParent();
                varNode.getParent().addChildBefore(IR.exprResult(requireCall).srcrefTree(requireCall), varNode);
            }
        });
    }

    public static String toModuleName(String filename) {
        return MODULE_NAME_PREFIX + filename.replaceAll("^\\." + Pattern.quote(MODULE_SLASH), "").replaceAll(Pattern.quote(MODULE_SLASH), MODULE_NAME_SEPARATOR).replaceAll(Pattern.quote("\\"), MODULE_NAME_SEPARATOR).replaceAll("\\.js$", "").replaceAll("-", "_").replaceAll("\\.", "");
    }

    private static class NameNodePair {
        final String name;
        final Node nodeForSourceInfo;

        private NameNodePair(String name, Node nodeForSourceInfo) {
            this.name = name;
            this.nodeForSourceInfo = nodeForSourceInfo;
        }

        public String toString() {
            return "(" + this.name + ", " + this.nodeForSourceInfo + ")";
        }
    }

    private static class ModuleOriginalNamePair {
        private String module;
        private String originalName;

        private ModuleOriginalNamePair(String module, String originalName) {
            this.module = module;
            this.originalName = originalName;
        }

        public String toString() {
            return "(" + this.module + ", " + this.originalName + ")";
        }
    }

    private class RenameGlobalVars
    extends NodeTraversal.AbstractPostOrderCallback {
        private final String suffix;

        RenameGlobalVars(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            JSDocInfo info = n.getJSDocInfo();
            if (info != null) {
                for (Node typeNode : info.getTypeNodes()) {
                    this.fixTypeNode(t, typeNode);
                }
            }
            if (n.isName()) {
                String name = n.getString();
                if (this.suffix.equals(name)) {
                    return;
                }
                Var var = t.getScope().getVar(name);
                if (var != null && var.isGlobal()) {
                    n.setString(name + "$$" + this.suffix);
                    n.putProp(40, name);
                } else if (var == null && ProcessEs6Modules.this.importMap.containsKey(name)) {
                    ModuleOriginalNamePair pair;
                    if (parent.isCall() && parent.getFirstChild() == n) {
                        parent.putBooleanProp(50, false);
                    }
                    if ((pair = (ModuleOriginalNamePair)ProcessEs6Modules.this.importMap.get(name)).originalName.isEmpty()) {
                        n.getParent().replaceChild(n, IR.name(pair.module).useSourceInfoIfMissingFromForTree(n));
                    } else {
                        n.getParent().replaceChild(n, IR.getprop(IR.name(pair.module), IR.string(pair.originalName)).useSourceInfoIfMissingFromForTree(n));
                    }
                }
            }
        }

        private void fixTypeNode(NodeTraversal t, Node typeNode) {
            if (typeNode.isString()) {
                String name = typeNode.getString();
                if (ES6ModuleLoader.isRelativeIdentifier(name)) {
                    int lastSlash = name.lastIndexOf(47);
                    int endIndex = name.indexOf(46, lastSlash);
                    String localTypeName = null;
                    if (endIndex == -1) {
                        endIndex = name.length();
                    } else {
                        localTypeName = name.substring(endIndex);
                    }
                    String moduleName = name.substring(0, endIndex);
                    String loadAddress = ProcessEs6Modules.this.loader.locate(moduleName, t.getInput());
                    if (loadAddress == null) {
                        ProcessEs6Modules.this.compiler.report(t.makeError(typeNode, ES6ModuleLoader.LOAD_ERROR, moduleName));
                        return;
                    }
                    String globalModuleName = ProcessEs6Modules.toModuleName(loadAddress);
                    typeNode.setString(localTypeName == null ? globalModuleName : globalModuleName + localTypeName);
                } else {
                    Var var;
                    List splitted = Splitter.on((char)'.').limit(2).splitToList((CharSequence)name);
                    String baseName = (String)splitted.get(0);
                    String rest = "";
                    if (splitted.size() == 2) {
                        rest = "." + (String)splitted.get(1);
                    }
                    if ((var = t.getScope().getVar(baseName)) != null && var.isGlobal()) {
                        typeNode.setString(baseName + "$$" + this.suffix + rest);
                    } else if (var == null && ProcessEs6Modules.this.importMap.containsKey(baseName)) {
                        ModuleOriginalNamePair pair = (ModuleOriginalNamePair)ProcessEs6Modules.this.importMap.get(baseName);
                        if (pair.originalName.isEmpty()) {
                            typeNode.setString(pair.module + rest);
                        } else {
                            typeNode.setString(baseName + "$$" + pair.module + rest);
                        }
                    }
                    typeNode.putProp(40, name);
                }
            }
            for (Node child = typeNode.getFirstChild(); child != null; child = child.getNext()) {
                this.fixTypeNode(t, child);
            }
            ProcessEs6Modules.this.compiler.reportCodeChange();
        }
    }
}

