/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

final class ExternExportsPass
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final List<Export> exports = new ArrayList<Export>();
    private final Map<String, Node> definitionMap;
    private final AbstractCompiler compiler;
    private final Node externsRoot;
    private final Map<String, String> mappedPaths;
    private final Set<String> alreadyExportedPaths;
    private List<String> exportSymbolFunctionNames;
    private List<String> exportPropertyFunctionNames;

    ExternExportsPass(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.definitionMap = new HashMap<String, Node>();
        this.externsRoot = IR.block();
        this.externsRoot.setIsSyntheticBlock(true);
        this.alreadyExportedPaths = new HashSet<String>();
        this.mappedPaths = new HashMap<String, String>();
        this.initExportMethods();
    }

    private void initExportMethods() {
        this.exportSymbolFunctionNames = new ArrayList<String>();
        this.exportPropertyFunctionNames = new ArrayList<String>();
        CodingConvention convention = this.compiler.getCodingConvention();
        this.exportSymbolFunctionNames.add(convention.getExportSymbolFunction());
        this.exportPropertyFunctionNames.add(convention.getExportPropertyFunction());
        this.exportSymbolFunctionNames.add("google_exportSymbol");
        this.exportPropertyFunctionNames.add("google_exportProperty");
    }

    @Override
    public void process(Node externs, Node root) {
        new NodeTraversal(this.compiler, this).traverse(root);
        TreeSet<Export> sorted = new TreeSet<Export>(new Comparator<Export>(){

            @Override
            public int compare(Export e1, Export e2) {
                return e1.getExportedPath().compareTo(e2.getExportedPath());
            }
        });
        sorted.addAll(this.exports);
        for (Export export : sorted) {
            export.generateExterns();
        }
    }

    public String getGeneratedExterns() {
        CodePrinter.Builder builder = new CodePrinter.Builder(this.externsRoot).setPrettyPrint(true).setOutputTypes(true).setTypeRegistry(this.compiler.getTypeIRegistry());
        return builder.build();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 33: 
            case 38: {
                String name = n.getQualifiedName();
                if (name == null) {
                    return;
                }
                if (parent.isAssign() || parent.isVar() || parent.isFunction()) {
                    this.definitionMap.put(name, parent);
                }
                if (!parent.isCall()) {
                    return;
                }
                if (this.exportPropertyFunctionNames.contains(name)) {
                    this.handlePropertyExport(parent);
                }
                if (!this.exportSymbolFunctionNames.contains(name)) break;
                this.handleSymbolExport(parent);
            }
        }
    }

    private void handleSymbolExport(Node parent) {
        if (parent.getChildCount() != 3) {
            return;
        }
        Node thisNode = parent.getFirstChild();
        Node nameArg = thisNode.getNext();
        Node valueArg = nameArg.getNext();
        if (!nameArg.isString()) {
            return;
        }
        this.exports.add(new SymbolExport(nameArg.getString(), valueArg));
    }

    private void handlePropertyExport(Node parent) {
        if (parent.getChildCount() != 4) {
            return;
        }
        Node thisNode = parent.getFirstChild();
        Node objectArg = thisNode.getNext();
        Node nameArg = objectArg.getNext();
        Node valueArg = nameArg.getNext();
        if (!objectArg.isQualifiedName()) {
            return;
        }
        if (!nameArg.isString()) {
            return;
        }
        this.exports.add(new PropertyExport(objectArg.getQualifiedName(), nameArg.getString(), valueArg));
    }

    private class PropertyExport
    extends Export {
        private final String exportPath;

        public PropertyExport(String exportPath, String symbolName, Node value) {
            super(symbolName, value);
            this.exportPath = exportPath;
        }

        @Override
        String getExportedPath() {
            List pieces = Splitter.on((char)'.').splitToList((CharSequence)this.exportPath);
            for (int i = pieces.size(); i > 0; --i) {
                String cPath = Joiner.on((String)".").join(Iterables.limit((Iterable)pieces, (int)i));
                if (!ExternExportsPass.this.mappedPaths.containsKey(cPath)) continue;
                String newPath = (String)ExternExportsPass.this.mappedPaths.get(cPath);
                if (i < pieces.size()) {
                    newPath = newPath + "." + Joiner.on((String)".").join(Iterables.skip((Iterable)pieces, (int)i));
                }
                return newPath + "." + this.symbolName;
            }
            return this.exportPath + "." + this.symbolName;
        }
    }

    private class SymbolExport
    extends Export {
        public SymbolExport(String symbolName, Node value) {
            super(symbolName, value);
            String qualifiedName = value.getQualifiedName();
            if (qualifiedName != null) {
                ExternExportsPass.this.mappedPaths.put(qualifiedName, symbolName);
            }
        }

        @Override
        String getExportedPath() {
            return this.symbolName;
        }
    }

    private abstract class Export {
        protected final String symbolName;
        protected final Node value;

        Export(String symbolName, Node value) {
            this.symbolName = symbolName;
            this.value = value;
        }

        void generateExterns() {
            this.appendExtern(this.getExportedPath(), this.getValue(this.value));
        }

        abstract String getExportedPath();

        void appendExtern(String path, Node valueToExport) {
            List<String> pathPrefixes = this.computePathPrefixes(path);
            for (int i = 0; i < pathPrefixes.size(); ++i) {
                Node initializer;
                boolean skipPathPrefix;
                String pathPrefix = pathPrefixes.get(i);
                boolean isCompletePathPrefix = i == pathPrefixes.size() - 1;
                boolean bl = skipPathPrefix = pathPrefix.endsWith(".prototype") || ExternExportsPass.this.alreadyExportedPaths.contains(pathPrefix) && !isCompletePathPrefix;
                if (skipPathPrefix) continue;
                if (isCompletePathPrefix && valueToExport != null) {
                    if (valueToExport.isFunction()) {
                        initializer = this.createExternFunction(valueToExport);
                    } else {
                        Preconditions.checkState((boolean)valueToExport.isObjectLit());
                        initializer = this.createExternObjectLit(valueToExport);
                    }
                } else {
                    initializer = IR.empty();
                }
                this.appendPathDefinition(pathPrefix, initializer);
            }
        }

        private List<String> computePathPrefixes(String path) {
            List pieces = Splitter.on((char)'.').splitToList((CharSequence)path);
            ArrayList<String> pathPrefixes = new ArrayList<String>();
            for (int i = 0; i < pieces.size(); ++i) {
                pathPrefixes.add(Joiner.on((String)".").join(Iterables.limit((Iterable)pieces, (int)(i + 1))));
            }
            return pathPrefixes;
        }

        private void appendPathDefinition(String path, Node initializer) {
            Node pathDefinition;
            if (!path.contains(".")) {
                pathDefinition = initializer.isEmpty() ? IR.var(IR.name(path)) : NodeUtil.newVarNode(path, initializer);
            } else {
                Node qualifiedPath = NodeUtil.newQName(ExternExportsPass.this.compiler, path);
                pathDefinition = initializer.isEmpty() ? NodeUtil.newExpr(qualifiedPath) : NodeUtil.newExpr(IR.assign(qualifiedPath, initializer));
            }
            ExternExportsPass.this.externsRoot.addChildToBack(pathDefinition);
            ExternExportsPass.this.alreadyExportedPaths.add(path);
        }

        private Node createExternFunction(Node exportedFunction) {
            Node paramList = NodeUtil.getFunctionParameters(exportedFunction).cloneTree();
            for (Node param = paramList.getFirstChild(); param != null && param.isName(); param = param.getNext()) {
                String originalName = (String)param.getProp(40);
                if (originalName == null) continue;
                param.setString(originalName);
            }
            Node externFunction = IR.function(IR.name(""), paramList, IR.block());
            externFunction.setJSType(exportedFunction.getJSType());
            return externFunction;
        }

        private JSDocInfo buildEmptyJSDoc() {
            return new JSDocInfoBuilder(false).build(true);
        }

        private Node createExternObjectLit(Node exportedObjectLit) {
            Node lit = IR.objectlit(new Node[0]);
            lit.setJSType(exportedObjectLit.getJSType());
            lit.setJSDocInfo(this.buildEmptyJSDoc());
            int index = 1;
            for (Node child = exportedObjectLit.getFirstChild(); child != null; child = child.getNext()) {
                if (!child.isStringKey()) continue;
                lit.addChildToBack(IR.propdef(IR.stringKey(child.getString()), IR.number(index++)));
            }
            return lit;
        }

        protected Node getValue(Node qualifiedNameNode) {
            Node definition;
            String qualifiedName = this.value.getQualifiedName();
            if (qualifiedName == null) {
                return null;
            }
            Node definitionParent = (Node)ExternExportsPass.this.definitionMap.get(qualifiedName);
            if (definitionParent == null) {
                return null;
            }
            switch (definitionParent.getType()) {
                case 86: {
                    definition = definitionParent.getLastChild();
                    break;
                }
                case 118: {
                    definition = definitionParent.getLastChild().getLastChild();
                    break;
                }
                case 105: {
                    if (NodeUtil.isFunctionDeclaration(definitionParent)) {
                        definition = definitionParent;
                        break;
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
            if (!definition.isFunction() && !definition.isObjectLit()) {
                return null;
            }
            return definition;
        }
    }
}

