/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.util.http;

import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CookieManager {
    private Map _cookiesPerHost = new HashMap();

    public void extractCookies(URLConnection urlConnection) {
        Map<String, List<String>> headerFields = urlConnection.getHeaderFields();
        List<String> cookieHeaders = headerFields.get("Set-Cookie");
        if (!cookieHeaders.isEmpty()) {
            String hostName = urlConnection.getURL().getHost();
            HashMap<String, Cookie> cookieMap = (HashMap<String, Cookie>)this._cookiesPerHost.get(hostName);
            if (cookieMap == null) {
                cookieMap = new HashMap<String, Cookie>();
                this._cookiesPerHost.put(hostName, cookieMap);
            }
            for (int i = 0; i < cookieHeaders.size(); ++i) {
                String cookieHeader = cookieHeaders.get(i);
                Cookie cookie = this._parseCookieHeader(cookieHeader);
                cookieMap.put(cookie.getName(), cookie);
            }
        }
    }

    public void setCookies(URLConnection urlConnection) {
        String hostName = urlConnection.getURL().getHost();
        Map cookieMap = (Map)this._cookiesPerHost.get(hostName);
        if (cookieMap != null && !cookieMap.isEmpty()) {
            StringBuffer headerValue = new StringBuffer(64);
            Iterator cookieIter = cookieMap.values().iterator();
            while (cookieIter.hasNext()) {
                Cookie cookie = (Cookie)cookieIter.next();
                headerValue.append(cookie.getName());
                headerValue.append('=');
                headerValue.append(cookie.getValue());
                if (!cookieIter.hasNext()) continue;
                headerValue.append("; ");
            }
            urlConnection.setRequestProperty("Cookie", headerValue.toString());
        }
    }

    public void clear() {
        this._cookiesPerHost.clear();
    }

    public void clear(String hostName) {
        this._cookiesPerHost.remove(hostName);
    }

    private Cookie _parseCookieHeader(String headerValue) {
        int equalsIdx = headerValue.indexOf(61);
        if (equalsIdx == -1) {
            throw new IllegalArgumentException("Unable to parse header value: " + headerValue);
        }
        int semiColonIdx = headerValue.indexOf(59, equalsIdx);
        if (semiColonIdx != -1) {
            headerValue = headerValue.substring(0, semiColonIdx);
        }
        String name = headerValue.substring(0, equalsIdx);
        String value = headerValue.substring(equalsIdx + 1);
        return new Cookie(name, value);
    }

    static class Cookie {
        private String _name;
        private String _value;

        public Cookie(String name, String value) {
            this._name = name;
            this._value = value;
        }

        public String getName() {
            return this._name;
        }

        public String getValue() {
            return this._value;
        }
    }
}

