/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.inspireatom;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.InspireAtomFeed;
import org.fao.geonet.domain.InspireAtomFeedEntry;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.exceptions.MetadataNotFoundEx;
import org.fao.geonet.exceptions.ResourceNotFoundEx;
import org.fao.geonet.inspireatom.InspireAtomService;
import org.fao.geonet.inspireatom.harvester.InspireAtomHarvester;
import org.fao.geonet.inspireatom.model.DatasetFeedInfo;
import org.fao.geonet.inspireatom.util.InspireAtomUtil;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.search.LuceneSearcher;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.InspireAtomFeedRepository;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;

public class AtomServiceDescription
implements Service {
    private static final String SERVICE_IDENTIFIER_PARAM = "fileIdentifier";

    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        String atomUrl;
        InspireAtomHarvester inspireAtomHarvester;
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dm = (DataManager)context.getBean(DataManager.class);
        SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
        boolean inspireEnable = sm.getValueAsBool("system/inspire/enable");
        if (!inspireEnable) {
            Log.info((String)"geonetwork.atom", (Object)"Inspire is disabled");
            throw new Exception("Inspire is disabled");
        }
        String fileIdentifier = Util.getParam((Element)params, (String)SERVICE_IDENTIFIER_PARAM, (String)"");
        if (StringUtils.isEmpty((String)fileIdentifier)) {
            return new Element("response");
        }
        InspireAtomService service = (InspireAtomService)context.getBean(InspireAtomService.class);
        String id = dm.getMetadataId(fileIdentifier);
        if (id == null) {
            throw new MetadataNotFoundEx("Metadata not found.");
        }
        Element md = dm.getMetadata(id);
        String schema = dm.getMetadataSchema(id);
        String atomProtocol = sm.getValue("system/inspire/atomProtocol");
        Lib.resource.checkPrivilege(context, id, ReservedOperation.view);
        if (!InspireAtomUtil.isServiceMetadata(dm, schema, md)) {
            throw new Exception("No service metadata found with uuid:" + fileIdentifier);
        }
        Object datasetIdentifiers = null;
        InspireAtomFeed inspireAtomFeed = service.findByMetadataId(Integer.parseInt(id));
        if (inspireAtomFeed == null) {
            String serviceFeedUrl = InspireAtomUtil.extractAtomFeedUrl(schema, md, dm, atomProtocol);
            if (StringUtils.isEmpty((String)serviceFeedUrl)) {
                throw new ResourceNotFoundEx("No atom feed for service metadata found with uuid:" + fileIdentifier);
            }
            inspireAtomHarvester = new InspireAtomHarvester(gc);
            inspireAtomHarvester.harvestServiceMetadata(context, id);
            inspireAtomFeed = service.findByMetadataId(Integer.parseInt(id));
            if (inspireAtomFeed == null) {
                throw new ResourceNotFoundEx("No atom feed for service metadata found with uuid:" + fileIdentifier);
            }
        }
        if (StringUtils.isEmpty((String)(atomUrl = inspireAtomFeed.getAtomUrl()))) {
            atomUrl = InspireAtomUtil.extractAtomFeedUrl(schema, md, dm, atomProtocol);
            if (StringUtils.isEmpty((String)atomUrl)) {
                throw new Exception("Metadata has no atom feed");
            }
            inspireAtomHarvester = new InspireAtomHarvester(gc);
            inspireAtomHarvester.harvestServiceMetadata(context, id);
            inspireAtomFeed = service.findByMetadataId(Integer.parseInt(id));
        }
        List<DatasetFeedInfo> datasetsInformation = InspireAtomUtil.extractRelatedDatasetsInfoFromServiceFeed(inspireAtomFeed.getAtom(), dm);
        String feedAuthorName = inspireAtomFeed.getAuthorName();
        String feedTitle = inspireAtomFeed.getTitle();
        String feedSubtitle = inspireAtomFeed.getSubtitle();
        String feedLang = inspireAtomFeed.getLang();
        String feedUrl = inspireAtomFeed.getAtomUrl();
        String keywords = LuceneSearcher.getMetadataFromIndex((String)context.getLanguage(), (String)fileIdentifier, (String)"keyword");
        Element datasetsEl = this.processDatasetsInfo(datasetsInformation, fileIdentifier, context);
        return new Element("response").addContent((Content)new Element("fileId").setText(fileIdentifier)).addContent((Content)new Element("title").setText(feedTitle)).addContent((Content)new Element("subtitle").setText(feedSubtitle)).addContent((Content)new Element("lang").setText(feedLang)).addContent((Content)new Element("keywords").setText(keywords)).addContent((Content)new Element("authorName").setText(feedAuthorName)).addContent((Content)new Element("url").setText(feedUrl)).addContent((Content)datasetsEl);
    }

    private Element processDatasetsInfo(List<DatasetFeedInfo> datasetsInformation, String serviceIdentifier, ServiceContext context) throws Exception {
        Element datasetsEl = new Element("datasets");
        InspireAtomFeedRepository repository = (InspireAtomFeedRepository)context.getBean(InspireAtomFeedRepository.class);
        DataManager dm = (DataManager)context.getBean(DataManager.class);
        for (DatasetFeedInfo datasetFeedInfo : datasetsInformation) {
            Integer count;
            String datasetUuid = repository.retrieveDatasetUuidFromIdentifier(datasetFeedInfo.identifier);
            if (StringUtils.isEmpty((String)datasetUuid)) {
                Log.warning((String)"geonetwork.atom", (Object)("AtomServiceDescription for service metadata (" + serviceIdentifier + "): metadata for dataset identifier " + datasetFeedInfo.identifier + " is not found, ignoring it."));
                continue;
            }
            String id = dm.getMetadataId(datasetUuid);
            InspireAtomFeed inspireAtomFeed = repository.findByMetadataId(Integer.parseInt(id));
            String idNs = inspireAtomFeed.getAtomDatasetid();
            String namespace = inspireAtomFeed.getAtomDatasetns();
            if (StringUtils.isEmpty((String)idNs)) {
                Log.warning((String)"geonetwork.atom", (Object)("AtomServiceDescription for service metadata (" + serviceIdentifier + "): dataset with uuid " + datasetUuid + " has no dataset identifier/namespace, ignoring it."));
                continue;
            }
            String atomUrl = inspireAtomFeed.getAtomUrl();
            if (StringUtils.isEmpty((String)atomUrl)) {
                Log.warning((String)"geonetwork.atom", (Object)("AtomServiceDescription for service metadata (" + serviceIdentifier + "): dataset with uuid " + datasetUuid + " has no dataset feed, ignoring it."));
                continue;
            }
            Element datasetEl = this.buildDatasetInfo(idNs, namespace);
            datasetEl.addContent((Content)new Element("atom_url").setText(atomUrl));
            HashMap<String, Integer> downloadsCountByCrs = new HashMap<String, Integer>();
            for (InspireAtomFeedEntry entry : inspireAtomFeed.getEntryList()) {
                count = (Integer)downloadsCountByCrs.get(entry.getCrs());
                if (count == null) {
                    count = 0;
                }
                downloadsCountByCrs.put(entry.getCrs(), count + 1);
            }
            for (InspireAtomFeedEntry entry : inspireAtomFeed.getEntryList()) {
                count = (Integer)downloadsCountByCrs.get(entry.getCrs());
                if (count == null) continue;
                Element downloadEl = new Element("file");
                downloadEl.addContent((Content)new Element("title").setText(entry.getTitle()));
                downloadEl.addContent((Content)new Element("lang").setText(entry.getLang()));
                downloadEl.addContent((Content)new Element("url").setText(entry.getUrl()));
                if (count > 1) {
                    downloadEl.addContent((Content)new Element("type").setText("application/atom+xml"));
                } else {
                    downloadEl.addContent((Content)new Element("type").setText(entry.getType()));
                }
                downloadEl.addContent((Content)new Element("crs").setText(entry.getCrs()));
                datasetEl.addContent((Content)downloadEl);
                downloadsCountByCrs.remove(entry.getCrs());
            }
            datasetsEl.addContent((Content)datasetEl);
        }
        return datasetsEl;
    }

    private Element buildDatasetInfo(String identifier, String namespace) {
        Element datasetEl = new Element("dataset");
        Element codeEl = new Element("code");
        codeEl.setText(identifier);
        Element namespaceEl = new Element("namespace");
        namespaceEl.setText(namespace);
        datasetEl.addContent((Content)codeEl);
        datasetEl.addContent((Content)namespaceEl);
        return datasetEl;
    }
}

