/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.sources;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.fao.geonet.domain.HarvesterSetting;
import org.fao.geonet.domain.Setting;
import org.fao.geonet.domain.SettingDataType;
import org.fao.geonet.domain.Source;
import org.fao.geonet.domain.responses.OkResponse;
import org.fao.geonet.kernel.setting.HarvesterSettingsManager;
import org.fao.geonet.repository.HarvesterSettingRepository;
import org.fao.geonet.repository.SettingRepository;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.repository.Updater;
import org.fao.geonet.repository.specification.SettingSpec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="source")
@Deprecated
public class SourcesController {
    public static final String PREFIX = "translations-";
    @Autowired
    private SettingRepository settingRepository;
    @Autowired
    private SourceRepository sourceRepository;
    @Autowired
    private HarvesterSettingsManager harvesterSettingsManager;
    @Autowired
    private HarvesterSettingRepository harvesterSettingRepository;

    @RequestMapping(value={"/{portal}/{lang}/source/{uuid}"})
    @ResponseBody
    public OkResponse updateTranslations(@PathVariable String lang, @PathVariable String uuid, HttpServletRequest request) {
        if (((Setting)this.settingRepository.findOne((Serializable)((Object)"system/site/siteId"))).getValue().equals(uuid)) {
            this.updateSite(request);
        }
        if (this.sourceRepository.exists((Serializable)((Object)uuid))) {
            this.updateNormalSource(uuid, request);
        }
        return new OkResponse();
    }

    private void updateSite(HttpServletRequest request) {
        this.settingRepository.deleteAll(SettingSpec.nameStartsWith((String)"system/site/labels/"));
        ArrayList translationSettings = Lists.newArrayList();
        for (Map.Entry stringEntry : request.getParameterMap().entrySet()) {
            String paramName = (String)stringEntry.getKey();
            String[] values = (String[])stringEntry.getValue();
            if (!paramName.startsWith(PREFIX)) continue;
            String lang = paramName.substring(PREFIX.length());
            if (values.length <= 0) continue;
            Setting setting = new Setting().setDataType(SettingDataType.STRING).setInternal(true).setName("system/site/labels/" + lang).setValue(values[0]);
            translationSettings.add(setting);
        }
        this.settingRepository.save((Iterable)translationSettings);
    }

    public void updateNormalSource(String uuid, final HttpServletRequest request) {
        String translationsIdPath;
        HarvesterSetting harvesterUuidSetting = this.harvesterSettingRepository.findOneByNameAndValue("uuid", uuid);
        if (harvesterUuidSetting != null) {
            HarvesterSetting harvesterSite = harvesterUuidSetting.getParent();
            String pathToTranslations = "id:" + harvesterSite.getId() + "/" + "translations";
            List translationsSettings = this.harvesterSettingRepository.findAllByPath(pathToTranslations);
            String translationsSettingId = translationsSettings.isEmpty() ? this.harvesterSettingsManager.add("id:" + harvesterSite.getId(), (Object)"translations", (Object)"") : String.valueOf(((HarvesterSetting)translationsSettings.get(0)).getId());
            translationsIdPath = "id:" + translationsSettingId;
            this.harvesterSettingsManager.removeChildren(translationsIdPath);
        } else {
            translationsIdPath = null;
        }
        this.sourceRepository.update((Serializable)((Object)uuid), (Updater)new Updater<Source>(){

            public void apply(@Nonnull Source source) {
                for (Map.Entry stringEntry : request.getParameterMap().entrySet()) {
                    String paramName = (String)stringEntry.getKey();
                    String[] values = (String[])stringEntry.getValue();
                    if (!paramName.startsWith(SourcesController.PREFIX)) continue;
                    String lang = paramName.substring(SourcesController.PREFIX.length());
                    if (values.length <= 0) continue;
                    if (translationsIdPath != null) {
                        SourcesController.this.harvesterSettingsManager.add(translationsIdPath, (Object)lang, (Object)values[0]);
                    }
                    source.getLabelTranslations().put(lang, values[0]);
                }
            }
        });
    }
}

