/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.registries.vocabularies;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.exception.WebApplicationException;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.ThesaurusFinder;
import org.fao.geonet.kernel.ThesaurusManager;
import org.fao.geonet.kernel.search.KeywordsSearcher;
import org.fao.geonet.kernel.search.keyword.KeywordSearchParamsBuilder;
import org.fao.geonet.kernel.search.keyword.KeywordSearchType;
import org.fao.geonet.kernel.search.keyword.KeywordSort;
import org.fao.geonet.kernel.search.keyword.SortDirection;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.ThesaurusActivationRepository;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import springfox.documentation.annotations.ApiIgnore;

@EnableWebMvc
@Service
@RequestMapping(value={"/{portal}/api/registries/vocabularies", "/{portal}/api/0.1/registries/vocabularies"})
@Api(value="registries", tags={"registries"}, description="Registries related operations")
public class KeywordsApi {
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    SettingManager settingManager;
    @Autowired
    ThesaurusManager thesaurusMan;
    @Autowired
    IsoLanguagesMapper languagesMapper;
    @Autowired
    GeonetworkDataDirectory dataDirectory;
    @Autowired
    ThesaurusActivationRepository thesaurusActivationRepository;
    @Autowired
    GeonetHttpRequestFactory httpRequestFactory;
    @Autowired
    IsoLanguagesMapper mapper;
    @Autowired
    ThesaurusManager thesaurusManager;

    @ApiOperation(value="Search keywords", nickname="searchKeywords", notes="")
    @RequestMapping(path={"/search"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public Object searchKeywords(@ApiParam(value="Query", required=false) @RequestParam(required=false) String q, @ApiParam(value="Query in that language", required=false) @RequestParam(value="lang", defaultValue="eng") String lang, @ApiParam(value="Number of rows", required=false) @RequestParam(required=false, defaultValue="1000") int rows, @ApiParam(value="Start from", required=false) @RequestParam(defaultValue="0", required=false) int start, @ApiParam(value="Return keyword information in one or more languages", required=false) @RequestParam(value="pLang", required=false) List<String> targetLangs, @ApiParam(value="Thesaurus identifier", required=false) @RequestParam(required=false) String[] thesaurus, @ApiParam(value="Type of search", required=false) @RequestParam(defaultValue="CONTAINS") KeywordSearchType type, @ApiParam(value="URI query", required=false) @RequestParam(required=false) String uri, @ApiParam(value="Sort by", required=false) @RequestParam(required=false, defaultValue="DESC") String sort, @ApiIgnore HttpServletRequest request, @ApiIgnore @ApiParam(hidden=true) HttpSession httpSession) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        ServiceContext context = ApiUtils.createServiceContext(request);
        UserSession session = ApiUtils.getUserSession(httpSession);
        if (Log.isDebugEnabled((String)"KeywordsManager")) {
            Log.debug((String)"KeywordsManager", (Object)"Creating new keywords searcher");
        }
        KeywordsSearcher searcher = new KeywordsSearcher(context, (ThesaurusFinder)this.thesaurusMan);
        String thesauriDomainName = null;
        List<String> thesauri = null;
        if (thesaurus != null) {
            thesauri = Arrays.asList(thesaurus);
        }
        KeywordSearchParamsBuilder builder = this.parseBuilder(lang, q, rows, start, targetLangs, thesauri, thesauriDomainName, type, uri, this.languagesMapper);
        if (q == null || q.trim().isEmpty()) {
            builder.setComparator(KeywordSort.defaultLabelSorter((SortDirection)SortDirection.parse((String)sort)));
        } else {
            builder.setComparator(KeywordSort.searchResultsSorter((String)q, (SortDirection)SortDirection.parse((String)sort)));
        }
        searcher.search(builder.build());
        session.setProperty("search.keywords.result", (Object)searcher);
        List keywords = searcher.getResults();
        if ("xml".equals(request.getParameter("_content_type"))) {
            Element root = new Element("response");
            for (KeywordBean kw : keywords) {
                root.addContent((Content)kw.toElement("eng", new String[0]));
            }
            return root;
        }
        return keywords;
    }

    @ApiOperation(value="Get keyword by id", nickname="getKeywordById", notes="Retrieve XML representation of keyword(s) from same thesaurususing different transformations. 'to-iso19139-keyword' is the default and return an ISO19139 snippet.'to-iso19139-keyword-as-xlink' return an XLinked element. Custom transformation can be create on a per schema basis.")
    @RequestMapping(path={"/keyword"}, method={RequestMethod.GET}, produces={"application/xml"})
    @ApiResponses(value={@ApiResponse(code=200, message="XML snippet with requested keywords.")})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public Element getKeywordById(@ApiParam(value="Keyword identifier or list of keyword identifiers comma separated.", required=true) @RequestParam(name="id") String uri, @ApiParam(value="Thesaurus to look info for the keyword(s).", required=true) @RequestParam(name="thesaurus") String sThesaurusName, @ApiParam(value="Languages.", required=false) @RequestParam(name="lang", required=false) String[] langs, @ApiParam(value="Only print the keyword, no thesaurus information.", required=false) @RequestParam(required=false, defaultValue="false") boolean keywordOnly, @ApiParam(value="XSL template to use (ISO19139 keyword by default, see convert.xsl).", required=false) @RequestParam(required=false) String transformation, @ApiParam(value="langMap, that converts the values in the 'lang' parameter to how they will be actually represented in the record. {'fre':'fra'} or {'fre':'fr'}.  Missing/empty means to convert to iso 2 letter.", required=false) @RequestParam(name="langMap", required=false) String langMapJson, @ApiIgnore @RequestParam Map<String, String> allRequestParams, HttpServletRequest request) throws Exception {
        Element descKeys;
        String SEPARATOR = ",";
        ServiceContext context = ApiUtils.createServiceContext(request);
        if (langs == null) {
            langs = context.getLanguage().split(",");
        }
        CharSequence[] iso3langCodes = Arrays.copyOf(langs, langs.length);
        for (int i = 0; i < langs.length; ++i) {
            if (!StringUtils.isNotEmpty((String)langs[i])) continue;
            langs[i] = this.mapper.iso639_2_to_iso639_1(langs[i], langs[i].substring(0, 2));
        }
        if ((uri = URLDecoder.decode(uri, "UTF-8")) == null) {
            descKeys = new Element("descKeys");
        } else {
            KeywordsSearcher searcher = new KeywordsSearcher(context, (ThesaurusFinder)this.thesaurusManager);
            String[] url = !uri.contains(",") ? new String[]{uri} : uri.split(",");
            ArrayList<KeywordBean> kbList = new ArrayList<KeywordBean>();
            for (String currentUri : url) {
                KeywordBean kb = searcher.searchById(currentUri, sThesaurusName, (String[])iso3langCodes);
                if (kb == null) {
                    kb = searcher.searchById(currentUri, sThesaurusName, langs);
                }
                if (kb == null) {
                    kb = searcher.searchById(ApiUtils.fixURIFragment(currentUri), sThesaurusName, (String[])iso3langCodes);
                }
                if (kb == null) {
                    kb = searcher.searchById(ApiUtils.fixURIFragment(currentUri), sThesaurusName, langs);
                }
                if (kb == null) continue;
                kbList.add(kb);
            }
            descKeys = new Element("descKeys");
            for (KeywordBean keywordBean : kbList) {
                KeywordsSearcher.toRawElement((Element)descKeys, (KeywordBean)keywordBean);
            }
        }
        Element langConversion = null;
        if (langMapJson != null && !langMapJson.isEmpty()) {
            JSONObject obj = JSONObject.fromObject((Object)langMapJson);
            langConversion = new Element("languageConversions");
            for (Object entry : obj.entrySet()) {
                String key = ((Map.Entry)entry).getKey().toString();
                String value = ((Map.Entry)entry).getValue().toString();
                Element conv = new Element("conversion");
                conv.setAttribute("from", key.toString());
                conv.setAttribute("to", value.toString().replace("#", ""));
                langConversion.addContent((Content)conv);
            }
        }
        Path convertXsl = this.dataDirectory.getWebappDir().resolve("xslt/services/thesaurus/convert.xsl");
        Element gui = new Element("gui");
        Element nodeUrl = new Element("nodeUrl").setText(this.settingManager.getNodeURL());
        Element nodeId = new Element("nodeId").setText(context.getNodeId());
        Element thesaurusEl = new Element("thesaurus");
        Element root = new Element("root");
        gui.addContent((Content)thesaurusEl);
        thesaurusEl.addContent((Content)this.thesaurusManager.buildResultfromThTable(context));
        Element requestParams = new Element("request");
        for (Map.Entry<String, String> e : allRequestParams.entrySet()) {
            if (e.getKey().equals("lang")) {
                requestParams.addContent((Content)new Element(e.getKey()).setText(String.join((CharSequence)",", iso3langCodes)));
                continue;
            }
            requestParams.addContent((Content)new Element(e.getKey()).setText(e.getValue()));
        }
        if (langConversion != null) {
            requestParams.addContent((Content)langConversion);
        }
        root.addContent((Content)requestParams);
        root.addContent((Content)descKeys);
        root.addContent((Content)gui);
        root.addContent((Content)nodeUrl);
        root.addContent((Content)nodeId);
        Element transform = Xml.transform((Element)root, (Path)convertXsl);
        return transform;
    }

    @ApiOperation(value="Download a thesaurus by name", nickname="getThesaurus", notes="Download the thesaurus in SKOS format.")
    @RequestMapping(value={"/{thesaurus:.+}"}, method={RequestMethod.GET}, produces={"text/xml"})
    @ApiResponses(value={@ApiResponse(code=200, message="Thesaurus in SKOS format."), @ApiResponse(code=404, message="Resource not found.")})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public void getThesaurus(@ApiParam(value="Thesaurus to download.", required=true) @PathVariable(value="thesaurus") String thesaurus, HttpServletResponse response) throws Exception {
        Thesaurus directory = this.thesaurusMan.getThesaurusByName(thesaurus);
        if (directory == null) {
            throw new IllegalArgumentException("Thesaurus not found --> " + thesaurus);
        }
        Path directoryFile = directory.getFile();
        if (!Files.exists(directoryFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Thesaurus file not found --> " + thesaurus);
        }
        response.setContentType("text/xml");
        response.setHeader("Content-Disposition", "attachment;filename=" + directoryFile.getFileName());
        ServletOutputStream out = response.getOutputStream();
        BufferedReader reader1 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(directoryFile.toFile()), Charset.forName("UTF-8")));
        IOUtils.copy((Reader)reader1, (OutputStream)out);
        out.flush();
        out.close();
    }

    @ApiOperation(value="Delete a thesaurus by name", nickname="deleteThesaurus", notes="Delete a thesaurus.")
    @RequestMapping(value={"/{thesaurus:.+}"}, method={RequestMethod.DELETE})
    @ApiResponses(value={@ApiResponse(code=200, message="Thesaurus deleted."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it."), @ApiResponse(code=404, message="Resource not found.")})
    @PreAuthorize(value="hasRole('UserAdmin')")
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteThesaurus(@ApiParam(value="Thesaurus to delete.", required=true) @PathVariable(value="thesaurus") String thesaurus) throws Exception {
        Thesaurus thesaurusObject = this.thesaurusMan.getThesaurusByName(thesaurus);
        if (thesaurusObject == null) {
            throw new ResourceNotFoundException(String.format("Thesaurus with identifier '%s' not found in the catalogue. Should be one of: %s", thesaurus, this.thesaurusMan.getThesauriMap().keySet().toString()));
        }
        Path item = thesaurusObject.getFile();
        this.thesaurusMan.remove(thesaurus);
        if (Files.exists(item, new LinkOption[0])) {
            IO.deleteFile((Path)item, (boolean)true, (String)"geonetwork.thesaurus");
            String thesaurusId = thesaurusObject.getFname();
            if (this.thesaurusActivationRepository.exists((Serializable)((Object)thesaurusId))) {
                this.thesaurusActivationRepository.delete((Serializable)((Object)thesaurusId));
            }
        } else {
            throw new IllegalArgumentException(String.format("Thesaurus RDF file was not found for thesaurus with identifier '%s'.", thesaurus));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Uploads a new thesaurus from a file", nickname="uploadThesaurus", notes="Uploads a new thesaurus.")
    @RequestMapping(method={RequestMethod.POST}, produces={"text/xml"})
    @ApiResponses(value={@ApiResponse(code=201, message="Thesaurus uploaded in SKOS format."), @ApiResponse(code=403, message="Operation not allowed. Only Reviewvers can access it.")})
    @PreAuthorize(value="hasRole('Reviewer')")
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    public String uploadThesaurus(@ApiParam(value="If set, do a file upload.") @RequestParam(value="file", required=false) MultipartFile file, @ApiParam(value="Local or external (default).") @RequestParam(value="type", defaultValue="external") String type, @ApiParam(value="Type of thesaurus, usually one of the ISO thesaurus type codelist value. Default is theme.") @RequestParam(value="dir", defaultValue="theme") String dir, @ApiParam(value="XSL to be use to convert the thesaurus before load. Default _none_.") @RequestParam(value="stylesheet", defaultValue="_none_") String stylesheet, HttpServletRequest request) throws Exception {
        long start = System.currentTimeMillis();
        ServiceContext context = ApiUtils.createServiceContext(request);
        boolean fileUpload = file != null && !file.isEmpty();
        Path rdfFile = null;
        String fname = null;
        File tempDir = null;
        if (!fileUpload) {
            Log.debug((String)"geonetwork.thesaurus", (Object)"No file provided for thesaurus upload.");
            throw new MissingServletRequestParameterException("Thesaurus source not provided", "file");
        }
        Log.debug((String)"geonetwork.thesaurus", (Object)("Uploading thesaurus file: " + file.getOriginalFilename()));
        tempDir = Files.createTempDirectory("thesaurus", new FileAttribute[0]).toFile();
        Path tempFilePath = tempDir.toPath().resolve(file.getOriginalFilename());
        File convFile = tempFilePath.toFile();
        file.transferTo(convFile);
        rdfFile = convFile.toPath();
        fname = file.getOriginalFilename();
        try {
            if (StringUtils.isEmpty((String)fname)) {
                throw new Exception("File upload from URL or file return null");
            }
            if (rdfFile == null || !Files.exists(rdfFile, new LinkOption[0])) {
                throw new MissingServletRequestParameterException("Thesaurus file doesn't exist", "file");
            }
            long fsize = Files.size(rdfFile);
            if (fsize == 0L) {
                throw new MissingServletRequestParameterException("Thesaurus file has zero size", "file");
            }
            String extension = FilenameUtils.getExtension((String)fname);
            if (!extension.equalsIgnoreCase("rdf") && !extension.equalsIgnoreCase("xml")) {
                Log.debug((String)"geonetwork.thesaurus", (Object)("Incorrect extension for thesaurus named: " + fname));
                throw new Exception("Incorrect extension for thesaurus named: " + fname);
            }
            Log.debug((String)"geonetwork.thesaurus", (Object)("Uploading thesaurus: " + fname));
            fname = fname.replace(extension, "rdf");
            this.uploadThesaurus(rdfFile, stylesheet, context, fname, type, dir);
            long end = System.currentTimeMillis();
            long duration = (end - start) / 1000L;
            String string = String.format("Thesaurus '%s' loaded in %d sec.", fname, duration);
            return string;
        }
        finally {
            if (tempDir != null) {
                FileUtils.deleteQuietly((File)tempDir);
            }
        }
    }

    @ApiOperation(value="Uploads a new thesaurus from URL or Registry", nickname="uploadThesaurusFromUrl", notes="Uploads a new thesaurus.")
    @RequestMapping(method={RequestMethod.PUT}, produces={"text/xml"})
    @ApiResponses(value={@ApiResponse(code=201, message="Thesaurus uploaded in SKOS format."), @ApiResponse(code=403, message="Operation not allowed. Only Reviewvers can access it.")})
    @PreAuthorize(value="hasRole('Reviewer')")
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    public String uploadThesaurusFromUrl(@ApiParam(value="If set, try to download from the Internet.") @RequestParam(value="url", required=false) String url, @ApiParam(value="If set, try to download from a registry.") @RequestParam(value="registryUrl", required=false) String registryUrl, @ApiParam(value="Languages to download from a registry.") @RequestParam(value="registryLanguage", required=false) String[] registryLanguage, @ApiParam(value="Local or external (default).") @RequestParam(value="type", defaultValue="external") String type, @ApiParam(value="Type of thesaurus, usually one of the ISO thesaurus type codelist value. Default is theme.") @RequestParam(value="dir", defaultValue="theme") String dir, @ApiParam(value="XSL to be use to convert the thesaurus before load. Default _none_.") @RequestParam(value="stylesheet", defaultValue="_none_") String stylesheet, HttpServletRequest request) throws Exception {
        long start = System.currentTimeMillis();
        ServiceContext context = ApiUtils.createServiceContext(request);
        boolean urlUpload = !StringUtils.isEmpty((String)url);
        boolean registryUpload = !StringUtils.isEmpty((String)registryUrl);
        Path rdfFile = null;
        String fname = null;
        if (urlUpload) {
            Log.debug((String)"geonetwork.thesaurus", (Object)("Uploading thesaurus from URL: " + url));
            rdfFile = this.getXMLContentFromUrl(url, context);
            fname = url.substring(url.lastIndexOf("/") + 1, url.length()).replaceAll("\\s+", "");
            if (fname.lastIndexOf(46) == -1) {
                fname = fname + ".rdf";
            }
        } else if (registryUpload) {
            if (ArrayUtils.isEmpty((Object[])registryLanguage)) {
                throw new MissingServletRequestParameterException("Select at least one language.", "language");
            }
            Log.debug((String)"geonetwork.thesaurus", (Object)("Uploading thesaurus from registry : " + registryUrl));
            String itemName = registryUrl.substring(registryUrl.lastIndexOf("/") + 1, registryUrl.length());
            rdfFile = this.extractSKOSFromRegistry(registryUrl, itemName, registryLanguage, context);
            fname = registryUrl.replaceAll("[^A-Za-z]+", "") + "-" + itemName + ".rdf";
        } else {
            Log.debug((String)"geonetwork.thesaurus", (Object)"No URL or file name provided for thesaurus upload.");
            throw new MissingServletRequestParameterException("Thesaurus source not provided", "url");
        }
        if (StringUtils.isEmpty((String)fname)) {
            throw new ResourceNotFoundException("File upload from URL or file return null");
        }
        if (rdfFile == null || !Files.exists(rdfFile, new LinkOption[0])) {
            throw new ResourceNotFoundException("Thesaurus file doesn't exist");
        }
        long fsize = Files.size(rdfFile);
        if (fsize == 0L) {
            throw new ResourceNotFoundException("Thesaurus file has zero size");
        }
        String extension = FilenameUtils.getExtension((String)fname);
        if (!extension.equalsIgnoreCase("rdf") && !extension.equalsIgnoreCase("xml")) {
            Log.debug((String)"geonetwork.thesaurus", (Object)("Incorrect extension for thesaurus named: " + fname));
            throw new MissingServletRequestParameterException("Incorrect extension for thesaurus", fname);
        }
        Log.debug((String)"geonetwork.thesaurus", (Object)("Uploading thesaurus: " + fname));
        fname = fname.replace(extension, "rdf");
        this.uploadThesaurus(rdfFile, stylesheet, context, fname, type, dir);
        long end = System.currentTimeMillis();
        long duration = (end - start) / 1000L;
        return String.format("Thesaurus '%s' loaded in %d sec.", fname, duration);
    }

    private Path extractSKOSFromRegistry(String registryUrl, String itemName, String[] lang, ServiceContext context) throws Exception {
        if (lang != null) {
            Element documents = new Element("documents");
            for (String language : lang) {
                try {
                    String languageFileUrl = registryUrl + "/" + itemName + "." + language + ".xml";
                    Path localRdf = this.getXMLContentFromUrl(languageFileUrl, context);
                    Element codeList = Xml.loadFile((Path)localRdf);
                    documents.addContent((Content)codeList);
                }
                catch (Exception e) {
                    Log.debug((String)"geonetwork.thesaurus", (Object)("Thesaurus not found for the requested translation: " + itemName + " " + language));
                    throw new ResourceNotFoundException("Thesaurus not found for the requested translation: " + itemName + " " + language);
                }
            }
            Path skosTransform = this.dataDirectory.getWebappDir().resolve("xslt/services/thesaurus/registry-to-skos.xsl");
            Element transform = Xml.transform((Element)documents, (Path)skosTransform);
            Path rdfFile = Files.createTempFile("thesaurus", ".rdf", new FileAttribute[0]);
            XMLOutputter xmlOutput = new XMLOutputter();
            xmlOutput.setFormat(Format.getCompactFormat());
            xmlOutput.output(transform, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(rdfFile.toFile().getCanonicalPath()), StandardCharsets.UTF_8));
            return rdfFile;
        }
        return null;
    }

    private Path getXMLContentFromUrl(String url, ServiceContext context) throws URISyntaxException, IOException, MalformedURLException {
        URI uri = new URI(url);
        Path rdfFile = Files.createTempFile("thesaurus", ".rdf", new FileAttribute[0]);
        XmlRequest httpReq = this.httpRequestFactory.createXmlRequest(uri.toURL());
        httpReq.setAddress(uri.getPath());
        Lib.net.setupProxy(context, httpReq);
        httpReq.executeLarge(rdfFile);
        return rdfFile;
    }

    private void uploadThesaurus(Path rdfFile, String style, ServiceContext context, String fname, String type, String dir) throws Exception {
        Path path;
        Element tsXml;
        Path stylePath = context.getAppPath().resolve("xsl");
        Element xml = Xml.loadFile((Path)rdfFile);
        xml.detach();
        if (!"_none_".equals(style)) {
            FilePathChecker.verify((String)style);
            tsXml = Xml.transform((Element)xml, (Path)stylePath.resolve(style));
            tsXml.detach();
        } else {
            tsXml = xml;
        }
        if (tsXml.getNamespacePrefix().equals("rdf") && tsXml.getName().equals("RDF")) {
            path = this.thesaurusMan.buildThesaurusFilePath(fname, type, dir);
            try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
                Xml.writeResponse((Document)new Document(tsXml), (OutputStream)out);
            }
        } else {
            IO.deleteFile((Path)rdfFile, (boolean)false, (String)"geonetwork.thesaurus");
            throw new WebApplicationException("Unknown format (Must be in SKOS format).");
        }
        String siteURL = this.settingManager.getSiteURL(context);
        Thesaurus gst = new Thesaurus(this.languagesMapper, fname, type, dir, path, siteURL);
        this.thesaurusMan.addThesaurus(gst, false);
    }

    private KeywordSearchParamsBuilder parseBuilder(String uiLang, String q, int maxResults, int offset, List<String> targetLangs, List<String> thesauri, String thesauriDomainName, KeywordSearchType typeSearch, String uri, IsoLanguagesMapper mapper) {
        KeywordSearchParamsBuilder parsedParams = new KeywordSearchParamsBuilder(mapper).lenient(true);
        if (q != null) {
            parsedParams.keyword(q, typeSearch, true);
        }
        if (uri != null) {
            parsedParams.uri(uri);
        }
        parsedParams.maxResults(maxResults);
        parsedParams.offset(offset);
        if (thesauriDomainName != null) {
            parsedParams.thesauriDomainName(thesauriDomainName);
        }
        if (thesauri == null) {
            Map listOfThesaurus = this.thesaurusMan.getThesauriMap();
            for (String t : listOfThesaurus.keySet()) {
                parsedParams.addThesaurus(((Thesaurus)listOfThesaurus.get(t)).getKey());
            }
        } else {
            for (String thesaurusName : thesauri) {
                if (thesaurusName.trim().isEmpty()) continue;
                parsedParams.addThesaurus(thesaurusName.trim());
            }
        }
        boolean addedLang = false;
        if (targetLangs != null) {
            for (String targetLang : targetLangs) {
                if (targetLang.trim().isEmpty()) continue;
                parsedParams.addLang(targetLang.trim());
                addedLang = true;
            }
        }
        if (!addedLang) {
            parsedParams.addLang(uiLang);
        }
        return parsedParams;
    }
}

