/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import com.sun.istack.NotNull;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.persistence.metamodel.SingularAttribute;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.FeatureNotEnabledException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.records.MetadataUtils;
import org.fao.geonet.api.records.model.MetadataStatusParameter;
import org.fao.geonet.api.records.model.MetadataStatusResponse;
import org.fao.geonet.api.records.model.MetadataWorkflowStatusResponse;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.MetadataStatusId;
import org.fao.geonet.domain.MetadataStatusId_;
import org.fao.geonet.domain.MetadataStatus_;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.domain.StatusValueType;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.User_;
import org.fao.geonet.domain.utils.ObjectJSONUtils;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataStatus;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.metadata.StatusActions;
import org.fao.geonet.kernel.metadata.StatusActionsFactory;
import org.fao.geonet.kernel.search.LuceneSearcher;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.MetadataStatusRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.StatusValueRepository;
import org.fao.geonet.repository.UserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/records", "/{portal}/api/0.1/records"})
@Api(value="records", tags={"records"}, description="Metadata record operations")
@Controller(value="recordWorkflow")
@ReadWriteController
public class MetadataWorkflowApi {
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    MetadataStatusRepository metadataStatusRepository;
    @Autowired
    StatusValueRepository statusValueRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    IMetadataStatus metadataStatus;
    @Autowired
    AccessManager accessManager;
    @Autowired
    SettingManager settingManager;
    @Autowired
    DataManager dataManager;
    @Autowired
    IMetadataIndexer metadataIndexer;
    @Autowired
    StatusActionsFactory statusActionFactory;
    @Autowired
    IMetadataUtils metadataUtils;

    @ApiOperation(value="Get record status history", notes="", nickname="getRecordStatusHistory")
    @RequestMapping(value={"/{metadataUuid}/status"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<MetadataStatusResponse> getRecordStatusHistory(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @RequestParam(required=false) boolean details, @ApiParam(value="Sort direction", required=false) @RequestParam(defaultValue="DESC") Sort.Direction sortOrder, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, request);
        String sortField = SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{MetadataStatus_.id, MetadataStatusId_.changeDate});
        List listOfStatus = this.metadataStatusRepository.findAllById_MetadataId(metadata.getId(), new Sort(sortOrder, new String[]{sortField}));
        List<MetadataStatusResponse> response = this.buildMetadataStatusResponses(listOfStatus, details, context.getLanguage());
        return response;
    }

    @ApiOperation(value="Get record status history by type", notes="", nickname="getRecordStatusHistoryByType")
    @RequestMapping(value={"/{metadataUuid}/status/{type}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<MetadataStatusResponse> getRecordStatusHistoryByType(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Type", required=true) @PathVariable StatusValueType type, @RequestParam(required=false) boolean details, @ApiParam(value="Sort direction", required=false) @RequestParam(defaultValue="DESC") Sort.Direction sortOrder, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, request);
        String sortField = SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{MetadataStatus_.id, MetadataStatusId_.changeDate});
        List listOfStatus = this.metadataStatusRepository.findAllByIdAndByType(metadata.getId(), type, new Sort(sortOrder, new String[]{sortField}));
        List<MetadataStatusResponse> response = this.buildMetadataStatusResponses(listOfStatus, details, context.getLanguage());
        return response;
    }

    @ApiOperation(value="Get last workflow status for a record", notes="", nickname="getStatus")
    @RequestMapping(value={"/{metadataUuid}/status/workflow/last"}, method={RequestMethod.GET}, produces={"application/json"})
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=200, message="Record status."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public MetadataWorkflowStatusResponse getStatus(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        ServiceContext context = ApiUtils.createServiceContext(request, locale.getISO3Language());
        if (!this.accessManager.isOwner(context, String.valueOf(metadata.getId()))) {
            throw new SecurityException(String.format("Only the owner of the metadata can get the status. User is not the owner of the metadata", new Object[0]));
        }
        MetadataStatus recordStatus = this.metadataStatus.getStatus(metadata.getId());
        List elStatus = this.statusValueRepository.findAllByType(StatusValueType.workflow);
        HashSet<Integer> ids = new HashSet<Integer>();
        ids.add(metadata.getId());
        List reviewers = this.userRepository.findAllByGroupOwnerNameAndProfile(ids, Profile.Reviewer, SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{User_.name}));
        ArrayList<User> listOfReviewers = new ArrayList<User>();
        for (Pair reviewer : reviewers) {
            listOfReviewers.add((User)reviewer.two());
        }
        return new MetadataWorkflowStatusResponse(recordStatus, listOfReviewers, this.accessManager.hasEditPermission(context, metadata.getId() + ""), elStatus);
    }

    @ApiOperation(value="Set the record status", notes="", nickname="setStatus")
    @RequestMapping(value={"/{metadataUuid}/status"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=204, message="Status updated."), @ApiResponse(code=400, message="Metadata workflow not enabled."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void setStatus(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Metadata status", required=true) @RequestBody(required=true) MetadataStatusParameter status, HttpServletRequest request) throws Exception {
        boolean isInvalid;
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ServiceContext context = ApiUtils.createServiceContext(request, this.languageUtils.getIso3langCode(request.getLocales()));
        boolean isMdWorkflowEnable = this.settingManager.getValueAsBool("metadata/workflow/enable");
        int author = context.getUserSession().getUserIdAsInt();
        MetadataStatus metadataStatus = this.convertParameter(metadata.getId(), status, author);
        if (metadataStatus.getStatusValue().getType() == StatusValueType.workflow && !isMdWorkflowEnable) {
            throw new FeatureNotEnabledException("Metadata workflow is disabled, can not be set the status of metadata");
        }
        if (!this.accessManager.isOwner(context, String.valueOf(metadata.getId()))) {
            throw new SecurityException(String.format("Only the owner of the metadata can set the status of this record. User is not the owner of the metadata.", new Object[0]));
        }
        boolean isAllowedSubmitApproveInvalidMd = this.settingManager.getValueAsBool("metadata/workflow/allowSumitApproveInvalidMd");
        if ((status.getStatus() == Integer.parseInt("4") || status.getStatus() == Integer.parseInt("2")) && !isAllowedSubmitApproveInvalidMd && (isInvalid = MetadataUtils.retrieveMetadataValidationStatus(metadata, context))) {
            throw new Exception("Metadata is invalid: can't be submitted or approved");
        }
        StatusActions sa = this.statusActionFactory.createStatusActions(context);
        ArrayList<MetadataStatus> listOfStatusChange = new ArrayList<MetadataStatus>(1);
        listOfStatusChange.add(metadataStatus);
        sa.onStatusChange(listOfStatusChange);
        this.metadataIndexer.indexMetadata(String.valueOf(metadata.getId()), true, null);
    }

    @ApiOperation(value="Close a record task", notes="", nickname="closeTask")
    @RequestMapping(value={"/{metadataUuid}/status/{statusId:[0-9]+}.{userId:[0-9]+}.{changeDate}/close"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=204, message="Task closed."), @ApiResponse(code=404, message="Status not found."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void closeTask(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Status identifier", required=true) @PathVariable int statusId, @ApiParam(value="User identifier", required=true) @PathVariable int userId, @ApiParam(value="Change date", required=true) @PathVariable String changeDate, @ApiParam(value="Close date", required=true) @RequestParam String closeDate, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        MetadataStatus metadataStatus = (MetadataStatus)this.metadataStatusRepository.findOne((Serializable)new MetadataStatusId().setMetadataId(metadata.getId()).setStatusId(statusId).setUserId(userId).setChangeDate(new ISODate(changeDate)));
        if (metadataStatus == null) {
            throw new ResourceNotFoundException(String.format("Can't find metadata status for record '%d', user '%s' at date '%s'", metadataUuid, userId, changeDate));
        }
        this.metadataStatusRepository.update((Serializable)metadataStatus.getId(), entity -> entity.setCloseDate(new ISODate(closeDate)));
    }

    @ApiOperation(value="Delete a record status", notes="", nickname="deleteStatus")
    @RequestMapping(value={"/{metadataUuid}/status/{statusId:[0-9]+}.{userId:[0-9]+}.{changeDate}"}, method={RequestMethod.DELETE})
    @PreAuthorize(value="hasRole('Administrator')")
    @ApiResponses(value={@ApiResponse(code=204, message="Status removed."), @ApiResponse(code=404, message="Status not found."), @ApiResponse(code=403, message="Operation not allowed. Only Administrators can access it.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteRecordStatus(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Status identifier", required=true) @PathVariable int statusId, @ApiParam(value="User identifier", required=true) @PathVariable int userId, @ApiParam(value="Change date", required=true) @PathVariable String changeDate, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        MetadataStatus metadataStatus = (MetadataStatus)this.metadataStatusRepository.findOne((Serializable)new MetadataStatusId().setMetadataId(metadata.getId()).setStatusId(statusId).setUserId(userId).setChangeDate(new ISODate(changeDate)));
        if (metadataStatus == null) {
            throw new ResourceNotFoundException(String.format("Can't find metadata status for record '%d', user '%s' at date '%s'", metadataUuid, userId, changeDate));
        }
        this.metadataStatusRepository.delete((Object)metadataStatus);
    }

    @ApiOperation(value="Delete all record status", notes="", nickname="deleteAllRecordStatus")
    @RequestMapping(value={"/{metadataUuid}/status"}, method={RequestMethod.DELETE})
    @PreAuthorize(value="hasRole('Administrator')")
    @ApiResponses(value={@ApiResponse(code=204, message="Status removed."), @ApiResponse(code=404, message="Status not found."), @ApiResponse(code=403, message="Operation not allowed. Only Administrators can access it.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAllRecordStatus(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        this.metadataStatusRepository.deleteAllById_MetadataId(Integer.valueOf(metadata.getId()));
    }

    @ApiOperation(value="Search status", notes="", nickname="searchStatusByType")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET}, path={"/status/search"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<MetadataStatusResponse> getStatusByType(@ApiParam(value="One or more types to retrieve (ie. worflow, event, task). Default is all.", required=false) @RequestParam(required=false) StatusValueType[] type, @ApiParam(value="All event details including XML changes. Responses are bigger. Default is false", required=false) @RequestParam(required=false) boolean details, @ApiParam(value="One or more event author. Default is all.", required=false) @RequestParam(required=false) Integer[] author, @ApiParam(value="One or more event owners. Default is all.", required=false) @RequestParam(required=false) Integer[] owner, @ApiParam(value="One or more record identifier. Default is all.", required=false) @RequestParam(required=false) Integer[] record, @ApiParam(value="Start date", required=false) @RequestParam(required=false) String dateFrom, @ApiParam(value="End date", required=false) @RequestParam(required=false) String dateTo, @ApiParam(value="From page", required=false) @RequestParam(required=false, defaultValue="0") Integer from, @ApiParam(value="Number of records to return", required=false) @RequestParam(required=false, defaultValue="100") Integer size, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        Sort sortByStatusChangeDate = SortUtils.createSort((Sort.Direction)Sort.Direction.DESC, (SingularAttribute[])new SingularAttribute[]{MetadataStatus_.id, MetadataStatusId_.changeDate});
        PageRequest pageRequest = new PageRequest(from.intValue(), size.intValue(), sortByStatusChangeDate);
        List metadataStatuses = type != null && type.length > 0 || author != null && author.length > 0 || owner != null && owner.length > 0 || record != null && record.length > 0 ? this.metadataStatusRepository.searchStatus(type != null && type.length > 0 ? Arrays.asList(type) : null, author != null && author.length > 0 ? Arrays.asList(author) : null, owner != null && owner.length > 0 ? Arrays.asList(owner) : null, record != null && record.length > 0 ? Arrays.asList(record) : null, dateFrom, dateTo, (Pageable)pageRequest) : this.metadataStatusRepository.findAll((Pageable)pageRequest).getContent();
        return this.buildMetadataStatusResponses(metadataStatuses, details, context.getLanguage());
    }

    public MetadataStatus convertParameter(int id, MetadataStatusParameter parameter, int author) throws Exception {
        StatusValue statusValue = (StatusValue)this.statusValueRepository.findOne((Serializable)Integer.valueOf(parameter.getStatus()));
        MetadataStatus metadataStatus = new MetadataStatus();
        MetadataStatusId mdStatusId = new MetadataStatusId().setStatusId(parameter.getStatus()).setMetadataId(id).setChangeDate(new ISODate()).setUserId(author);
        metadataStatus.setId(mdStatusId);
        metadataStatus.setStatusValue(statusValue);
        if (parameter.getChangeMessage() != null) {
            metadataStatus.setChangeMessage(parameter.getChangeMessage());
        }
        if (StringUtils.isNotEmpty((String)parameter.getDueDate())) {
            metadataStatus.setDueDate(new ISODate(parameter.getDueDate()));
        }
        if (StringUtils.isNotEmpty((String)parameter.getCloseDate())) {
            metadataStatus.setCloseDate(new ISODate(parameter.getCloseDate()));
        }
        if (parameter.getOwner() != null) {
            metadataStatus.setOwner(parameter.getOwner());
        }
        return metadataStatus;
    }

    @NotNull
    private List<MetadataStatusResponse> buildMetadataStatusResponses(List<MetadataStatus> listOfStatus, boolean details, String language) {
        ArrayList<MetadataStatusResponse> response = new ArrayList<MetadataStatusResponse>();
        HashMap<Integer, Object> listOfUsers = new HashMap<Integer, Object>();
        for (MetadataStatus s : listOfStatus) {
            if (listOfUsers.get(s.getId().getUserId()) == null) {
                listOfUsers.put(s.getId().getUserId(), this.userRepository.findOne((Serializable)Integer.valueOf(s.getId().getUserId())));
            }
            if (s.getOwner() == null || listOfUsers.get(s.getOwner()) != null) continue;
            listOfUsers.put(s.getOwner(), this.userRepository.findOne((Serializable)s.getOwner()));
        }
        HashMap<Integer, String> titles = new HashMap<Integer, String>();
        HashMap<Integer, String> uuids = new HashMap<Integer, String>();
        for (MetadataStatus s : listOfStatus) {
            User owner;
            MetadataStatusResponse status = new MetadataStatusResponse(s, details);
            User author = (User)listOfUsers.get(status.getId().getUserId());
            if (author != null) {
                status.setAuthorName(author.getName() + " " + author.getSurname());
                status.setAuthorEmail(author.getEmail());
            }
            if (s.getOwner() != null && (owner = (User)listOfUsers.get(status.getOwner())) != null) {
                status.setOwnerName(owner.getName() + " " + owner.getSurname());
                status.setOwnerEmail(owner.getEmail());
            }
            if (s.getStatusValue().getType().equals((Object)StatusValueType.event)) {
                status.setCurrentStatus(this.extractCurrentStatus(s));
                status.setPreviousStatus(this.extractPreviousStatus(s));
            } else if (s.getStatusValue().getType().equals((Object)StatusValueType.task)) {
                status.setDateChange(s.getId().getChangeDate().getDateAndTime());
                if (s.getDueDate() != null) {
                    status.setDateDue(s.getDueDate().getDateAndTime());
                }
                if (s.getCloseDate() != null) {
                    status.setDateClose(s.getCloseDate().getDateAndTime());
                }
            }
            String title = (String)titles.get(s.getId().getMetadataId());
            if (title == null) {
                try {
                    title = LuceneSearcher.getMetadataFromIndexById((String)language, (String)(s.getId().getMetadataId() + ""), (String)"title");
                    titles.put(s.getId().getMetadataId(), title);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            status.setTitle(title);
            String uuid = (String)uuids.get(s.getId().getMetadataId());
            if (uuid == null) {
                try {
                    uuid = this.metadataUtils.getMetadataUuid(Integer.toString(s.getId().getMetadataId()));
                    uuids.put(s.getId().getMetadataId(), uuid);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            status.setUuid(uuid);
            response.add(status);
        }
        return response;
    }

    private String extractCurrentStatus(MetadataStatus s) {
        switch (Integer.toString(s.getStatusValue().getId())) {
            case "52": {
                return s.getCurrentState();
            }
            case "54": {
                return ObjectJSONUtils.extractFieldFromJSONString((String)s.getCurrentState(), (String)"owner", (String)"name");
            }
            case "55": {
                return ObjectJSONUtils.extractFieldFromJSONString((String)s.getCurrentState(), (String)"owner", (String)"name");
            }
            case "60": {
                return ObjectJSONUtils.extractFieldFromJSONString((String)s.getCurrentState(), (String)"process");
            }
            case "57": {
                List categories = ObjectJSONUtils.extractListOfFieldFromJSONString((String)s.getCurrentState(), (String)"category", (String)"name");
                StringBuffer categoriesAsString = new StringBuffer("[ ");
                for (String categoryName : categories) {
                    categoriesAsString.append(categoryName + " ");
                }
                categoriesAsString.append("]");
                return categoriesAsString.toString();
            }
            case "58": {
                return s.getCurrentState().equals("1") ? "OK" : "KO";
            }
        }
        return "";
    }

    private String extractPreviousStatus(MetadataStatus s) {
        switch (Integer.toString(s.getStatusValue().getId())) {
            case "53": {
                return s.getPreviousState();
            }
            case "54": {
                return ObjectJSONUtils.extractFieldFromJSONString((String)s.getPreviousState(), (String)"owner", (String)"name");
            }
            case "55": {
                return ObjectJSONUtils.extractFieldFromJSONString((String)s.getPreviousState(), (String)"owner", (String)"name");
            }
        }
        return "";
    }
}

