/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.categories;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.Language;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.repository.LanguageRepository;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/tags", "/{portal}/api/0.1/tags"})
@Api(value="tags", tags={"tags"}, description="Tags operations")
@Controller(value="tags")
public class TagsApi {
    @Autowired
    private MetadataCategoryRepository categoryRepository;
    @Autowired
    private LanguageRepository langRepository;
    @Autowired
    private MetadataRepository metadataRepository;

    @ApiOperation(value="Get tags", notes="", nickname="getTags")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="List of tags.")})
    @ResponseBody
    public List<MetadataCategory> getTags() throws Exception {
        return this.categoryRepository.findAll();
    }

    @ApiOperation(value="Create a tag", notes="If labels are not defined, a default label is created with the category name for all languages.", nickname="putTag")
    @RequestMapping(method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(code=201, message="Tag created. Return the new tag identifier."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    @PreAuthorize(value="hasRole('UserAdmin')")
    public ResponseEntity<Integer> putTag(@ApiParam(name="category") @RequestBody MetadataCategory category) throws Exception {
        MetadataCategory existingCategory = (MetadataCategory)this.categoryRepository.findOne((Serializable)Integer.valueOf(category.getId()));
        if (existingCategory != null) {
            throw new IllegalArgumentException(String.format("A tag with id '%d' already exist", category.getId()));
        }
        List allLanguages = this.langRepository.findAll();
        Map labelTranslations = category.getLabelTranslations();
        for (Language l : allLanguages) {
            String label = (String)labelTranslations.get(l.getId());
            category.getLabelTranslations().put(l.getId(), label == null ? category.getName() : label);
        }
        this.categoryRepository.save((Object)category);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @ApiOperation(value="Get a tag", notes="", nickname="getTag")
    @RequestMapping(value={"/{tagIdentifier}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Tag details.")})
    @ResponseBody
    public MetadataCategory getTag(@ApiParam(value="Tag identifier", required=true) @PathVariable Integer tagIdentifier) throws Exception {
        MetadataCategory category = (MetadataCategory)this.categoryRepository.findOne((Serializable)tagIdentifier);
        if (category == null) {
            throw new ResourceNotFoundException("Category not found");
        }
        return category;
    }

    @ApiOperation(value="Update a tag", notes="", nickname="updateTag")
    @RequestMapping(value={"/{tagIdentifier}"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasRole('UserAdmin')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(code=204, message="Tag updated."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    @ResponseBody
    public ResponseEntity updateTag(@ApiParam(value="Tag identifier", required=true) @PathVariable int tagIdentifier, @ApiParam(name="category") @RequestBody MetadataCategory category) throws Exception {
        MetadataCategory existingCategory = (MetadataCategory)this.categoryRepository.findOne((Serializable)Integer.valueOf(tagIdentifier));
        if (existingCategory == null) {
            throw new ResourceNotFoundException(String.format("Category with id '%d' does not exist.", tagIdentifier));
        }
        this.updateCategory(tagIdentifier, category);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private void updateCategory(int categoryIdentifier, MetadataCategory category) {
        this.categoryRepository.update((Serializable)Integer.valueOf(categoryIdentifier), entity -> {
            entity.setName(category.getName());
            Map labelTranslations = category.getLabelTranslations();
            if (labelTranslations != null) {
                entity.getLabelTranslations().clear();
                entity.getLabelTranslations().putAll(labelTranslations);
            }
        });
    }

    @ApiOperation(value="Remove a tag", notes="", nickname="deleteTag")
    @RequestMapping(value={"/{tagIdentifier}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(code=204, message="Tag removed."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    @PreAuthorize(value="hasRole('UserAdmin')")
    public ResponseEntity deleteTag(@ApiParam(value="Tag identifier", required=true) @PathVariable Integer tagIdentifier) throws Exception {
        MetadataCategory category = (MetadataCategory)this.categoryRepository.findOne((Serializable)tagIdentifier);
        if (category != null) {
            long recordsCount = this.metadataRepository.count(MetadataSpecs.hasCategory((MetadataCategory)category));
            if (recordsCount > 0L) {
                throw new IllegalArgumentException(String.format("Tag '%s' is assigned to %d records. Update records first in order to remove that tag.", category.getName(), recordsCount));
            }
        } else {
            throw new ResourceNotFoundException(String.format("Category with id '%d' does not exist.", tagIdentifier));
        }
        this.categoryRepository.delete((Serializable)tagIdentifier);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

