/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.core.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.IncrementalAttributesMapper;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.core.support.RangeOption;

public class DefaultIncrementalAttributesMapper
implements AttributesMapper,
IncrementalAttributesMapper {
    private static final Log log = LogFactory.getLog((Class)DefaultIncrementalAttributesMapper.class);
    private Map stateMap = new LinkedHashMap();
    private Set rangedAttributesInNextIteration = new LinkedHashSet();
    private static final IncrementalAttributeState NOT_FOUND_ATTRIBUTE_STATE = new IncrementalAttributeState(){

        public String getRequestedAttributeName() {
            throw new UnsupportedOperationException("This method should never be called");
        }

        public boolean hasMore() {
            return false;
        }

        public void calculateNextRange(RangeOption responseRange) {
        }

        public String getAttributeNameForQuery() {
            throw new UnsupportedOperationException("This method should never be called");
        }

        public void processValues(Attributes attributes, String attributeName) throws NamingException {
        }

        public List getValues() {
            return null;
        }
    };

    public DefaultIncrementalAttributesMapper(String attributeName) {
        this(-1, attributeName);
    }

    public DefaultIncrementalAttributesMapper(String[] attributeNames) {
        this(-1, attributeNames);
    }

    public DefaultIncrementalAttributesMapper(int pageSize, String attributeName) {
        this(pageSize, new String[]{attributeName});
    }

    public DefaultIncrementalAttributesMapper(int pageSize, String[] attributeNames) {
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            this.stateMap.put(attributeName, new DefaultIncrementalAttributeState(attributeName, pageSize));
            this.rangedAttributesInNextIteration.add(attributeName);
        }
    }

    public final Object mapFromAttributes(Attributes attributes) throws NamingException {
        if (!this.hasMore()) {
            throw new IllegalStateException("No more attributes!");
        }
        this.rangedAttributesInNextIteration = new HashSet();
        NamingEnumeration<String> attributeNameEnum = attributes.getIDs();
        while (attributeNameEnum.hasMore()) {
            String attributeName = attributeNameEnum.next();
            String[] attributeNameSplit = attributeName.split(";");
            IncrementalAttributeState state = this.getState(attributeNameSplit[0]);
            if (attributeNameSplit.length == 1) {
                state.processValues(attributes, attributeName);
                continue;
            }
            for (int i = 0; i < attributeNameSplit.length; ++i) {
                String option = attributeNameSplit[i];
                RangeOption responseRange = RangeOption.parse(option);
                if (responseRange == null) continue;
                state.processValues(attributes, attributeName);
                state.calculateNextRange(responseRange);
                if (!state.hasMore()) continue;
                this.rangedAttributesInNextIteration.add(state.getRequestedAttributeName());
            }
        }
        return this;
    }

    private IncrementalAttributeState getState(String attributeName) {
        Object mappedState = this.stateMap.get(attributeName);
        if (mappedState == null) {
            log.warn((Object)("Attribute '" + attributeName + "' is not handled by this instance"));
            mappedState = NOT_FOUND_ATTRIBUTE_STATE;
        }
        return (IncrementalAttributeState)mappedState;
    }

    public final List getValues(String attributeName) {
        return this.getState(attributeName).getValues();
    }

    public Attributes getCollectedAttributes() {
        BasicAttributes attributes = new BasicAttributes();
        Set attributeNames = this.stateMap.keySet();
        Iterator iterator = attributeNames.iterator();
        while (iterator.hasNext()) {
            String attributeName = (String)iterator.next();
            BasicAttribute oneAttribute = new BasicAttribute(attributeName);
            List values = this.getValues(attributeName);
            if (values != null) {
                Iterator valueIterator = values.iterator();
                while (valueIterator.hasNext()) {
                    Object oneValue = valueIterator.next();
                    oneAttribute.add(oneValue);
                }
            }
            attributes.put(oneAttribute);
        }
        return attributes;
    }

    public final boolean hasMore() {
        return this.rangedAttributesInNextIteration.size() > 0;
    }

    public final String[] getAttributesForLookup() {
        String[] result = new String[this.rangedAttributesInNextIteration.size()];
        int index = 0;
        Iterator iterator = this.rangedAttributesInNextIteration.iterator();
        while (iterator.hasNext()) {
            String next = (String)iterator.next();
            IncrementalAttributeState state = (IncrementalAttributeState)this.stateMap.get(next);
            result[index++] = state.getAttributeNameForQuery();
        }
        return result;
    }

    public static Attributes lookupAttributes(LdapOperations ldapOperations, String dn, String attribute) {
        return DefaultIncrementalAttributesMapper.lookupAttributes(ldapOperations, (Name)new DistinguishedName(dn), attribute);
    }

    public static Attributes lookupAttributes(LdapOperations ldapOperations, String dn, String[] attributes) {
        return DefaultIncrementalAttributesMapper.lookupAttributes(ldapOperations, (Name)new DistinguishedName(dn), attributes);
    }

    public static Attributes lookupAttributes(LdapOperations ldapOperations, Name dn, String attribute) {
        return DefaultIncrementalAttributesMapper.lookupAttributes(ldapOperations, dn, new String[]{attribute});
    }

    public static Attributes lookupAttributes(LdapOperations ldapOperations, Name dn, String[] attributes) {
        return DefaultIncrementalAttributesMapper.loopForAllAttributeValues(ldapOperations, dn, attributes).getCollectedAttributes();
    }

    public static List lookupAttributeValues(LdapOperations ldapOperations, String dn, String attribute) {
        return DefaultIncrementalAttributesMapper.lookupAttributeValues(ldapOperations, new DistinguishedName(dn), attribute);
    }

    public static List lookupAttributeValues(LdapOperations ldapOperations, Name dn, String attribute) {
        List values = DefaultIncrementalAttributesMapper.loopForAllAttributeValues(ldapOperations, dn, new String[]{attribute}).getValues(attribute);
        if (values == null) {
            values = Collections.emptyList();
        }
        return values;
    }

    private static DefaultIncrementalAttributesMapper loopForAllAttributeValues(LdapOperations ldapOperations, Name dn, String[] attributes) {
        DefaultIncrementalAttributesMapper mapper = new DefaultIncrementalAttributesMapper(attributes);
        while (mapper.hasMore()) {
            ldapOperations.lookup(dn, mapper.getAttributesForLookup(), (AttributesMapper)mapper);
        }
        return mapper;
    }

    private static interface IncrementalAttributeState {
        public boolean hasMore();

        public void calculateNextRange(RangeOption var1);

        public String getAttributeNameForQuery();

        public String getRequestedAttributeName();

        public void processValues(Attributes var1, String var2) throws NamingException;

        public List getValues();
    }

    private static final class DefaultIncrementalAttributeState
    implements IncrementalAttributeState {
        private final String actualAttributeName;
        private List values = null;
        private final int pageSize;
        boolean more = true;
        private RangeOption requestRange;

        private DefaultIncrementalAttributeState(String actualAttributeName, int pageSize) {
            this.actualAttributeName = actualAttributeName;
            this.pageSize = pageSize;
            this.requestRange = new RangeOption(0, pageSize);
        }

        public boolean hasMore() {
            return this.more;
        }

        public String getRequestedAttributeName() {
            return this.actualAttributeName;
        }

        public void calculateNextRange(RangeOption responseRange) {
            boolean bl = this.more = this.requestRange.compareTo(responseRange) > 0;
            if (this.more) {
                this.requestRange = responseRange.nextRange(this.pageSize);
            }
        }

        public String getAttributeNameForQuery() {
            StringBuilder attributeBuilder = new StringBuilder(this.actualAttributeName);
            if (!this.requestRange.isFullRange()) {
                attributeBuilder.append(';');
                this.requestRange.appendTo(attributeBuilder);
            }
            return attributeBuilder.toString();
        }

        public void processValues(Attributes attributes, String attributeName) throws NamingException {
            Attribute attribute = attributes.get(attributeName);
            NamingEnumeration<?> valueEnum = attribute.getAll();
            this.initValuesIfApplicable();
            while (valueEnum.hasMore()) {
                this.values.add(valueEnum.next());
            }
        }

        private void initValuesIfApplicable() {
            if (this.values == null) {
                this.values = new LinkedList();
            }
        }

        public List getValues() {
            if (this.values != null) {
                return new ArrayList(this.values);
            }
            return null;
        }
    }
}

