/*
 * Decompiled with CFR 0.152.
 */
package lizard.util;

import java.util.StringTokenizer;

public final class Converter {
    public static int reverseByte(int oldBits) {
        int i = 0;
        int d = 1;
        int bits = 0;
        while (i < 8) {
            if ((oldBits & d) != 0) {
                bits += 1 << 7 - i;
            }
            ++i;
            d <<= 1;
        }
        return bits;
    }

    public static int reverseInt(int oldBits) {
        int i = 0;
        int d = 1;
        int bits = 0;
        while (i < 16) {
            if ((oldBits & d) != 0) {
                bits += 1 << 15 - i;
            }
            ++i;
            d <<= 1;
        }
        return bits;
    }

    public static byte getLoByte(int n) {
        return (byte)(n & 0xFF);
    }

    public static byte getHiByte(int n) {
        return (byte)((n & 0xFF00) >> 8);
    }

    public static int bytesToInt(byte[] ba) {
        if (ba.length < 2) {
            System.out.println("bytesToInt: byte array must be at least 2 bytes long");
            return 0;
        }
        int hi = (ba[0] & 0xFF) << 8;
        int lo = ba[1] & 0xFF;
        return hi + lo;
    }

    public static String byteToBinaryString(byte b) {
        String szZeros = "00000000";
        String szBits = Integer.toString(b & 0xFF, 2);
        String sz = String.valueOf(szZeros.substring(szBits.length())) + szBits;
        return sz;
    }

    public static String byteToBinaryString(int i) {
        String szZeros = "00000000";
        String szBits = Integer.toString(i & 0xFF, 2);
        String sz = String.valueOf(szZeros.substring(szBits.length())) + szBits;
        return sz;
    }

    public static String byteToBinaryString(int i, int len) {
        return Converter.byteToBinaryString(i).substring(8 - len);
    }

    public static String intToBinaryString(int i, int len) {
        String szLo = Converter.byteToBinaryString(i & 0xFF);
        String szHi = Converter.byteToBinaryString((i & 0xFF00) >> 8);
        String szBits = String.valueOf(szHi) + szLo;
        return szBits.substring(16 - len);
    }

    public static byte getLoByteFromHexString(String szHex) {
        int n = Integer.parseInt(szHex, 16);
        return (byte)(n & 0xFF);
    }

    public static byte getHiByteFromHexString(String szHex) {
        int n = Integer.parseInt(szHex, 16);
        return (byte)((n & 0xFF00) >> 8);
    }

    public static byte getByteFromHexString(String szHex) {
        return Converter.getLoByteFromHexString(szHex);
    }

    public static byte[] hexStringToBytes(String szHex) {
        StringTokenizer tokens = new StringTokenizer(szHex, ", ");
        int count = tokens.countTokens();
        byte[] bytes = new byte[count];
        int i = 0;
        while (i < count && tokens.hasMoreTokens()) {
            bytes[i] = Converter.getByteFromHexString(tokens.nextToken());
            ++i;
        }
        return bytes;
    }

    public static byte getByteFromBinaryString(String szBinary) {
        int n = Integer.parseInt(szBinary, 2);
        return (byte)(n & 0xFF);
    }

    public static byte[] binaryStringToBytes(String szBinary) {
        StringTokenizer tokens = new StringTokenizer(szBinary, ", ");
        int count = tokens.countTokens();
        byte[] bytes = new byte[count];
        int i = 0;
        while (i < count && tokens.hasMoreTokens()) {
            bytes[i] = Converter.getByteFromBinaryString(tokens.nextToken());
            ++i;
        }
        return bytes;
    }

    public static int getBits(byte[] octet, int len) {
        System.out.println("\ngetBits (" + Converter.byteToBinaryString(octet[0]) + "_" + Converter.byteToBinaryString(octet[1]) + ", " + len + ")");
        int bits = 0;
        switch (len) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                bits = (octet[0] & 0xFF) >>> 8 - len;
                break;
            }
            case 8: {
                bits = octet[0];
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                int shift = 8 - (len - 8);
                int hi = (octet[0] & 0xFF) << 8;
                int lo = octet[1] & 0xFF;
                bits = hi + lo >>> shift;
                break;
            }
            case 16: {
                int hi = (octet[0] & 0xFF) << 8;
                int lo = octet[1] & 0xFF;
                bits = hi + lo;
                break;
            }
        }
        return bits;
    }

    public static int getBits(int number, int len) {
        System.out.println("\ngetBits (" + Converter.intToBinaryString(number, 16) + ", " + len + ")");
        byte[] octet = new byte[]{Converter.getHiByte(number), Converter.getLoByte(number)};
        return Converter.getBits(octet, len);
    }
}

