/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.a2j.codec.runtime;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ChunkingBERInputStream {
    BufferedInputStream in = null;

    public ChunkingBERInputStream(InputStream is) {
        this.in = new BufferedInputStream(is);
    }

    public byte[] getNextCompleteAPDU() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.completeConstructedType(this.in, baos, 0);
        byte[] result = baos.toByteArray();
        return result;
    }

    public int completeConstructedType(BufferedInputStream in, ByteArrayOutputStream baos, int level) throws IOException {
        int datalen;
        int bytes_written = 0;
        int first_byte = in.read();
        if (first_byte == -1) {
            throw new IOException("EOF");
        }
        byte c = (byte)first_byte;
        baos.write(c);
        ++bytes_written;
        c = (byte)(c & 0xFF);
        int next_tag_class = c & 0xC0;
        boolean next_is_constructed = (c & 0x20) != 0;
        boolean next_is_indefinite = false;
        int next_tag_number = c & 0x1F;
        if (next_tag_number == 31) {
            next_tag_number = 0;
            do {
                c = (byte)in.read();
                baos.write(c);
                ++bytes_written;
                next_tag_number <<= 7;
                next_tag_number |= c & 0x7F;
            } while ((c & 0x80) != 0);
        }
        int lenpart = in.read();
        baos.write(lenpart);
        ++bytes_written;
        if ((lenpart & 0x80) == 0) {
            datalen = lenpart;
            next_is_indefinite = false;
        } else if ((lenpart & 0x7F) == 0) {
            next_is_indefinite = true;
            datalen = 0;
        } else {
            next_is_indefinite = false;
            lenpart = (byte)(lenpart & 0x7F);
            datalen = 0;
            while (true) {
                int n = lenpart;
                lenpart = (byte)(n - 1);
                if (n <= 0) break;
                byte lenbyte = (byte)in.read();
                datalen = datalen << 8 | lenbyte & 0xFF;
                baos.write(lenbyte);
                ++bytes_written;
            }
        }
        if (next_is_indefinite) {
            if (next_is_constructed) {
                boolean more_data = true;
                in.mark(5);
                byte i1 = (byte)in.read();
                byte i2 = (byte)in.read();
                in.reset();
                if (i1 == 0 && i2 == 0) {
                    more_data = false;
                }
                while (more_data) {
                    this.completeConstructedType(in, baos, level + 1);
                    in.mark(5);
                    i1 = (byte)in.read();
                    i2 = (byte)in.read();
                    in.reset();
                    if (i1 != 0 || i2 != 0) continue;
                    more_data = false;
                }
                in.read();
                in.read();
                baos.write(0);
                ++bytes_written;
                baos.write(0);
                ++bytes_written;
            } else {
                byte b1 = (byte)in.read();
                baos.write(b1);
                ++bytes_written;
                byte b2 = (byte)in.read();
                baos.write(b2);
                ++bytes_written;
                while (b1 != 0 || b2 != 0) {
                    b1 = b2;
                    b2 = (byte)in.read();
                    baos.write(b2);
                    ++bytes_written;
                }
            }
        } else if (next_is_constructed) {
            while (datalen > 0) {
                int child_len = this.completeConstructedType(in, baos, level + 1);
                datalen -= child_len;
                bytes_written += child_len;
            }
        } else {
            byte[] buff = new byte[4096];
            while (datalen > 0) {
                int bytes_read = in.read(buff, 0, datalen > 4096 ? 4096 : (int)datalen);
                baos.write(buff, 0, bytes_read);
                datalen -= bytes_read;
                bytes_written += bytes_read;
            }
        }
        return bytes_written;
    }

    private void dbg(String msg, int level) {
        for (int i = 0; i < level; ++i) {
            System.err.print("  ");
        }
        System.err.print(msg);
    }
}

