/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pvalsecc.concurrent.FArrayBlockingQueue;

public class ActiveExecutor {
    public static Log LOGGER = LogFactory.getLog(ActiveExecutor.class);
    private final String description;
    private final int inputBufferSize;
    private final int outputBulkSize;
    private final Consumer[] consumers;
    private final FArrayBlockingQueue<Runnable> queue;
    private final ThreadLocal<List<Runnable>> inputBuffers = new ThreadLocal<List<Runnable>>(){

        @Override
        protected List<Runnable> initialValue() {
            return new ArrayList<Runnable>(ActiveExecutor.this.inputBufferSize);
        }
    };
    private final AtomicBoolean cancel = new AtomicBoolean(false);
    private int maxQueueSize = 0;
    private int nbQueueChanges = 0;
    private long sumQueueSizes = 0L;
    private static final Runnable STOP = new Runnable(){

        @Override
        public void run() {
            throw new RuntimeException("Not supposed to be called");
        }
    };

    public ActiveExecutor(String description, int nbThreads, int inputBufferSize, int queueCapacity, int outputBulkSize) {
        if (inputBufferSize > queueCapacity) {
            throw new RuntimeException("inputBufferSize must be smaller than queueCapacity");
        }
        if (nbThreads < 1) {
            throw new RuntimeException("nbThreads must be bigger or equal to 1");
        }
        if (outputBulkSize < 1) {
            throw new RuntimeException("outputBulkSize must be bigger or equal to 1");
        }
        this.outputBulkSize = outputBulkSize;
        this.description = description;
        this.inputBufferSize = inputBufferSize;
        this.consumers = new Consumer[nbThreads];
        for (int i = 0; i < this.consumers.length; ++i) {
            this.consumers[i] = new Consumer(description + " " + i);
        }
        this.queue = new FArrayBlockingQueue(queueCapacity);
    }

    public void start() {
        for (int i = 0; i < this.consumers.length; ++i) {
            Consumer consumer = this.consumers[i];
            consumer.start();
        }
    }

    public void stop(boolean kill) throws InterruptedException {
        if (kill) {
            this.cancel.set(true);
            this.queue.clear();
        } else {
            this.flush();
        }
        this.queue.put(STOP);
    }

    public void join() throws InterruptedException {
        for (int i = 0; i < this.consumers.length; ++i) {
            Consumer consumer = this.consumers[i];
            consumer.join();
        }
        if (LOGGER.isDebugEnabled() && this.nbQueueChanges > 0) {
            LOGGER.debug((Object)("Every consumers for [" + this.description + "] stopped (maxQueue=" + this.maxQueueSize + " avgQueueSize=" + this.sumQueueSizes / (long)this.nbQueueChanges + ")"));
        }
    }

    public void addTask(Runnable task) throws InterruptedException {
        if (this.inputBufferSize <= 1) {
            this.queue.put(task);
            this.updateQueueStats(this.queue.size());
        } else {
            List<Runnable> inputBuffer = this.inputBuffers.get();
            inputBuffer.add(task);
            if (inputBuffer.size() >= this.inputBufferSize) {
                this.flush();
            }
        }
    }

    public void flush() throws InterruptedException {
        if (this.inputBufferSize <= 1) {
            return;
        }
        List<Runnable> inputBuffer = this.inputBuffers.get();
        this.queue.put(inputBuffer);
        this.updateQueueStats(this.queue.size());
        inputBuffer.clear();
    }

    private void updateQueueStats(int queueSize) {
        this.maxQueueSize = Math.max(this.maxQueueSize, queueSize);
        ++this.nbQueueChanges;
        this.sumQueueSizes += (long)queueSize;
    }

    private class Consumer
    extends Thread {
        public Consumer(String name) {
            super(name);
        }

        @Override
        public void run() {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Consumer [" + this.getName() + "] started"));
            }
            ArrayList curTasks = new ArrayList(ActiveExecutor.this.outputBulkSize);
            int maxBulkSize = 0;
            long nbTasks = 0L;
            long nbRuns = 0L;
            while (true) {
                try {
                    while (true) {
                        ActiveExecutor.this.queue.blockingDrainTo(curTasks, ActiveExecutor.this.outputBulkSize);
                        ++nbRuns;
                        maxBulkSize = Math.max(maxBulkSize, curTasks.size());
                        for (int i = 0; i < curTasks.size(); ++i) {
                            Runnable task = (Runnable)curTasks.get(i);
                            ++nbTasks;
                            if (task == STOP || ActiveExecutor.this.cancel.get()) {
                                ActiveExecutor.this.queue.put(STOP);
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug((Object)("Consumer [" + this.getName() + "] stopped (maxBulkSize=" + maxBulkSize + " nbTasks=" + nbTasks + " avgBulk=" + nbTasks / nbRuns + ")"));
                                }
                                return;
                            }
                            task.run();
                        }
                        curTasks.clear();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

