/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.readers.MapReader;
import org.mapfish.print.map.readers.MapReaderFactory;
import org.mapfish.print.map.readers.TileCacheLayerInfo;
import org.mapfish.print.map.readers.TileableMapReader;
import org.mapfish.print.map.renderers.TileRenderer;
import org.mapfish.print.utils.DistanceUnit;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;

public class KaMapMapReader
extends TileableMapReader {
    private final String map;
    private final String group;
    private final String units;

    private KaMapMapReader(String map, String group, String units, RenderingContext context, PJsonObject params) {
        super(context, params);
        this.map = map;
        this.group = group;
        this.units = units;
        PJsonArray maxExtent = params.getJSONArray("maxExtent");
        PJsonArray tileSize = params.getJSONArray("tileSize");
        this.tileCacheLayerInfo = new TileCacheLayerInfo(params.getJSONArray("resolutions"), tileSize.getInt(0), tileSize.getInt(1), maxExtent.getFloat(0), maxExtent.getFloat(1), maxExtent.getFloat(2), maxExtent.getFloat(3), params.getString("extension"));
    }

    @Override
    protected TileRenderer.Format getFormat() {
        return TileRenderer.Format.BITMAP;
    }

    @Override
    protected void addCommonQueryParams(Map<String, List<String>> result, Transformer transformer, String srs, boolean first) {
    }

    @Override
    protected URI getTileUri(URI commonUri, Transformer transformer, double minGeoX, double minGeoY, double maxGeoX, double maxGeoY, long w, long h) throws URISyntaxException, UnsupportedEncodingException {
        double targetResolution = (maxGeoX - minGeoX) / (double)w;
        TileCacheLayerInfo.ResolutionInfo resolution = this.tileCacheLayerInfo.getNearestResolution(targetResolution);
        StringBuilder path = new StringBuilder();
        if (this.group != "") {
            path.append("g=").append(this.group).append('&');
        }
        path.append("map=").append(this.map).append('&');
        path.append("i=").append(this.tileCacheLayerInfo.getExtension()).append('&');
        DistanceUnit unitEnum = DistanceUnit.fromString(this.units);
        if (unitEnum == null) {
            throw new RuntimeException("Unknown unit: '" + this.units + "'");
        }
        double scale = this.context.getConfig().getBestScale(Math.max((maxGeoX - minGeoX) / DistanceUnit.PT.convertTo(w, unitEnum), (maxGeoY - minGeoY) / DistanceUnit.PT.convertTo(h, unitEnum)));
        path.append("s=").append(scale).append('&');
        long pX = Math.round(minGeoX / resolution.value);
        long pY = Math.round(maxGeoY / resolution.value) * -1L;
        pX = (long)Math.floor(pX / w) * w;
        pY = (long)Math.floor(pY / h) * h;
        path.append("l=").append(pX).append('&');
        path.append("t=").append(pY);
        return new URI(commonUri.getScheme(), commonUri.getUserInfo(), commonUri.getHost(), commonUri.getPort(), commonUri.getPath(), path.toString(), commonUri.getFragment());
    }

    @Override
    public boolean testMerge(MapReader other) {
        return false;
    }

    @Override
    public boolean canMerge(MapReader other) {
        return false;
    }

    @Override
    public String toString() {
        return this.map;
    }

    public static class Factory
    implements MapReaderFactory {
        public List<MapReader> create(String type, RenderingContext context, PJsonObject params) {
            ArrayList<MapReader> target = new ArrayList<MapReader>();
            String map = params.getString("map");
            String group = "";
            if (params.has("group")) {
                group = params.getString("group");
            }
            String units = context.getGlobalParams().getString("units");
            target.add(new KaMapMapReader(map, group, units, context, params));
            return target;
        }
    }
}

