/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.config.ColorWrapper;
import org.mapfish.print.config.layout.Block;

public abstract class FontBlock
extends Block {
    private String font = "Helvetica";
    protected Double fontSize = null;
    private String fontEncoding = "Cp1252";
    private String fontColor = "black";

    public void setFont(String font) {
        this.font = font;
    }

    public void setFontSize(Double fontSize) {
        this.fontSize = fontSize;
    }

    public void setFontSize(double fontSize) {
        this.fontSize = fontSize;
        if (fontSize < 0.0) {
            throw new InvalidValueException("fontSize", fontSize);
        }
    }

    public String getFont() {
        return this.font;
    }

    public double getFontSize() {
        if (this.fontSize != null) {
            return this.fontSize;
        }
        return 12.0;
    }

    public void setFontEncoding(String fontEncoding) {
        this.fontEncoding = fontEncoding;
    }

    protected Font getPdfFont() {
        Font result = FontFactory.getFont((String)this.font, (String)this.fontEncoding, (float)((float)this.getFontSize()));
        result.setColor(this.getFontColorVal());
        return result;
    }

    public void setFontColor(String fontColor) {
        this.fontColor = fontColor;
    }

    public BaseColor getFontColorVal() {
        return ColorWrapper.convertColor(this.fontColor);
    }
}

