/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.config;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.xml.transform.TransformerFactory;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.dbcp2.BasicDataSource;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.search.LuceneConfig;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.TransformerFactoryFactory;
import org.jdom.Content;
import org.jdom.Element;

@Deprecated
public class GetInfo
implements Service {
    final Properties properties = System.getProperties();
    private HashMap<String, String> catProperties = new HashMap();
    private HashMap<String, String> indexProperties = new HashMap();
    private HashMap<String, String> systemProperties = new HashMap();
    private HashMap<String, String> databaseProperties = new HashMap();

    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        this.loadSystemInfo();
        this.loadCatalogueInfo(gc);
        this.loadIndexInfo(context);
        this.loadDatabaseInfo(context);
        Element system = ((SettingManager)gc.getBean(SettingManager.class)).getAllAsXML(true);
        Element main = new Element("main");
        this.addToElement(main, this.systemProperties);
        Element index = new Element("index");
        this.addToElement(index, this.indexProperties);
        Element cat = new Element("catalogue");
        this.addToElement(cat, this.catProperties);
        Element db = new Element("database");
        this.addToElement(db, this.databaseProperties);
        Element info = new Element("info");
        info.addContent((Content)system);
        info.addContent((Content)cat);
        info.addContent((Content)main);
        info.addContent((Content)index);
        info.addContent((Content)db);
        return info;
    }

    private void loadCatalogueInfo(GeonetContext gc) {
        String[] props;
        ServiceConfig sc = (ServiceConfig)gc.getBean(ServiceConfig.class);
        for (String prop : props = new String[]{"dataDir", "codeListDir", "configDir", "schemaPluginsDir", "subversionPath", "resources", "formatterPath", "backupDir"}) {
            this.catProperties.put("data." + prop, sc.getValue(prop));
        }
    }

    private void loadSystemInfo() {
        this.systemProperties.put("java.version", this.properties.getProperty("java.version"));
        this.systemProperties.put("java.vm.name", this.properties.getProperty("java.vm.name"));
        this.systemProperties.put("java.vm.vendor", this.properties.getProperty("java.vm.vendor"));
        this.systemProperties.put("os.name", this.properties.getProperty("os.name"));
        this.systemProperties.put("os.arch", this.properties.getProperty("os.arch"));
        try {
            TransformerFactory transFact = TransformerFactoryFactory.getTransformerFactory();
            this.systemProperties.put("xslt.factory", transFact.getClass().getName());
            this.systemProperties.put("system.xslt.factory", System.getProperty("javax.xml.transform.TransformerFactory"));
        }
        catch (Exception e) {
            this.systemProperties.put("xslt.factory", "Exception:" + e.getMessage());
        }
        long freeMem = Runtime.getRuntime().freeMemory() / 1024L;
        long totMem = Runtime.getRuntime().totalMemory() / 1024L;
        this.systemProperties.put("mem.free", "" + freeMem);
        this.systemProperties.put("mem.total", "" + totMem);
    }

    private void loadIndexInfo(ServiceContext context) throws IOException {
        GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)context.getBean(GeonetworkDataDirectory.class);
        Path luceneDir = dataDirectory.getLuceneDir();
        this.indexProperties.put("index.path", luceneDir.toAbsolutePath().normalize().toString());
        if (Files.exists(luceneDir, new LinkOption[0])) {
            long size = this.sizeOfDirectory(luceneDir) / 1024L;
            this.indexProperties.put("index.size", "" + size);
        }
        this.indexProperties.put("index.lucene.config", ((LuceneConfig)context.getBean(LuceneConfig.class)).toString());
    }

    private long sizeOfDirectory(Path lDir) throws IOException {
        final long[] size = new long[]{0L};
        Files.walkFileTree(lDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                size[0] = size[0] + Files.size(file);
                return FileVisitResult.CONTINUE;
            }
        });
        return size[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDatabaseInfo(ServiceContext context) throws SQLException {
        String dbURL = null;
        try (Connection connection = null;){
            connection = ((DataSource)context.getBean(DataSource.class)).getConnection();
            dbURL = connection.getMetaData().getURL();
            this.databaseProperties.put("db.openattempt", "Database Opened Successfully");
            if (connection instanceof BasicDataSource) {
                BasicDataSource basicDataSource = (BasicDataSource)connection;
                try {
                    this.databaseProperties.put("db.numactive", "" + basicDataSource.getNumActive());
                    this.databaseProperties.put("db.numidle", "" + basicDataSource.getNumIdle());
                    this.databaseProperties.put("db.maxactive", "" + basicDataSource.getMaxTotal());
                }
                catch (Exception e) {
                    this.databaseProperties.put("db.statserror", "Failed to get stats on database connections. Error is: " + e.getMessage());
                }
            }
        }
        this.databaseProperties.put("db.url", dbURL);
    }

    private void addToElement(Element el, HashMap<String, String> h) {
        for (Map.Entry<String, String> entry : h.entrySet()) {
            el.addContent((Content)new Element(entry.getKey()).setText(entry.getValue()));
        }
    }
}

