/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.guiservices.templates;

import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.UUID;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.UpdateDatestamp;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;

@Deprecated
public class AddDefault
implements Service {
    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        String[] schemas;
        String schemaList = Util.getParam((Element)params, (String)"schema");
        String serviceStatus = "true";
        Element result = new Element("response");
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dataMan = (DataManager)gc.getBean(DataManager.class);
        SchemaManager schemaMan = (SchemaManager)gc.getBean(SchemaManager.class);
        String siteId = ((SettingManager)gc.getBean(SettingManager.class)).getSiteId();
        int owner = context.getUserSession().getUserIdAsInt();
        Log.info((String)"geonetwork.datamanager", (Object)("Loading templates for schemas " + schemaList));
        for (String schemaName : schemas = schemaList.split(",")) {
            Element schema = new Element(schemaName);
            Path templatesDir = schemaMan.getSchemaTemplatesDir(schemaName);
            if (templatesDir == null) {
                Log.warning((String)"geonetwork.datamanager", (Object)String.format("Skipping - No templates found for schema '%s'.", schemaName));
                continue;
            }
            String prefix = "sub-";
            int prefixLength = "sub-".length();
            try (DirectoryStream<Path> newDirectoryStream = Files.newDirectoryStream(templatesDir, "*.xml");){
                for (Path temp : newDirectoryStream) {
                    String status = "failed";
                    String templateName = temp.getFileName().toString();
                    Element template = new Element("template");
                    template.setAttribute("name", templateName);
                    if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
                        Log.debug((String)"geonetwork.datamanager", (Object)String.format(" - Adding %s template file %s ...", schemaName, templateName));
                    }
                    try {
                        Element xml = Xml.loadFile((Path)temp);
                        String uuid = UUID.randomUUID().toString();
                        String isTemplate = "y";
                        String title = null;
                        if (templateName.startsWith("sub-")) {
                            isTemplate = "s";
                            String tryUuid = xml.getAttributeValue("uuid");
                            if (tryUuid != null && tryUuid.length() > 0) {
                                uuid = tryUuid;
                            }
                            if ((title = xml.getAttributeValue("title")) == null || title.length() == 0) {
                                title = templateName.substring(prefixLength, templateName.length() - prefixLength);
                            }
                            xml.removeAttribute("uuid");
                            xml.removeAttribute("title");
                        }
                        Metadata metadata = new Metadata();
                        metadata.setUuid(uuid);
                        metadata.getDataInfo().setSchemaId(schemaName).setRoot(xml.getQualifiedName()).setType(MetadataType.lookup((String)isTemplate)).setTitle(title);
                        metadata.getSourceInfo().setSourceId(siteId).setOwner(Integer.valueOf(owner)).setGroupOwner(Integer.valueOf(1));
                        dataMan.insertMetadata(context, (AbstractMetadata)metadata, xml, true, true, true, UpdateDatestamp.NO, false, false);
                        status = "loaded";
                    }
                    catch (Exception e) {
                        serviceStatus = "false";
                        Log.error((String)"geonetwork.datamanager", (Object)String.format("Error loading %s template file %s. Error is %s.", schemaName, temp, e.getMessage()), (Throwable)e);
                    }
                    template.setAttribute("status", status);
                    schema.addContent((Content)template);
                }
            }
            result.addContent((Content)schema);
        }
        result.setAttribute("status", serviceStatus);
        return result;
    }
}

