/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy.template;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fao.geonet.api.records.formatters.groovy.template.TemplateException;
import org.fao.geonet.api.records.formatters.groovy.template.TextBlock;
import org.fao.geonet.api.records.formatters.groovy.template.TextContentFilter;
import org.fao.geonet.api.records.formatters.groovy.template.TextContentReplacement;
import org.fao.geonet.api.records.formatters.groovy.template.TextContentStatic;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TextContentParser {
    static final Pattern INTERPOLATION_PATTERN = Pattern.compile("\\{\\{(\\s*[^}]+\\s*)\\}\\}");
    @Autowired
    @VisibleForTesting
    Map<String, TextContentFilter> filters = Maps.newHashMap();

    public TextBlock parse(String text) {
        TextBlock textBlock = new TextBlock();
        Matcher matcher = INTERPOLATION_PATTERN.matcher(text);
        int start = 0;
        while (matcher.find()) {
            String key = matcher.group(1).trim();
            textBlock.add(new TextContentStatic(text.substring(start, matcher.start())));
            ArrayList applicableFilters = Lists.newArrayList();
            String[] parts = key.split("\\|");
            key = parts[0];
            for (int i = 1; i < parts.length; ++i) {
                String filterKey = parts[i].trim();
                TextContentFilter filter = this.filters.get(filterKey);
                if (filter == null) {
                    throw new TemplateException("There is no TextContentFilter with the id: '" + filterKey + "'");
                }
                applicableFilters.add(filter);
            }
            textBlock.add(new TextContentReplacement(key, applicableFilters));
            start = matcher.end();
        }
        textBlock.add(new TextContentStatic(text.substring(start, text.length())));
        return textBlock;
    }
}

