/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import jeeves.interfaces.Service;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Constants;
import org.fao.geonet.Util;
import org.fao.geonet.api.records.formatters.AbstractFormatService;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.jdom.Content;
import org.jdom.Element;

public class ListBundleFiles
extends AbstractFormatService
implements Service {
    private static final String[] extensions = new String[]{"properties", "xml", "xsl", "css", "js"};

    public Element exec(Element params, ServiceContext context) throws Exception {
        String xslid = Util.getParam((Element)params, (String)"id");
        String schema = Util.getParam((Element)params, (String)"schema", null);
        Path schemaDir = null;
        if (schema != null) {
            schemaDir = ((SchemaManager)context.getBean(SchemaManager.class)).getSchemaDir(schema);
        }
        Path formatDir = this.getAndVerifyFormatDir((GeonetworkDataDirectory)context.getBean(GeonetworkDataDirectory.class), "id", xslid, schemaDir).toRealPath(new LinkOption[0]);
        Element result = new Element("bundleFiles");
        this.makeTree("", formatDir, result);
        return result;
    }

    private void makeTree(String parentId, Path dir, Element result) throws IOException {
        try (DirectoryStream<Path> files = Files.newDirectoryStream(dir);){
            for (Path file : files) {
                Element element;
                String name = URLEncoder.encode(file.getFileName().toString(), Constants.ENCODING);
                String id = parentId + "/" + file.getFileName();
                if (Files.isDirectory(file, new LinkOption[0]) && this.legalFile(file)) {
                    element = new Element("dir");
                    this.makeTree(id, file, element);
                    if (element.getChildren().size() <= 0) continue;
                    element.setAttribute("leaf", "false");
                    element.setAttribute("text", file.getFileName().toString()).setAttribute("path", id).setAttribute("name", name);
                    result.addContent((Content)element);
                    continue;
                }
                if (!this.isEditibleFileType(file) || !this.legalFile(file)) continue;
                element = new Element("file");
                element.setAttribute("leaf", "true");
                element.setAttribute("text", file.getFileName().toString()).setAttribute("path", id).setAttribute("name", name);
                result.addContent((Content)element);
            }
        }
    }

    private boolean isEditibleFileType(Path f) {
        String fileName = f.getFileName().toString();
        for (String ext : extensions) {
            if (!fileName.endsWith("." + ext)) continue;
            return true;
        }
        return fileName.toString().equalsIgnoreCase("README");
    }

    private boolean legalFile(Path f) throws IOException {
        return !f.getFileName().startsWith(".") && !Files.isHidden(f) && Files.isReadable(f) && Files.isWritable(f);
    }
}

