/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import java.util.ArrayList;
import java.util.Arrays;
import jeeves.server.context.ServiceContext;
import jeeves.transaction.TransactionManager;
import jeeves.transaction.TransactionTask;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.records.editing.InspireValidatorUtils;
import org.fao.geonet.domain.MetadataValidation;
import org.fao.geonet.domain.MetadataValidationId;
import org.fao.geonet.domain.MetadataValidationStatus;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.TransactionStatus;

public class InspireValidationRunnable
implements Runnable {
    private String testId;
    private String endPoint;
    private int mdId;
    private ServiceContext context;

    public InspireValidationRunnable(ServiceContext context, String endPoint, String testId, int mdId) {
        this.context = context;
        this.testId = testId;
        this.mdId = mdId;
        this.endPoint = endPoint;
    }

    @Override
    public void run() {
        TransactionManager.runInTransaction((String)"inspire-validation", (ApplicationContext)ApplicationContextHolder.get(), (TransactionManager.TransactionRequirement)TransactionManager.TransactionRequirement.CREATE_NEW, (TransactionManager.CommitBehavior)TransactionManager.CommitBehavior.ALWAYS_COMMIT, (boolean)false, (TransactionTask)new TransactionTask<Object>(){

            public Object doInTransaction(TransactionStatus transaction) throws Throwable {
                InspireValidatorUtils inspireValidatorUtils = (InspireValidatorUtils)ApplicationContextHolder.get().getBean(InspireValidatorUtils.class);
                MetadataValidationRepository metadataValidationRepository = (MetadataValidationRepository)ApplicationContextHolder.get().getBean(MetadataValidationRepository.class);
                inspireValidatorUtils.waitUntilReady(InspireValidationRunnable.this.context, InspireValidationRunnable.this.endPoint, InspireValidationRunnable.this.testId);
                String reportUrl = inspireValidatorUtils.getReportUrl(InspireValidationRunnable.this.endPoint, InspireValidationRunnable.this.testId);
                String reportXmlUrl = InspireValidatorUtils.getReportUrlXML(InspireValidationRunnable.this.endPoint, InspireValidationRunnable.this.testId);
                String reportXml = inspireValidatorUtils.retrieveReport(InspireValidationRunnable.this.context, reportXmlUrl);
                String validationStatus = inspireValidatorUtils.isPassed(InspireValidationRunnable.this.context, InspireValidationRunnable.this.endPoint, InspireValidationRunnable.this.testId);
                MetadataValidationStatus metadataValidationStatus = inspireValidatorUtils.calculateValidationStatus(validationStatus);
                MetadataValidation metadataValidation = new MetadataValidation().setId(new MetadataValidationId(InspireValidationRunnable.this.mdId, "inspire")).setStatus(metadataValidationStatus).setRequired(Boolean.valueOf(false)).setReportUrl(reportUrl).setReportContent(reportXml);
                metadataValidationRepository.save((Object)metadataValidation);
                DataManager dataManager = (DataManager)ApplicationContextHolder.get().getBean(DataManager.class);
                dataManager.indexMetadata(new ArrayList<String>(Arrays.asList(InspireValidationRunnable.this.mdId + "")));
                return null;
            }
        });
    }
}

