/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.io.standard;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.geotools.graph.build.GraphGenerator;
import org.geotools.graph.io.standard.AbstractReaderWriter;
import org.geotools.graph.io.standard.FileReaderWriter;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Node;

public abstract class TextfileReaderWriter
extends AbstractReaderWriter
implements FileReaderWriter {
    public static final String DELIMITER = "DELIMITER";

    @Override
    public Graph read() throws Exception {
        String line;
        GraphGenerator generator = (GraphGenerator)this.getProperty("GENERATOR");
        BufferedReader in = new BufferedReader(new FileReader((String)this.getProperty("FILENAME")));
        String delim = (String)this.getProperty(DELIMITER);
        String string = delim = delim != null ? delim : ",";
        while ((line = in.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line, delim);
            generator.add(this.readInternal(st));
        }
        return generator.getGraph();
    }

    @Override
    public void write(Graph g) throws Exception {
        Iterator itr;
        BufferedWriter out = new BufferedWriter(new FileWriter((String)this.getProperty("FILENAME")));
        if (this.getProperty("NODES") != null) {
            itr = g.getNodes().iterator();
            while (itr.hasNext()) {
                this.writeNode(out, (Node)itr.next());
            }
        }
        if (this.getProperty("EDGES") != null) {
            itr = g.getEdges().iterator();
            while (itr.hasNext()) {
                this.writeEdge(out, (Edge)itr.next());
            }
        }
    }

    protected void writeNode(Writer out, Node n) {
    }

    protected void writeEdge(Writer out, Edge e) {
    }

    protected abstract Object readInternal(StringTokenizer var1);
}

