/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotools.factory.Hints;
import org.geotools.io.IndentedLineWriter;
import org.geotools.io.TableWriter;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.referencing.factory.FactoryNotFoundException;
import org.geotools.referencing.factory.PropertyAuthorityFactory;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.factory.epsg.ThreadedEpsgFactory;
import org.geotools.resources.Arguments;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FactoryUsingWKT
extends DeferredAuthorityFactory
implements CRSAuthorityFactory {
    private Citation authority;
    public static final String FILENAME = "epsg.properties";
    private final ReferencingFactoryContainer factories;
    protected static final int DEFAULT_PRIORITY = 80;
    private final File directory;

    public FactoryUsingWKT() {
        this((Hints)null);
    }

    public FactoryUsingWKT(Hints userHints) {
        this(userHints, 80);
    }

    protected FactoryUsingWKT(Hints userHints, int priority) {
        super(userHints, priority);
        this.factories = ReferencingFactoryContainer.instance(userHints);
        Object hint = null;
        if (userHints != null) {
            hint = userHints.get(Hints.CRS_AUTHORITY_EXTRA_DIRECTORY);
        }
        this.directory = hint instanceof File ? (File)hint : (hint instanceof String ? new File((String)hint) : null);
        this.hints.put(Hints.CRS_AUTHORITY_EXTRA_DIRECTORY, this.directory);
        this.setTimeout(900000L);
    }

    @Override
    public synchronized Citation getAuthority() {
        if (this.authority == null) {
            Citation[] authorities = this.getAuthorities();
            switch (authorities.length) {
                case 0: {
                    this.authority = Citations.EPSG;
                    break;
                }
                case 1: {
                    this.authority = authorities[0];
                    break;
                }
                default: {
                    CitationImpl c = new CitationImpl(authorities[0]);
                    Collection<Identifier> identifiers = c.getIdentifiers();
                    for (int i = 1; i < authorities.length; ++i) {
                        identifiers.addAll(authorities[i].getIdentifiers());
                    }
                    c.freeze();
                    this.authority = c;
                    break;
                }
            }
        }
        return this.authority;
    }

    protected Citation[] getAuthorities() {
        return new Citation[]{Citations.EPSG};
    }

    protected URL getDefinitionsURL() {
        try {
            File file;
            if (this.directory != null && (file = new File(this.directory, FILENAME)).isFile()) {
                return file.toURI().toURL();
            }
        }
        catch (SecurityException exception) {
            Logging.unexpectedException(LOGGER, exception);
        }
        catch (MalformedURLException exception) {
            Logging.unexpectedException(LOGGER, exception);
        }
        return FactoryUsingWKT.class.getResource(FILENAME);
    }

    @Override
    protected AbstractAuthorityFactory createBackingStore() throws FactoryException {
        try {
            URL url = this.getDefinitionsURL();
            if (url == null) {
                throw new FactoryNotFoundException(Errors.format(50, FILENAME));
            }
            Iterator ids = this.getAuthority().getIdentifiers().iterator();
            String authority = ids.hasNext() ? ((Identifier)ids.next()).getCode() : "EPSG";
            LogRecord record = Loggings.format(Level.CONFIG, 49, url.getPath(), authority);
            record.setLoggerName(LOGGER.getName());
            LOGGER.log(record);
            return new PropertyAuthorityFactory(this.factories, this.getAuthorities(), url);
        }
        catch (IOException exception) {
            throw new FactoryException(Errors.format(28, FILENAME), (Throwable)exception);
        }
    }

    private static final <T extends AbstractAuthorityFactory> T getFactory(Class<T> type) {
        return (T)((AbstractAuthorityFactory)type.cast(ReferencingFactoryFinder.getCRSAuthorityFactory("EPSG", new Hints(Hints.CRS_AUTHORITY_FACTORY, type))));
    }

    protected Set reportDuplicatedCodes(PrintWriter out) throws FactoryException {
        ThreadedEpsgFactory sqlFactory = FactoryUsingWKT.getFactory(ThreadedEpsgFactory.class);
        Vocabulary resources = Vocabulary.getResources(null);
        out.println(resources.getLabel(27));
        try {
            IndentedLineWriter w = new IndentedLineWriter(out);
            w.setIndentation(4);
            w.write(((AbstractAuthorityFactory)sqlFactory).getBackingStoreDescription());
            w.flush();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        out.println();
        Set<String> wktCodes = this.getAuthorityCodes(IdentifiedObject.class);
        Set sqlCodes = sqlFactory.getAuthorityCodes(IdentifiedObject.class);
        TreeSet<String> duplicated = new TreeSet<String>();
        for (String code : wktCodes) {
            if (!sqlCodes.contains(code = code.trim())) continue;
            duplicated.add(code);
        }
        if (duplicated.isEmpty()) {
            out.println(resources.getString(153));
        } else {
            for (String code : duplicated) {
                out.print(resources.getLabel(52));
                out.println(code);
            }
        }
        return duplicated;
    }

    protected Set reportInstantiationFailures(PrintWriter out) throws FactoryException {
        Set<String> codes = this.getAuthorityCodes(CoordinateReferenceSystem.class);
        TreeMap<String, String> failures = new TreeMap<String, String>();
        for (String string : codes) {
            try {
                this.createCoordinateReferenceSystem(string);
            }
            catch (FactoryException factoryException) {
                failures.put(string, factoryException.getLocalizedMessage());
            }
        }
        if (!failures.isEmpty()) {
            TableWriter writer = new TableWriter((Writer)out, " ");
            for (Map.Entry entry : failures.entrySet()) {
                writer.write((String)entry.getKey());
                writer.write(58);
                writer.nextColumn();
                writer.write((String)entry.getValue());
                writer.nextLine();
            }
            try {
                writer.flush();
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }
        return failures.keySet();
    }

    public static void main(String[] args) throws FactoryException {
        FactoryUsingWKT.main(args, FactoryUsingWKT.class);
    }

    static void main(String[] args, Class<? extends FactoryUsingWKT> type) throws FactoryException {
        Arguments arguments = new Arguments(args);
        Locale.setDefault(arguments.locale);
        boolean duplicated = arguments.getFlag("-duplicated");
        boolean instantiate = arguments.getFlag("-test");
        args = arguments.getRemainingArguments(0);
        FactoryUsingWKT factory = FactoryUsingWKT.getFactory(type);
        if (duplicated) {
            factory.reportDuplicatedCodes(arguments.out);
        }
        if (instantiate) {
            factory.reportInstantiationFailures(arguments.out);
        }
        factory.dispose();
    }
}

