/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.lang.SqlLexer;
import org.tmatesoft.sqljet.core.internal.lang.SqlParser;
import org.tmatesoft.sqljet.core.table.ISqlJetOptions;

public class SqlJetPragmasHandler {
    private final ISqlJetOptions options;

    public SqlJetPragmasHandler(ISqlJetOptions options) {
        this.options = options;
    }

    private ISqlJetOptions getOptions() {
        return this.options;
    }

    public Object pragma(String sql) throws SqlJetException {
        return this.pragma(this.parsePragma(sql));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object pragma(CommonTree ast) throws SqlJetException {
        assert ("pragma".equalsIgnoreCase(ast.getText()));
        String name = ast.getChild(0).getText();
        if (ast.getChildCount() > 1) {
            Object value = this.readPragmaValue(ast.getChild(1));
            if ("auto_vacuum".equals(name)) {
                int mode = this.readAutovacuumMode(value);
                this.getOptions().setAutovacuum(mode == 1);
                this.getOptions().setIncrementalVacuum(mode == 2);
                return null;
            } else if ("cache_size".equals(name)) {
                if (!(value instanceof Number)) throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid cache_size value: " + value);
                this.getOptions().setCacheSize(((Number)value).intValue());
                return null;
            } else if ("encoding".equals(name)) {
                if (!(value instanceof String)) throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid encoding value: " + value);
                SqlJetEncoding enc = SqlJetEncoding.decode((String)value);
                if (enc == null) throw new SqlJetException(SqlJetErrorCode.ERROR, "Unknown encoding: " + value);
                this.getOptions().setEncoding(enc);
                return null;
            } else if ("legacy_file_format".equals(name)) {
                this.getOptions().setLegacyFileFormat(this.toBooleanValue(value));
                return null;
            } else if ("schema_version".equals(name)) {
                if (!(value instanceof Number)) throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid schema_version value: " + value);
                int version = ((Number)value).intValue();
                this.getOptions().setSchemaVersion(version);
                return null;
            } else {
                if (!"user_version".equals(name)) return null;
                if (!(value instanceof Number)) throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid user_version value: " + value);
                int version = ((Number)value).intValue();
                this.getOptions().setUserVersion(version);
            }
            return null;
        }
        if ("auto_vacuum".equals(name)) {
            int mode = 0;
            if (this.getOptions().isAutovacuum()) {
                mode = 1;
            }
            if (!this.getOptions().isIncrementalVacuum()) return mode;
            mode = 2;
            return mode;
        }
        if ("cache_size".equals(name)) {
            return this.getOptions().getCacheSize();
        }
        if ("encoding".equals(name)) {
            return this.getOptions().getEncoding();
        }
        if ("legacy_file_format".equals(name)) {
            return this.getOptions().isLegacyFileFormat();
        }
        if ("schema_version".equals(name)) {
            return this.getOptions().getSchemaVersion();
        }
        if (!"user_version".equals(name)) return null;
        return this.getOptions().getUserVersion();
    }

    private int readAutovacuumMode(Object value) throws SqlJetException {
        int i;
        int mode = -1;
        if (value instanceof String) {
            String s = ((String)value).toLowerCase();
            if ("none".equals(s)) {
                mode = 0;
            } else if ("full".equals(s)) {
                mode = 1;
            } else if ("incremental".equals(s)) {
                mode = 2;
            }
        } else if (value instanceof Number && ((i = ((Number)value).intValue()) == 0 || i == 1 || i == 2)) {
            mode = i;
        }
        if (mode < 0) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid auto_vacuum value: " + value);
        }
        return mode;
    }

    private CommonTree parsePragma(String sql) throws SqlJetException {
        try {
            ANTLRStringStream chars = new ANTLRStringStream(sql);
            SqlLexer lexer = new SqlLexer((CharStream)chars);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            SqlParser parser = new SqlParser((TokenStream)tokens);
            return (CommonTree)parser.pragma_stmt().getTree();
        }
        catch (RecognitionException re) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Invalid sql statement: " + sql);
        }
    }

    private Object readPragmaValue(Tree node) {
        String type = node.getText().toLowerCase();
        String value = node.getChild(0).getText();
        if ("float_literal".equals(type)) {
            return Double.valueOf(value);
        }
        if ("id_literal".equals(type)) {
            return value;
        }
        if ("string_literal".equals(type)) {
            return value.substring(1, value.length() - 1);
        }
        throw new IllegalStateException();
    }

    protected boolean toBooleanValue(Object value) throws SqlJetException {
        if (value instanceof Number) {
            int i = ((Number)value).intValue();
            if (i == 0) {
                return false;
            }
            if (i == 1) {
                return true;
            }
        } else if (value instanceof String) {
            String s = ((String)value).toLowerCase();
            if ("yes".equals(s) || "true".equals(s) || "on".equals(s)) {
                return true;
            }
            if ("no".equals(s) || "false".equals(s) || "off".equals(s)) {
                return false;
            }
        }
        throw new SqlJetException(SqlJetErrorCode.ERROR, "Boolean value is expected.");
    }

    protected Object toResult(boolean value) {
        return value ? Integer.valueOf(1) : Integer.valueOf(0);
    }
}

