/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.gui.treetable;

import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.dlib.gui.CustomLook;
import org.dlib.gui.TComboBox;
import org.dlib.gui.flextable.FlexTableColumn;
import org.dlib.gui.flextable.FlexTableEditor;
import org.dlib.gui.flextable.FlexTableRenderer;
import org.dlib.gui.treetable.TreeTableCellEditor;
import org.dlib.gui.treetable.TreeTableCellRenderer;
import org.dlib.gui.treeview.TreeViewNode;
import org.dlib.gui.treeview.TreeViewSelEvent;
import org.dlib.gui.treeview.TreeViewSelListener;

public class TreeTable
extends JScrollPane
implements TableModel,
ListSelectionListener,
TreeModelListener,
TreeSelectionListener,
TreeExpansionListener {
    private JTable jTable;
    private TreeTableCellRenderer jTree;
    private TreeTableCellEditor jTreeEditor;
    private DefaultTreeModel defTreeMod;
    private DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
    private EventListenerList listList = new EventListenerList();
    private boolean bEditable = false;
    static /* synthetic */ Class class$org$dlib$gui$treeview$TreeViewSelListener;
    static /* synthetic */ Class class$javax$swing$event$TableModelListener;
    static /* synthetic */ Class class$org$dlib$gui$treeview$TreeViewNode;
    static /* synthetic */ Class class$java$lang$String;

    public TreeTable() {
        this(false);
    }

    public TreeTable(boolean bl) {
        this.bEditable = bl;
        TreeViewNode treeViewNode = new TreeViewNode();
        this.defTreeMod = new DefaultTreeModel(treeViewNode);
        this.defTreeMod.addTreeModelListener(this);
        this.jTree = new TreeTableCellRenderer(treeViewNode);
        this.jTree.getSelectionModel().setSelectionMode(1);
        this.jTree.addTreeSelectionListener(this);
        this.jTree.addTreeExpansionListener(this);
        this.jTree.setShowsRootHandles(true);
        this.jTree.setRootVisible(false);
        this.jTree.setEditable(false);
        this.jTree.setModel(this.defTreeMod);
        this.jTree.putClientProperty("JTree.lineStyle", "Angled");
        ToolTipManager.sharedInstance().registerComponent(this.jTree);
        this.jTree.setRowHeight(18);
        this.jTable = new JTable(this, this.columnModel){

            public void paintComponent(Graphics graphics) {
                CustomLook.setup(graphics);
                super.paintComponent(graphics);
            }
        };
        this.jTable.setSelectionMode(0);
        this.jTable.setRowHeight(this.jTree.getRowHeight());
        this.jTable.setTableHeader(new JTableHeader(this.columnModel){

            public void paintComponent(Graphics graphics) {
                CustomLook.setup(graphics);
                super.paintComponent(graphics);
            }
        });
        this.setViewportView(this.jTable);
        ListSelectionModel listSelectionModel = this.jTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        LookAndFeel.installColorsAndFont(this.jTable, "Tree.background", "Tree.foreground", "Tree.font");
        this.jTree.setTable(this.jTable);
        this.jTreeEditor = new TreeTableCellEditor();
        this.jTreeEditor.setTree(this.jTree);
    }

    public FlexTableColumn addHeader(String string, int n) {
        return this.addHeader(string, n, true);
    }

    public FlexTableColumn addHeader(String string, int n, boolean bl) {
        int n2 = this.columnModel.getColumnCount();
        FlexTableColumn flexTableColumn = new FlexTableColumn(string, n);
        flexTableColumn.setEditable(bl);
        flexTableColumn.setModelIndex(n2);
        this.columnModel.addColumn(flexTableColumn);
        if (n2 == 0) {
            this.jTree.setEditable(bl);
            flexTableColumn.setCellRenderer(this.jTree);
            flexTableColumn.setCellEditor(this.jTreeEditor);
        }
        return flexTableColumn;
    }

    public FlexTableColumn addHeader(String string, int n, JButton jButton) {
        FlexTableColumn flexTableColumn = this.addHeader(string, n, true);
        flexTableColumn.setCellEditor(new FlexTableEditor(jButton));
        return flexTableColumn;
    }

    public FlexTableColumn addHeader(String string, int n, TComboBox tComboBox) {
        FlexTableColumn flexTableColumn = this.addHeader(string, n, true);
        flexTableColumn.setCellEditor(new FlexTableEditor(tComboBox));
        flexTableColumn.setCellRenderer(new FlexTableRenderer(tComboBox));
        return flexTableColumn;
    }

    public void setRootNode(TreeViewNode treeViewNode) {
        TreeViewNode treeViewNode2 = this.getRootNode();
        if (treeViewNode2 != null) {
            treeViewNode2.setTree(null);
        }
        treeViewNode.setTree(this.jTree);
        this.defTreeMod.setRoot(treeViewNode);
        this.updateTable();
    }

    public TreeViewNode getRootNode() {
        return (TreeViewNode)this.defTreeMod.getRoot();
    }

    public void setRootVisible(boolean bl) {
        this.jTree.setRootVisible(bl);
    }

    public TreeViewNode getSelectedNode() {
        return (TreeViewNode)this.jTree.getLastSelectedPathComponent();
    }

    public void clearSelection() {
        this.jTree.clearSelection();
    }

    public void setTreeCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.jTree.setCellRenderer(treeCellRenderer);
    }

    public void setEditable(boolean bl) {
        this.bEditable = bl;
    }

    public void addSelectionListener(TreeViewSelListener treeViewSelListener) {
        this.listList.add(class$org$dlib$gui$treeview$TreeViewSelListener == null ? (class$org$dlib$gui$treeview$TreeViewSelListener = TreeTable.class$("org.dlib.gui.treeview.TreeViewSelListener")) : class$org$dlib$gui$treeview$TreeViewSelListener, treeViewSelListener);
    }

    public void removeSelectionListener(TreeViewSelListener treeViewSelListener) {
        this.listList.remove(class$org$dlib$gui$treeview$TreeViewSelListener == null ? (class$org$dlib$gui$treeview$TreeViewSelListener = TreeTable.class$("org.dlib.gui.treeview.TreeViewSelListener")) : class$org$dlib$gui$treeview$TreeViewSelListener, treeViewSelListener);
    }

    public void fireNodeSelected(TreeViewNode treeViewNode) {
        Object[] objectArray = this.listList.getListenerList();
        TreeViewSelEvent treeViewSelEvent = new TreeViewSelEvent(this, treeViewNode);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$dlib$gui$treeview$TreeViewSelListener == null ? TreeTable.class$("org.dlib.gui.treeview.TreeViewSelListener") : class$org$dlib$gui$treeview$TreeViewSelListener)) continue;
            ((TreeViewSelListener)objectArray[i + 1]).nodeSelected(treeViewSelEvent);
        }
    }

    public void fireTableCellUpdated(int n, int n2) {
        TableModelEvent tableModelEvent = new TableModelEvent(this, n, n, n2);
        Object[] objectArray = this.listList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$TableModelListener == null ? TreeTable.class$("javax.swing.event.TableModelListener") : class$javax$swing$event$TableModelListener)) continue;
            ((TableModelListener)objectArray[i + 1]).tableChanged(tableModelEvent);
        }
    }

    public TreeViewNode getNodeFromRow(int n) {
        return (TreeViewNode)this.jTree.getPathForRow(n).getLastPathComponent();
    }

    public void setRowHeight(int n) {
        this.jTable.setRowHeight(n);
        this.jTree.setRowHeight(this.jTable.getRowHeight());
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listList.add(class$javax$swing$event$TableModelListener == null ? (class$javax$swing$event$TableModelListener = TreeTable.class$("javax.swing.event.TableModelListener")) : class$javax$swing$event$TableModelListener, tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listList.remove(class$javax$swing$event$TableModelListener == null ? (class$javax$swing$event$TableModelListener = TreeTable.class$("javax.swing.event.TableModelListener")) : class$javax$swing$event$TableModelListener, tableModelListener);
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return class$org$dlib$gui$treeview$TreeViewNode == null ? (class$org$dlib$gui$treeview$TreeViewNode = TreeTable.class$("org.dlib.gui.treeview.TreeViewNode")) : class$org$dlib$gui$treeview$TreeViewNode;
        }
        TreeViewNode treeViewNode = this.getRootNode();
        if (treeViewNode == null) {
            return class$java$lang$String == null ? (class$java$lang$String = TreeTable.class$("java.lang.String")) : class$java$lang$String;
        }
        return treeViewNode.getColumnAt(n - 1).getClass();
    }

    public boolean isCellEditable(int n, int n2) {
        if (!this.bEditable) {
            return false;
        }
        return ((FlexTableColumn)this.columnModel.getColumn(n2)).isEditable();
    }

    public int getColumnCount() {
        return this.columnModel.getColumnCount();
    }

    public String getColumnName(int n) {
        return (String)this.columnModel.getColumn(n).getHeaderValue();
    }

    public int getRowCount() {
        return this.jTree.getRowCount();
    }

    public Object getValueAt(int n, int n2) {
        TreeViewNode treeViewNode = this.getNodeFromRow(n);
        if (n2 == 0) {
            return treeViewNode.getText();
        }
        return treeViewNode.getColumnAt(n2 - 1);
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            throw new IllegalArgumentException("Error, col is zero !");
        }
        this.getNodeFromRow(n).setColumnAt(object, n2 - 1);
        this.fireTableCellUpdated(n, n2);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (listSelectionModel.isSelectionEmpty()) {
            this.jTree.clearSelection();
            this.fireNodeSelected(null);
        } else {
            TreeViewNode treeViewNode = this.getNodeFromRow(listSelectionModel.getMinSelectionIndex());
            treeViewNode.select();
            this.fireNodeSelected(treeViewNode);
        }
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        TreeViewNode treeViewNode = (TreeViewNode)treeModelEvent.getTreePath().getLastPathComponent();
        int[] nArray = treeModelEvent.getChildIndices();
        if (nArray != null) {
            treeViewNode = treeViewNode.getChild(nArray[0]);
        }
        treeViewNode.textChanged();
        this.delayedFireTableDataChanged();
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.delayedFireTableDataChanged();
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.delayedFireTableDataChanged();
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.delayedFireTableDataChanged();
    }

    private void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeTable.this.updateTable();
            }
        });
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.updateTable();
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.updateTable();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreeViewNode treeViewNode = (TreeViewNode)this.jTree.getLastSelectedPathComponent();
        this.fireNodeSelected(treeViewNode);
        if (treeViewNode != null) {
            int n = this.jTree.getRowForPath(new TreePath(treeViewNode));
            if (n != -1) {
                this.jTable.setRowSelectionInterval(n, n);
            }
        } else {
            this.jTable.clearSelection();
        }
    }

    private void updateTable() {
        this.jTable.revalidate();
        this.jTable.repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

