/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import java.util.Set;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.fao.geonet.kernel.search.LuceneSearcher;

public class WildCardStringAnalyzer {
    public String analyze(String string, String luceneIndexField, PerFieldAnalyzerWrapper _analyzer, Set<String> _tokenizedFieldSet) {
        String[] starSeparatedList;
        StringBuilder starsPreserved = new StringBuilder();
        for (String starSeparatedPart : starSeparatedList = string.split("\\*")) {
            StringBuilder qPreserved = new StringBuilder();
            if (starSeparatedPart.indexOf(63) >= 0) {
                String[] qSeparatedList;
                for (String qSeparatedPart : qSeparatedList = starSeparatedPart.split("\\?")) {
                    String analyzedPart = LuceneSearcher.analyzeQueryText(luceneIndexField, qSeparatedPart, _analyzer, _tokenizedFieldSet);
                    qPreserved.append('?').append(analyzedPart);
                }
                if (qPreserved.length() > 0) {
                    qPreserved.deleteCharAt(0);
                }
                starsPreserved.append('*').append((CharSequence)qPreserved);
                continue;
            }
            starsPreserved.append('*');
            String analyzedQueryText = LuceneSearcher.analyzeQueryText(luceneIndexField, starSeparatedPart, _analyzer, _tokenizedFieldSet);
            starsPreserved.append(analyzedQueryText);
        }
        if (starsPreserved.length() > 0) {
            starsPreserved.deleteCharAt(0);
        }
        if (string.endsWith("*")) {
            starsPreserved.append("*");
        } else if (string.endsWith("?")) {
            starsPreserved.append("?");
        }
        return starsPreserved.toString();
    }
}

