/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.search.MetaSearcher;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.repository.specification.OperationAllowedSpecs;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;

class UnusedSearcher
extends MetaSearcher {
    private ArrayList<String> alResult;
    private Element elSummary;

    @Override
    public void search(ServiceContext context, Element request, ServiceConfig config) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SettingManager sm = gc.getBean(SettingManager.class);
        String siteId = sm.getSiteId();
        this.alResult = new ArrayList();
        int maxDiff = Integer.parseInt(Util.getParam((Element)request, (String)"maxDiff", (String)"5"));
        context.info("UnusedSearcher : using maxDiff=" + maxDiff);
        Specifications spec = Specifications.where((Specification)MetadataSpecs.isType((MetadataType)MetadataType.TEMPLATE)).and(MetadataSpecs.isHarvested((boolean)false)).and(MetadataSpecs.hasSource((String)siteId));
        List<? extends AbstractMetadata> list = context.getBean(IMetadataUtils.class).findAll((Specification<? extends AbstractMetadata>)spec);
        for (AbstractMetadata abstractMetadata : list) {
            int id = abstractMetadata.getId();
            ISODate createDate = abstractMetadata.getDataInfo().getCreateDate();
            ISODate changeDate = abstractMetadata.getDataInfo().getChangeDate();
            if (changeDate.timeDifferenceInSeconds(createDate) / 60L >= (long)maxDiff || this.hasInternetGroup(context, id)) continue;
            this.alResult.add("" + id);
        }
        this.makeSummary();
        this.initSearchRange(context);
    }

    @Override
    public List<Document> presentDocuments(ServiceContext srvContext, Element request, ServiceConfig config) throws Exception {
        throw new UnsupportedOperationException("Not supported by Unused searcher");
    }

    @Override
    public Element present(ServiceContext srvContext, Element request, ServiceConfig config) throws Exception {
        this.updateSearchRange(request);
        GeonetContext gc = (GeonetContext)srvContext.getHandlerContext("contextName");
        Element response = new Element("response");
        response.setAttribute("from", this.getFrom() + "");
        response.setAttribute("to", this.getTo() + "");
        response.addContent((Content)((Element)this.elSummary.clone()));
        if (this.getTo() > 0) {
            for (int i = this.getFrom() - 1; i < this.getTo(); ++i) {
                String id = this.alResult.get(i);
                boolean forEditing = false;
                boolean withValidationErrors = false;
                boolean keepXlinkAttributes = false;
                Element md = gc.getBean(DataManager.class).getMetadata(srvContext, id, forEditing, withValidationErrors, keepXlinkAttributes);
                response.addContent((Content)md);
            }
        }
        return response;
    }

    @Override
    public int getSize() {
        return this.alResult.size();
    }

    @Override
    public Element getSummary() throws Exception {
        Element response = new Element("response");
        response.addContent((Content)((Element)this.elSummary.clone()));
        return response;
    }

    @Override
    public void close() {
    }

    private boolean hasInternetGroup(ServiceContext context, int id) throws SQLException {
        OperationAllowedRepository operationAllowedRepository = context.getBean(OperationAllowedRepository.class);
        Specification hasGroupId = OperationAllowedSpecs.hasGroupId((int)ReservedGroup.all.getId());
        Specification hasMetadataId = OperationAllowedSpecs.hasMetadataId((int)id);
        Specifications spec = Specifications.where((Specification)hasGroupId).and(hasMetadataId);
        List opsAllowed = operationAllowedRepository.findAll((Specification)spec);
        return !opsAllowed.isEmpty();
    }

    private void makeSummary() throws Exception {
        this.elSummary = new Element("summary");
        this.elSummary.setAttribute("count", this.getSize() + "");
        this.elSummary.setAttribute("type", "local");
        Element elKeywords = new Element("keywords");
        this.elSummary.addContent((Content)elKeywords);
        Element elCategories = new Element("categories");
        this.elSummary.addContent((Content)elCategories);
    }

    @Override
    public long getVersionToken() {
        return -1L;
    }
}

