/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import jeeves.server.overrides.ConfigurationOverrides;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.util.Version;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.search.facet.Dimension;
import org.fao.geonet.kernel.search.facet.Facets;
import org.fao.geonet.kernel.search.facet.SummaryTypes;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ConfigurableApplicationContext;

public class LuceneConfig {
    public static final String USE_NRT_MANAGER_REOPEN_THREAD = "useNRTManagerReopenThread";
    private static final int ANALYZER_CLASS = 1;
    private static final int BOOST_CLASS = 2;
    private static final int DOC_BOOST_CLASS = 3;
    private static final double DEFAULT_RAMBUFFERSIZEMB = 48.0;
    private static final int DEFAULT_MERGEFACTOR = 10;
    private Path configurationFile;
    private LinkedHashSet<String> fuzzyMatching;
    private Set<String> tokenizedFields = new LinkedHashSet<String>();
    private Map<String, LuceneConfigNumericField> numericFields = new HashMap<String, LuceneConfigNumericField>();
    private Map<String, String> dumpFields = new HashMap<String, String>();
    private String defaultAnalyzerClass;
    private Map<String, String> fieldSpecificSearchAnalyzers = new HashMap<String, String>();
    private Map<String, String> fieldSpecificAnalyzers = new HashMap<String, String>();
    private Map<String, Float> fieldBoost = new HashMap<String, Float>();
    private Map<String, Object[]> analyzerParameters = new HashMap<String, Object[]>();
    private Map<String, Class<?>[]> analyzerParametersClass = new HashMap<String, Class<?>[]>();
    private String boostQueryClass;
    private Map<String, Object[]> boostQueryParameters = new HashMap<String, Object[]>();
    private Map<String, Class<?>[]> boostQueryParametersClass = new HashMap<String, Class<?>[]>();
    private String documentBoostClass;
    private Map<String, Object[]> documentBoostParameters = new HashMap<String, Object[]>();
    private Map<String, Class<?>[]> documentBoostParametersClass = new HashMap<String, Class<?>[]>();
    private Element luceneConfig;
    private double RAMBufferSizeMB = 48.0;
    private int MergeFactor = 10;
    private boolean trackDocScores = false;
    private boolean trackMaxScore = false;
    private boolean docsScoredInOrder = false;
    private long commitInterval = 30000L;
    private boolean useNRTManagerReopenThread = true;
    private double nrtManagerReopenThreadMaxStaleSec = 5.0;
    private double nrtManagerReopenThreadMinStaleSec = 0.1f;
    private Version LUCENE_VERSION = Geonet.LUCENE_VERSION;
    private Set<String> multilingualSortFields = new LinkedHashSet<String>();
    private Facets facets;
    private SummaryTypes summaryTypes;

    public LuceneConfig(Facets facets, SummaryTypes summaryTypes) {
        this.facets = facets;
        this.summaryTypes = summaryTypes;
    }

    public static String multilingualSortFieldName(String fieldName, String locale) {
        return fieldName + "|" + locale;
    }

    public void configure(String luceneConfigXmlFile) {
        ServletContext servletContext;
        ConfigurableApplicationContext _appContext = ApplicationContextHolder.get();
        GeonetworkDataDirectory geonetworkDataDirectory = (GeonetworkDataDirectory)_appContext.getBean(GeonetworkDataDirectory.class);
        if (Log.isDebugEnabled((String)"geonetwork.search")) {
            Log.debug((String)"geonetwork.search", (Object)"Loading Lucene configuration ...");
        }
        this.configurationFile = geonetworkDataDirectory.resolveWebResource(luceneConfigXmlFile);
        try {
            servletContext = (ServletContext)_appContext.getBean(ServletContext.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            servletContext = null;
        }
        this.load(servletContext, luceneConfigXmlFile);
    }

    private void load(ServletContext servletContext, String luceneConfigXmlFile) {
        ConfigurableApplicationContext _appContext = ApplicationContextHolder.get();
        GeonetworkDataDirectory geonetworkDataDirectory = (GeonetworkDataDirectory)_appContext.getBean(GeonetworkDataDirectory.class);
        try (InputStream in = IO.newInputStream((Path)this.configurationFile);){
            Element searchConfig;
            String name;
            String minStaleNS;
            String maxStaleNS;
            String reopenThread;
            String rb;
            Element elem;
            String version;
            this.luceneConfig = Xml.loadStream((InputStream)in);
            if (servletContext != null) {
                ConfigurationOverrides.DEFAULT.updateWithOverrides(luceneConfigXmlFile, servletContext, geonetworkDataDirectory.getWebappDir(), this.luceneConfig);
            }
            if ((version = (elem = this.luceneConfig.getChild("index")).getChildText("luceneVersion")) != null) {
                try {
                    this.LUCENE_VERSION = Version.valueOf((String)("LUCENE_" + version));
                    if (this.LUCENE_VERSION == null) {
                        this.LUCENE_VERSION = Geonet.LUCENE_VERSION;
                    }
                }
                catch (Exception e) {
                    Log.warning((String)"geonetwork.search", (Object)("Failed to set Lucene version to: " + version + ". Set to default: " + Geonet.LUCENE_VERSION.toString()));
                    this.LUCENE_VERSION = Geonet.LUCENE_VERSION;
                }
            }
            if ((rb = elem.getChildText("RAMBufferSizeMB")) == null) {
                this.RAMBufferSizeMB = 48.0;
            } else {
                try {
                    this.RAMBufferSizeMB = Double.parseDouble(rb);
                }
                catch (NumberFormatException e) {
                    Log.warning((String)"geonetwork.search", (Object)"Invalid double value for RAM buffer size. Using default value.");
                    this.RAMBufferSizeMB = 48.0;
                }
            }
            String mf = elem.getChildText("MergeFactor");
            if (mf == null) {
                this.MergeFactor = 10;
            } else {
                try {
                    this.MergeFactor = Integer.parseInt(mf);
                }
                catch (NumberFormatException e) {
                    Log.warning((String)"geonetwork.search", (Object)"Invalid integer value for merge factor. Using default value.");
                    this.MergeFactor = 10;
                }
            }
            String cI = elem.getChildText("commitInterval");
            if (cI != null) {
                try {
                    this.commitInterval = Long.parseLong(cI);
                }
                catch (NumberFormatException e) {
                    Log.warning((String)"geonetwork.search", (Object)"Invalid long value for commitInterval. Using default value.");
                }
            }
            if ((reopenThread = elem.getChildText(USE_NRT_MANAGER_REOPEN_THREAD)) != null) {
                try {
                    this.useNRTManagerReopenThread = Boolean.parseBoolean(reopenThread);
                }
                catch (NumberFormatException e) {
                    Log.warning((String)"geonetwork.search", (Object)"Invalid boolean value for useNRTManagerReopenThread. Using default value.");
                }
            }
            if ((maxStaleNS = elem.getChildText("nrtManagerReopenThreadMaxStaleSec")) != null) {
                try {
                    this.nrtManagerReopenThreadMaxStaleSec = Double.parseDouble(maxStaleNS);
                }
                catch (NumberFormatException e) {
                    Log.warning((String)"geonetwork.search", (Object)"Invalid Double value for nrtManagerReopenThreadMaxStaleSec. Using default value.");
                }
            }
            if ((minStaleNS = elem.getChildText("nrtManagerReopenThreadMinStaleSec")) != null) {
                try {
                    this.nrtManagerReopenThreadMinStaleSec = Double.parseDouble(minStaleNS);
                }
                catch (NumberFormatException e) {
                    Log.warning((String)"geonetwork.search", (Object)"Invalid Double value for nrtManagerReopenThreadMinStaleSec. Using default value.");
                }
            }
            elem = this.luceneConfig.getChild("tokenized");
            this.tokenizedFields = new LinkedHashSet<String>();
            if (elem != null) {
                for (Object o : elem.getChildren()) {
                    if (!(o instanceof Element)) continue;
                    name = ((Element)o).getAttributeValue("name");
                    if (name == null) {
                        Log.warning((String)"geonetwork.search", (Object)"Tokenized element must have a name attribute, check Lucene configuration file.");
                        continue;
                    }
                    this.tokenizedFields.add(name);
                }
            }
            if ((elem = this.luceneConfig.getChild("fuzzyMatching")) != null && "true".equalsIgnoreCase(elem.getAttributeValue("enabled"))) {
                this.fuzzyMatching = new LinkedHashSet();
                for (Object o : elem.getChildren()) {
                    if (!(o instanceof Element)) continue;
                    name = ((Element)o).getAttributeValue("name");
                    if (name == null) {
                        Log.warning((String)"geonetwork.search", (Object)"fuzzyMatching element must have a name attribute, check Lucene configuration file.");
                        continue;
                    }
                    this.fuzzyMatching.add(name);
                }
            }
            elem = this.luceneConfig.getChild("numeric");
            this.numericFields = new HashMap<String, LuceneConfigNumericField>();
            if (elem != null) {
                for (Object o : elem.getChildren()) {
                    if (!(o instanceof Element)) continue;
                    name = ((Element)o).getAttributeValue("name");
                    String type = ((Element)o).getAttributeValue("type");
                    String precisionStep = ((Element)o).getAttributeValue("precision");
                    if (name == null) {
                        Log.warning((String)"geonetwork.search", (Object)"Numeric field element must have a name attribute, check Lucene configuration file.");
                        continue;
                    }
                    LuceneConfigNumericField field = new LuceneConfigNumericField(name, type, precisionStep);
                    this.numericFields.put(name, field);
                }
            }
            if ((elem = this.luceneConfig.getChild("defaultAnalyzer")) != null) {
                this.defaultAnalyzerClass = elem.getAttribute("name").getValue();
                List paramChildren = elem.getChildren("Param");
                this.loadClassParameters(1, "", this.defaultAnalyzerClass, paramChildren);
            }
            this.fieldSpecificAnalyzers = new HashMap<String, String>();
            this.loadAnalyzerConfig("fieldSpecificAnalyzer", this.fieldSpecificAnalyzers);
            this.fieldSpecificSearchAnalyzers = new HashMap<String, String>(this.fieldSpecificAnalyzers);
            this.loadAnalyzerConfig("fieldSpecificSearchAnalyzer", this.fieldSpecificSearchAnalyzers);
            elem = this.luceneConfig.getChild("fieldBoosting");
            this.fieldBoost = new HashMap<String, Float>();
            if (elem != null) {
                for (Object o : elem.getChildren()) {
                    if (!(o instanceof Element)) continue;
                    Element e = (Element)o;
                    String name2 = e.getAttributeValue("name");
                    String boost = e.getAttributeValue("boost");
                    if (name2 == null || boost == null) {
                        Log.warning((String)"geonetwork.search", (Object)"Field must have a name and a boost attribute, check Lucene configuration file.");
                        continue;
                    }
                    try {
                        this.fieldBoost.put(name2, Float.valueOf(Float.parseFloat(boost)));
                    }
                    catch (Exception exc) {
                        Log.error((String)"geonetwork.search", (Object)("LuceneConfig error: " + exc.getMessage()), (Throwable)exc);
                    }
                }
            }
            if ((elem = this.luceneConfig.getChild("boostDocument")) != null) {
                this.documentBoostClass = elem.getAttribute("name").getValue();
                this.loadClassParameters(3, "", this.documentBoostClass, elem.getChildren("Param"));
            }
            if ((elem = (searchConfig = this.luceneConfig.getChild("search")).getChild("boostQuery")) != null) {
                this.boostQueryClass = elem.getAttribute("name").getValue();
                this.loadClassParameters(2, "", this.boostQueryClass, elem.getChildren("Param"));
            }
            if ((elem = searchConfig.getChild("dumpFields")) != null) {
                for (Object o : elem.getChildren()) {
                    if (!(o instanceof Element)) continue;
                    Element e = (Element)o;
                    String name3 = e.getAttributeValue("name");
                    String tagName = e.getAttributeValue("tagName");
                    String multilingualSortField = e.getAttributeValue("multilingualSortField");
                    if (name3 == null || tagName == null) {
                        Log.warning((String)"geonetwork.search", (Object)"Field must have a name and an tagName attribute, check Lucene configuration file.");
                        continue;
                    }
                    this.dumpFields.put(name3, tagName);
                    if (!Boolean.parseBoolean(multilingualSortField)) continue;
                    this.multilingualSortFields.add(name3);
                }
            }
            if ((elem = searchConfig.getChild("trackDocScores")) != null && elem.getText().equals("true")) {
                this.setTrackDocScores(true);
            }
            if ((elem = searchConfig.getChild("trackMaxScore")) != null && elem.getText().equals("true")) {
                this.setTrackMaxScore(true);
            }
            if ((elem = searchConfig.getChild("docsScoredInOrder")) != null && elem.getText().equals("true")) {
                this.setDocsScoredInOrder(true);
            }
        }
        catch (FileNotFoundException e) {
            Log.error((String)"geonetwork.search", (Object)("Can't find Lucene configuration file. Error is: " + e.getMessage()));
        }
        catch (IOException e) {
            Log.error((String)"geonetwork.search", (Object)("Failed to load Lucene configuration file. Error is: " + e.getMessage()));
        }
        catch (JDOMException e) {
            Log.error((String)"geonetwork.search", (Object)("Failed to load Lucene configuration XML file. Error is: " + e.getMessage()));
        }
    }

    private void loadAnalyzerConfig(String configRootName, Map<String, String> fieldAnalyzer) {
        Element elem = this.luceneConfig.getChild(configRootName);
        for (Object o : elem.getChildren()) {
            if (!(o instanceof Element)) continue;
            Element e = (Element)o;
            String name = e.getAttributeValue("name");
            String analyzer = e.getAttributeValue("analyzer");
            if (name == null || analyzer == null) {
                Log.warning((String)"geonetwork.search", (Object)"Field must have a name and an analyzer attribute, check Lucene configuration file.");
                continue;
            }
            fieldAnalyzer.put(name, analyzer);
            this.loadClassParameters(1, name, analyzer, e.getChildren("Param"));
        }
    }

    private void loadClassParameters(int type, String field, String clazz, List<?> children) {
        if (children == null) {
            return;
        }
        ConfigurableApplicationContext _appContext = ApplicationContextHolder.get();
        GeonetworkDataDirectory geonetworkDataDirectory = (GeonetworkDataDirectory)_appContext.getBean(GeonetworkDataDirectory.class);
        if (Log.isDebugEnabled((String)"geonetwork.search")) {
            Log.debug((String)"geonetwork.search", (Object)("  Field: " + field + ", loading class " + clazz + " ..."));
        }
        Object[] params = new Object[children.size()];
        Class[] paramsClass = new Class[children.size()];
        int i = 0;
        for (Object o : children) {
            if (!(o instanceof Element)) continue;
            Element c = (Element)o;
            String name = c.getAttributeValue("name");
            String paramType = c.getAttributeValue("type");
            String value = c.getAttributeValue("value");
            if (Log.isDebugEnabled((String)"geonetwork.search")) {
                Log.debug((String)"geonetwork.search", (Object)("    * Parameter: " + name + ", type: " + paramType + ", value: " + value));
            }
            try {
                paramsClass[i] = "double".equals(paramType) ? Double.TYPE : ("int".equals(paramType) ? Integer.TYPE : Class.forName(paramType));
                if ("org.apache.lucene.util.Version".equals(paramType)) {
                    params[i] = this.LUCENE_VERSION;
                } else if ("java.io.File".equals(paramType) && value != null) {
                    Path f = IO.toPath((String)value, (String[])new String[0]);
                    if (!Files.exists(f, new LinkOption[0])) {
                        f = geonetworkDataDirectory.resolveWebResource(value);
                    }
                    params[i] = f;
                } else if ("double".equals(paramType) && value != null) {
                    params[i] = Double.parseDouble(value);
                } else if ("int".equals(paramType) && value != null) {
                    params[i] = Integer.parseInt(value);
                } else if (value != null) {
                    params[i] = value;
                }
                ++i;
            }
            catch (ClassNotFoundException e) {
                Log.warning((String)"geonetwork.search", (Object)("  Class not found for parameter: " + name + ", type: " + paramType), (Throwable)e);
                return;
            }
        }
        String id = field + clazz;
        switch (type) {
            case 1: {
                this.analyzerParametersClass.put(id, paramsClass);
                this.analyzerParameters.put(id, params);
                break;
            }
            case 2: {
                this.boostQueryParametersClass.put(id, paramsClass);
                this.boostQueryParameters.put(id, params);
                break;
            }
            case 3: {
                this.documentBoostParametersClass.put(id, paramsClass);
                this.documentBoostParameters.put(id, params);
                break;
            }
        }
    }

    public Set<String> getMultilingualSortFields() {
        return this.multilingualSortFields;
    }

    public Set<String> getTokenizedField() {
        return this.tokenizedFields;
    }

    public boolean applySimilarity(String fieldName) {
        if (this.fuzzyMatching != null) {
            return this.fuzzyMatching.contains(fieldName);
        }
        return true;
    }

    public boolean isTokenizedField(String name) {
        return this.tokenizedFields.contains(name);
    }

    public Map<String, LuceneConfigNumericField> getNumericFields() {
        return this.numericFields;
    }

    public Map<String, String> getDumpFields() {
        return this.dumpFields;
    }

    public LuceneConfigNumericField getNumericField(String fieldName) {
        return this.numericFields.get(fieldName);
    }

    public boolean isNumericField(String fieldName) {
        return this.numericFields.containsKey(fieldName);
    }

    public Object[] getAnalyzerParameter(String analyzer) {
        return this.analyzerParameters.get(analyzer);
    }

    public Class<?>[] getAnalyzerParameterClass(String analyzer) {
        return this.analyzerParametersClass.get(analyzer);
    }

    public Object[] getBoostQueryParameter() {
        return this.boostQueryParameters.get(this.boostQueryClass);
    }

    public Class<?>[] getBoostQueryParameterClass() {
        return this.boostQueryParametersClass.get(this.boostQueryClass);
    }

    public String getBoostQueryClass() {
        return this.boostQueryClass;
    }

    public Object[] getDocumentBoostParameter() {
        return this.documentBoostParameters.get(this.documentBoostClass);
    }

    public Class<?>[] getDocumentBoostParameterClass() {
        return this.documentBoostParametersClass.get(this.documentBoostClass);
    }

    public String getDocumentBoostClass() {
        return this.documentBoostClass;
    }

    public String getDefaultAnalyzerClass() {
        return this.defaultAnalyzerClass;
    }

    public Map<String, String> getFieldSpecificAnalyzers() {
        return this.fieldSpecificAnalyzers;
    }

    public Map<String, String> getFieldSpecificSearchAnalyzers() {
        return this.fieldSpecificSearchAnalyzers;
    }

    public Map<String, Float> getFieldBoost() {
        return this.fieldBoost;
    }

    public Float getFieldBoost(String field) {
        return this.fieldBoost.get(field);
    }

    public int getMergeFactor() {
        return this.MergeFactor;
    }

    public double getRAMBufferSize() {
        return this.RAMBufferSizeMB;
    }

    public Version getLuceneVersion() {
        return this.LUCENE_VERSION;
    }

    public List<Dimension> getDimensionsUsing(String indexKey) {
        return this.facets.getDimensionsUsing(indexKey);
    }

    public SummaryTypes getSummaryTypes() {
        return this.summaryTypes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Lucene configuration:\n");
        sb.append(" * Version: " + this.getLuceneVersion().toString() + "\n");
        sb.append(" * RAMBufferSize: " + this.getRAMBufferSize() + "\n");
        sb.append(" * MergeFactor: " + this.getMergeFactor() + "\n");
        sb.append(" * Default analyzer: " + this.getDefaultAnalyzerClass() + "\n");
        sb.append(" * Field analyzers: " + this.getFieldSpecificAnalyzers().toString() + "\n");
        sb.append(" * Field search analyzers: " + this.getFieldSpecificSearchAnalyzers().toString() + "\n");
        sb.append(" * Field boost factor: " + this.getFieldBoost().toString() + "\n");
        sb.append(" * Boost document class: " + this.getDocumentBoostClass() + "\n");
        sb.append(" * Tokenized fields: " + this.getTokenizedField().toString() + "\n");
        sb.append(" * Numeric fields: " + this.getNumericFields().keySet().toString() + "\n");
        sb.append(" * Dump fields: " + this.getDumpFields().toString() + "\n");
        sb.append(" * Search boost query: " + this.getBoostQueryClass() + "\n");
        sb.append(" * Score: \n");
        sb.append("  * trackDocScores: " + this.isTrackDocScores() + " \n");
        sb.append("  * trackMaxScore: " + this.isTrackMaxScore() + " \n");
        sb.append("  * docsScoredInOrder: " + this.isDocsScoredInOrder() + " \n");
        sb.append(this.facets.toString());
        sb.append(this.summaryTypes.toString());
        return sb.toString();
    }

    public boolean isTrackDocScores() {
        return this.trackDocScores;
    }

    private void setTrackDocScores(boolean trackDocScore) {
        this.trackDocScores = trackDocScore;
    }

    public boolean isTrackMaxScore() {
        return this.trackMaxScore;
    }

    private void setTrackMaxScore(boolean trackMaxScore) {
        this.trackMaxScore = trackMaxScore;
    }

    public boolean isDocsScoredInOrder() {
        return this.docsScoredInOrder;
    }

    private void setDocsScoredInOrder(boolean docsScoredInOrder) {
        this.docsScoredInOrder = docsScoredInOrder;
    }

    public FacetsConfig getTaxonomyConfiguration() {
        return this.facets.getAsLuceneFacetsConfig();
    }

    public long commitInterval() {
        return this.commitInterval;
    }

    public boolean useNRTManagerReopenThread() {
        return this.useNRTManagerReopenThread;
    }

    public double getNRTManagerReopenThreadMaxStaleSec() {
        return this.nrtManagerReopenThreadMaxStaleSec;
    }

    public double getNRTManagerReopenThreadMinStaleSec() {
        return this.nrtManagerReopenThreadMinStaleSec;
    }

    public class LuceneConfigNumericField {
        private String name;
        private String DEFAULT_TYPE = "int";
        private String type;
        private int precisionStep = 16;

        public LuceneConfigNumericField(String name, String type, String precisionStep) {
            this.name = name;
            this.type = type != null ? type : this.DEFAULT_TYPE;
            try {
                int p;
                this.precisionStep = p = Integer.parseInt(precisionStep);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public int getPrecisionStep() {
            return this.precisionStep;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object a) {
            if (this == a) {
                return true;
            }
            if (!(a instanceof LuceneConfigNumericField)) {
                return false;
            }
            LuceneConfigNumericField f = (LuceneConfigNumericField)a;
            return f.getName().equals(this.name);
        }

        private LuceneConfig getOuterType() {
            return LuceneConfig.this;
        }
    }
}

