/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Selection;
import org.fao.geonet.domain.User;
import org.fao.geonet.kernel.metadata.DefaultStatusActions;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.SelectionRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.UserSavedSelectionRepository;
import org.fao.geonet.util.MailUtil;
import org.fao.geonet.utils.Log;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class WatchListNotifier
extends QuartzJobBean {
    private String lastNotificationDate;
    private String nextLastNotificationDate;
    private String subject;
    private String message;
    private String recordMessage;
    private String updatedRecordPermalink;
    private String language = "eng";
    private SettingManager settingManager;
    private ApplicationContext appContext;
    private UserSavedSelectionRepository userSavedSelectionRepository;
    private UserRepository userRepository;
    @Value(value="${usersavedselection.watchlist.searchurl}")
    private String permalinkApp = "catalog.search#/search?_uuid={{filter}}";
    @Value(value="${usersavedselection.watchlist.recordurl}")
    private String permalinkRecordApp = "api/records/{{index:_uuid}}";

    public String getPermalinkApp() {
        return this.permalinkApp;
    }

    public void setPermalinkApp(String permalinkApp) {
        this.permalinkApp = permalinkApp;
    }

    public String getPermalinkRecordApp() {
        return this.permalinkRecordApp;
    }

    public void setPermalinkRecordApp(String permalinkRecordApp) {
        this.permalinkRecordApp = permalinkRecordApp;
    }

    protected void executeInternal(JobExecutionContext jobContext) throws JobExecutionException {
        this.appContext = ApplicationContextHolder.get();
        this.settingManager = (SettingManager)this.appContext.getBean(SettingManager.class);
        ResourceBundle messages = ResourceBundle.getBundle("org.fao.geonet.api.Messages", new Locale(this.language));
        try {
            this.subject = messages.getString("user_watchlist_subject");
            this.message = messages.getString("user_watchlist_message");
            this.recordMessage = messages.getString("user_watchlist_message_record").replace("{{link}}", this.settingManager.getNodeURL() + this.permalinkRecordApp);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updatedRecordPermalink = this.settingManager.getSiteURL(this.language);
        this.lastNotificationDate = this.settingManager.getValue("system/userFeedback/lastNotificationDate");
        this.nextLastNotificationDate = new ISODate().toString();
        if (Log.isDebugEnabled((String)"geonetwork.userwatchlist")) {
            Log.debug((String)"geonetwork.userwatchlist", (Object)String.format("Last notification date for saved selection was %s.", this.lastNotificationDate));
        }
        this.userSavedSelectionRepository = (UserSavedSelectionRepository)this.appContext.getBean(UserSavedSelectionRepository.class);
        this.userRepository = (UserRepository)this.appContext.getBean(UserRepository.class);
        SelectionRepository selectionRepository = (SelectionRepository)this.appContext.getBean(SelectionRepository.class);
        List selectionList = selectionRepository.findAll();
        for (Selection selection : selectionList) {
            if (!selection.isWatchable()) continue;
            Integer selectionId = selection.getId();
            List allUsers = this.userSavedSelectionRepository.findAllUsers(selectionId);
            if (StringUtils.isNotBlank((String)this.lastNotificationDate)) {
                if (Log.isDebugEnabled((String)"geonetwork.userwatchlist")) {
                    Log.debug((String)"geonetwork.userwatchlist", (Object)String.format("  Notifying %d users about changes since %s in list %d", allUsers.size(), this.lastNotificationDate, selectionId));
                }
                for (Integer userId : allUsers) {
                    this.notify(selectionId, userId);
                }
                continue;
            }
            if (!Log.isDebugEnabled((String)"geonetwork.userwatchlist")) continue;
            Log.debug((String)"geonetwork.userwatchlist", (Object)String.format("  Notification of %d users saved selection %d will start on next run. Last notification date was null", allUsers.size(), selectionId));
        }
        this.settingManager.setValue("system/userFeedback/lastNotificationDate", this.nextLastNotificationDate);
        if (Log.isDebugEnabled((String)"geonetwork.userwatchlist")) {
            Log.debug((String)"geonetwork.userwatchlist", (Object)String.format("Next notification date for saved selection is now %s.", this.nextLastNotificationDate));
        }
    }

    private void notify(Integer selectionId, Integer userId) {
        List updatedRecords = this.userSavedSelectionRepository.findMetadataUpdatedAfter(selectionId, userId, this.lastNotificationDate, this.nextLastNotificationDate);
        if (Log.isDebugEnabled((String)"geonetwork.userwatchlist")) {
            Log.debug((String)"geonetwork.userwatchlist", (Object)String.format("    Notifying user %d about %d changes since %s in list %d", userId, updatedRecords.size(), this.lastNotificationDate, selectionId));
        }
        if (updatedRecords.size() > 0) {
            User user = (User)this.userRepository.findOne((Serializable)userId);
            if (StringUtils.isNotEmpty((String)user.getEmail())) {
                StringBuffer listOfUpdateMessage = new StringBuffer();
                for (String record : updatedRecords) {
                    try {
                        listOfUpdateMessage.append(DefaultStatusActions.compileMessageWithIndexFields(this.recordMessage, record, this.language));
                    }
                    catch (Exception e) {
                        Log.error((String)"geonetwork.userwatchlist", (Object)e.getMessage(), (Throwable)e);
                    }
                }
                String url = this.updatedRecordPermalink + this.permalinkApp.replace("{{filter}}", String.join((CharSequence)" or ", updatedRecords));
                String mailSubject = String.format(this.subject, this.settingManager.getSiteName(), updatedRecords.size(), this.lastNotificationDate);
                String htmlMessage = String.format(this.message, listOfUpdateMessage.toString(), this.lastNotificationDate, url, url);
                if (Log.isDebugEnabled((String)"geonetwork.userwatchlist")) {
                    Log.debug((String)"geonetwork.userwatchlist", (Object)String.format("    Sending message with subject %s to user %d", mailSubject, userId));
                }
                MailUtil.sendHtmlMail(Arrays.asList(user.getEmail()), mailSubject, htmlMessage, this.settingManager);
            }
        } else if (Log.isDebugEnabled((String)"geonetwork.userwatchlist")) {
            Log.debug((String)"geonetwork.userwatchlist", (Object)String.format("    No changes for user %d since %s in his/her list %d", userId, this.lastNotificationDate, selectionId));
        }
    }
}

