/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.domain.MetadataValidation;
import org.fao.geonet.domain.Schematron;
import org.fao.geonet.domain.SchematronCriteria;
import org.fao.geonet.domain.SchematronCriteriaGroup;
import org.fao.geonet.domain.SchematronRequirement;
import org.fao.geonet.kernel.AbstractSchematronValidator;
import org.fao.geonet.kernel.ApplicableSchematron;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.repository.SchematronCriteriaGroupRepository;
import org.fao.geonet.repository.SchematronRepository;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SchematronValidatorExternalMd
extends AbstractSchematronValidator {
    public Element applyCustomSchematronRules(String schema, Element md, String lang, List<MetadataValidation> validations, Integer groupOwnerId) {
        SchemaManager schemaManager = (SchemaManager)ApplicationContextHolder.get().getBean(SchemaManager.class);
        MetadataSchema metadataSchema = schemaManager.getSchema(schema);
        Path schemaDir = schemaManager.getSchemaDir(schema);
        Element schemaTronXmlOut = new Element("schematronerrors", Edit.NAMESPACE);
        try {
            List<ApplicableSchematron> applicableSchematron = this.getApplicableSchematronList(md, metadataSchema, groupOwnerId);
            for (ApplicableSchematron applicable : applicableSchematron) {
                this.runSchematron(lang, schemaDir, validations, schemaTronXmlOut, -1, md, applicable);
            }
        }
        catch (Throwable e) {
            Element errorReport = new Element("schematronVerificationError", Edit.NAMESPACE);
            errorReport.addContent("Schematron error ocurred, rules could not be verified: " + e.getMessage());
            schemaTronXmlOut.addContent((Content)errorReport);
        }
        return schemaTronXmlOut;
    }

    public List<ApplicableSchematron> getApplicableSchematronList(Element md, MetadataSchema metadataSchema, Integer groupOwnerId) {
        ArrayList applicableSchematron = Lists.newArrayList();
        SchematronRepository schematronRepository = (SchematronRepository)ApplicationContextHolder.get().getBean(SchematronRepository.class);
        List schematronList = schematronRepository.findAllBySchemaName(metadataSchema.getName());
        Collections.sort(schematronList, Schematron.DISPLAY_PRIORITY_COMPARATOR);
        for (Schematron schematron : schematronList) {
            ApplicableSchematron applicable = this.getApplicableSchematron(md, metadataSchema, schematron, groupOwnerId);
            if (applicable.requirement == SchematronRequirement.DISABLED) continue;
            if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
                Log.debug((String)"geonetwork.datamanager", (Object)(" - rule:" + schematron.getRuleName()));
            }
            applicableSchematron.add(applicable);
        }
        return applicableSchematron;
    }

    public ApplicableSchematron getApplicableSchematron(Element md, MetadataSchema metadataSchema, Schematron schematron, Integer groupOwnerId) {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        SchematronCriteriaGroupRepository criteriaGroupRepository = (SchematronCriteriaGroupRepository)applicationContext.getBean(SchematronCriteriaGroupRepository.class);
        List criteriaGroups = criteriaGroupRepository.findAllById_SchematronId(schematron.getId());
        SchematronRequirement requirement = SchematronRequirement.DISABLED;
        for (SchematronCriteriaGroup criteriaGroup : criteriaGroups) {
            List criteriaList = criteriaGroup.getCriteria();
            boolean apply = false;
            for (SchematronCriteria criteria : criteriaList) {
                boolean tmpApply = criteria.accepts((ApplicationContext)applicationContext, md, metadataSchema.getSchemaNS(), groupOwnerId);
                if (!tmpApply) {
                    apply = false;
                    break;
                }
                apply = true;
            }
            if (apply) {
                if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
                    Log.debug((String)"geonetwork.datamanager", (Object)(" - Schematron group is accepted:" + criteriaGroup.getId().getName() + " for schematron: " + schematron.getRuleName()));
                }
                requirement = requirement.highestRequirement(criteriaGroup.getRequirement());
                continue;
            }
            requirement = requirement.highestRequirement(SchematronRequirement.DISABLED);
        }
        return new ApplicableSchematron(requirement, schematron);
    }
}

