/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet;

import com.google.common.annotations.VisibleForTesting;
import org.fao.geonet.util.ThreadPool;
import org.springframework.context.ApplicationContext;

public class GeonetContext {
    private final ApplicationContext _springAppContext;
    private final ThreadPool _threadPool;

    @VisibleForTesting
    public GeonetContext(ApplicationContext springAppContext, boolean readOnly) {
        this._springAppContext = springAppContext;
        this._threadPool = (ThreadPool)springAppContext.getBean(ThreadPool.class);
    }

    public ApplicationContext getApplicationContext() {
        return this._springAppContext;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public <T> T getBean(Class<T> beanClass) {
        return (T)this._springAppContext.getBean(beanClass);
    }

    public boolean isReadOnly() {
        return false;
    }

    public void setReadOnly(boolean readOnly) {
    }
}

