/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server;

import java.util.Hashtable;
import java.util.List;
import org.jdom.Element;

public class ServiceConfig {
    private Hashtable<String, String> values = new Hashtable();
    private Hashtable<String, Element> elements = new Hashtable();

    public ServiceConfig() {
    }

    public ServiceConfig(List<Element> params) {
        for (int i = 0; i < params.size(); ++i) {
            Element param = params.get(i);
            String name = param.getAttributeValue("name");
            String value = param.getAttributeValue("value");
            if (name == null) {
                throw new IllegalArgumentException("Missing 'name' attrib in parameter");
            }
            if (value != null) {
                this.values.put(name, value);
            }
            this.elements.put(name, param);
        }
    }

    public String getValue(String name) {
        return this.values.get(name);
    }

    public void setValue(String name, String value) {
        this.values.put(name, value);
    }

    public String getValue(String name, String def) {
        String value = this.getValue(name);
        if (value == null) {
            value = def;
        }
        return value;
    }

    public String getMandatoryValue(String name) {
        String value = this.getValue(name);
        if (value == null) {
            throw new IllegalArgumentException("Missing '" + name + "' parameter");
        }
        return value;
    }

    public List<Element> getChildren(String paramName) {
        return this.getChildren(paramName, null);
    }

    public List<Element> getChildren(String paramName, String elemName) {
        Element elem = this.elements.get(paramName);
        if (elem == null) {
            return null;
        }
        if (elemName == null) {
            return elem.getChildren();
        }
        return elem.getChildren(elemName);
    }
}

