/*
 * Decompiled with CFR 0.152.
 */
package jeeves.config.springutil;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

public class JeevesAccessDeniedHandler
implements AccessDeniedHandler {
    private String _errorPage;
    private Escaper _escaper = UrlEscapers.urlPathSegmentEscaper();
    private AntPathRequestMatcher matcher;

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        if (!response.isCommitted()) {
            if (this.matcher != null && this.matcher.matches(request)) {
                response.sendError(403, accessDeniedException.getMessage());
            }
            if (this._errorPage != null) {
                request.setAttribute("SPRING_SECURITY_403_EXCEPTION", (Object)accessDeniedException);
                response.setStatus(403);
                String referer = this._escaper.escape(request.getRequestURI());
                RequestDispatcher dispatcher = request.getRequestDispatcher(this._errorPage + "?referer=" + referer);
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendError(403, accessDeniedException.getMessage());
            }
        }
    }

    public void setErrorPage(String errorPage) {
        this._errorPage = errorPage;
    }

    public void setOnlyStatusResponsePages(String pattern) {
        if (StringUtils.isNotBlank((String)pattern)) {
            this.matcher = new AntPathRequestMatcher(pattern);
        }
    }
}

