/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.oaipmh;

import org.fao.geonet.domain.ISODate;
import org.fao.oaipmh.responses.Header;

public class RecordInfo {
    public String id;
    public ISODate changeDate;
    public String prefix;

    public RecordInfo(Header h, String mdPrefix) {
        this.id = h.getIdentifier();
        this.changeDate = h.getDateStamp();
        this.prefix = mdPrefix;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean isMoreRecentThan(String localChangeDate) {
        ISODate localDate = new ISODate(localChangeDate);
        return this.changeDate.timeDifferenceInSeconds(localDate) > 0L;
    }

    public boolean equals(Object o) {
        if (o instanceof RecordInfo) {
            RecordInfo ri = (RecordInfo)o;
            return this.id.equals(ri.id);
        }
        return false;
    }
}

