/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.files;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.files.BasicShpFileWriter;
import org.geotools.data.shapefile.files.FileChannelDecorator;
import org.geotools.data.shapefile.files.FileReader;
import org.geotools.data.shapefile.files.FileWriter;
import org.geotools.data.shapefile.files.MemoryMapCache;
import org.geotools.data.shapefile.files.ReadableByteChannelDecorator;
import org.geotools.data.shapefile.files.Result;
import org.geotools.data.shapefile.files.ShpFileType;
import org.geotools.data.shapefile.files.ShpFilesLocker;
import org.geotools.data.shapefile.files.StorageFile;
import org.geotools.data.shapefile.files.WritableByteChannelDecorator;
import org.geotools.util.logging.Logging;

public class ShpFiles {
    static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.shapefile");
    private final Map<ShpFileType, URL> urls = new ConcurrentHashMap<ShpFileType, URL>();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Map<Thread, Collection<ShpFilesLocker>> lockers = new ConcurrentHashMap<Thread, Collection<ShpFilesLocker>>();
    private final MemoryMapCache mapCache = new MemoryMapCache();
    private boolean memoryMapCacheEnabled;

    public ShpFiles(String fileName) throws MalformedURLException {
        try {
            URL url = new URL(fileName);
            this.init(url);
        }
        catch (MalformedURLException e) {
            this.init(new File(fileName).toURI().toURL());
        }
    }

    public ShpFiles(File file) throws MalformedURLException {
        this.init(file.toURI().toURL());
    }

    public ShpFiles(URL url) throws IllegalArgumentException {
        this.init(url);
    }

    private void init(URL url) {
        String base = this.baseName(url);
        if (base == null) {
            throw new IllegalArgumentException(url.getPath() + " is not one of the files types that is known to be associated with a shapefile");
        }
        String urlString = url.toExternalForm();
        char lastChar = urlString.charAt(urlString.length() - 1);
        boolean upperCase = Character.isUpperCase(lastChar);
        for (ShpFileType type : ShpFileType.values()) {
            URL newURL;
            String extensionWithPeriod = type.extensionWithPeriod;
            extensionWithPeriod = upperCase ? extensionWithPeriod.toUpperCase() : extensionWithPeriod.toLowerCase();
            String string = base + extensionWithPeriod;
            try {
                newURL = new URL(url, string);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            this.urls.put(type, newURL);
        }
        if (this.isLocal()) {
            Set<Map.Entry<ShpFileType, URL>> entries = this.urls.entrySet();
            HashMap<ShpFileType, URL> toUpdate = new HashMap<ShpFileType, URL>();
            for (Map.Entry<ShpFileType, URL> entry : entries) {
                if (this.exists(entry.getKey()) || (url = this.findExistingFile(entry.getKey(), entry.getValue())) == null) continue;
                toUpdate.put(entry.getKey(), url);
            }
            this.urls.putAll(toUpdate);
        }
    }

    private URL findExistingFile(ShpFileType shpFileType, URL value) {
        final File file = DataUtilities.urlToFile(value);
        File directory = file.getParentFile();
        if (directory == null || !directory.exists()) {
            return null;
        }
        File[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return file.getName().equalsIgnoreCase(name);
            }
        });
        if (files.length > 0) {
            try {
                return files[0].toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.SEVERE, "", e);
            }
        }
        return null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public void dispose() {
        if (this.numberOfLocks() != 0) {
            this.logCurrentLockers(Level.SEVERE);
            this.lockers.clear();
        }
        this.mapCache.clean();
    }

    public void logCurrentLockers(Level logLevel) {
        for (Collection<ShpFilesLocker> lockerList : this.lockers.values()) {
            for (ShpFilesLocker locker : lockerList) {
                StringBuilder sb = new StringBuilder("The following locker still has a lock: ");
                sb.append(locker);
                LOGGER.log(logLevel, sb.toString(), locker.getTrace());
            }
        }
    }

    private String baseName(Object obj) {
        for (ShpFileType type : ShpFileType.values()) {
            Serializable file;
            String base = null;
            if (obj instanceof File) {
                file = (File)obj;
                base = type.toBase((File)file);
            }
            if (obj instanceof URL) {
                file = (URL)obj;
                base = type.toBase((URL)file);
            }
            if (base == null) continue;
            return base;
        }
        return null;
    }

    public Map<ShpFileType, String> getFileNames() {
        HashMap<ShpFileType, String> result = new HashMap<ShpFileType, String>();
        Set<Map.Entry<ShpFileType, URL>> entries = this.urls.entrySet();
        for (Map.Entry<ShpFileType, URL> entry : entries) {
            result.put(entry.getKey(), entry.getValue().toExternalForm());
        }
        return result;
    }

    public String get(ShpFileType type) {
        return this.urls.get((Object)type).toExternalForm();
    }

    public int numberOfLocks() {
        int count = 0;
        for (Collection<ShpFilesLocker> lockerList : this.lockers.values()) {
            count += lockerList.size();
        }
        return count;
    }

    public File acquireReadFile(ShpFileType type, FileReader requestor) {
        if (!this.isLocal()) {
            throw new IllegalStateException("This method only applies if the files are local");
        }
        URL url = this.acquireRead(type, requestor);
        return DataUtilities.urlToFile(url);
    }

    public URL acquireRead(ShpFileType type, FileReader requestor) {
        URL url = this.urls.get((Object)type);
        if (url == null) {
            return null;
        }
        this.readWriteLock.readLock().lock();
        Collection<ShpFilesLocker> threadLockers = this.getCurrentThreadLockers();
        threadLockers.add(new ShpFilesLocker(url, requestor));
        return url;
    }

    public Result<URL, State> tryAcquireRead(ShpFileType type, FileReader requestor) {
        URL url = this.urls.get((Object)type);
        if (url == null) {
            return new Result<Object, State>(null, State.NOT_EXIST);
        }
        boolean locked = this.readWriteLock.readLock().tryLock();
        if (!locked) {
            return new Result<Object, State>(null, State.LOCKED);
        }
        this.getCurrentThreadLockers().add(new ShpFilesLocker(url, requestor));
        return new Result<URL, State>(url, State.GOOD);
    }

    public void unlockRead(File file, FileReader requestor) {
        Collection<URL> allURLS = this.urls.values();
        for (URL url : allURLS) {
            if (!DataUtilities.urlToFile(url).equals(file)) continue;
            this.unlockRead(url, requestor);
        }
    }

    public void unlockRead(URL url, FileReader requestor) {
        if (url == null) {
            throw new NullPointerException("url cannot be null");
        }
        if (requestor == null) {
            throw new NullPointerException("requestor cannot be null");
        }
        Collection<ShpFilesLocker> threadLockers = this.getCurrentThreadLockers();
        boolean removed = threadLockers.remove(new ShpFilesLocker(url, requestor));
        if (!removed) {
            throw new IllegalArgumentException("Expected requestor " + requestor + " to have locked the url but it does not hold the lock for the URL");
        }
        if (threadLockers.size() == 0) {
            this.lockers.remove(Thread.currentThread());
        }
        this.readWriteLock.readLock().unlock();
    }

    public File acquireWriteFile(ShpFileType type, FileWriter requestor) {
        if (!this.isLocal()) {
            throw new IllegalStateException("This method only applies if the files are local");
        }
        URL url = this.acquireWrite(type, requestor);
        return DataUtilities.urlToFile(url);
    }

    public URL acquireWrite(ShpFileType type, FileWriter requestor) {
        URL url = this.urls.get((Object)type);
        if (url == null) {
            return null;
        }
        Collection<ShpFilesLocker> threadLockers = this.getCurrentThreadLockers();
        this.relinquishReadLocks(threadLockers);
        this.readWriteLock.writeLock().lock();
        threadLockers.add(new ShpFilesLocker(url, requestor));
        this.mapCache.cleanFileCache(url);
        return url;
    }

    public Result<URL, State> tryAcquireWrite(ShpFileType type, FileWriter requestor) {
        URL url = this.urls.get((Object)type);
        if (url == null) {
            return new Result<Object, State>(null, State.NOT_EXIST);
        }
        Collection<ShpFilesLocker> threadLockers = this.getCurrentThreadLockers();
        boolean locked = this.readWriteLock.writeLock().tryLock();
        if (!locked && threadLockers.size() > 1) {
            this.relinquishReadLocks(threadLockers);
            locked = this.readWriteLock.writeLock().tryLock();
            if (!locked) {
                this.regainReadLocks(threadLockers);
                return new Result<Object, State>(null, State.LOCKED);
            }
        }
        threadLockers.add(new ShpFilesLocker(url, requestor));
        return new Result<URL, State>(url, State.GOOD);
    }

    public void unlockWrite(File file, FileWriter requestor) {
        Collection<URL> allURLS = this.urls.values();
        for (URL url : allURLS) {
            if (!DataUtilities.urlToFile(url).equals(file)) continue;
            this.unlockWrite(url, requestor);
        }
    }

    public void unlockWrite(URL url, FileWriter requestor) {
        if (url == null) {
            throw new NullPointerException("url cannot be null");
        }
        if (requestor == null) {
            throw new NullPointerException("requestor cannot be null");
        }
        Collection<ShpFilesLocker> threadLockers = this.getCurrentThreadLockers();
        boolean removed = threadLockers.remove(new ShpFilesLocker(url, requestor));
        if (!removed) {
            throw new IllegalArgumentException("Expected requestor " + requestor + " to have locked the url but it does not hold the lock for the URL");
        }
        if (threadLockers.size() == 0) {
            this.lockers.remove(Thread.currentThread());
        } else {
            this.regainReadLocks(threadLockers);
        }
        this.readWriteLock.writeLock().unlock();
    }

    private Collection<ShpFilesLocker> getCurrentThreadLockers() {
        Collection<ShpFilesLocker> threadLockers = this.lockers.get(Thread.currentThread());
        if (threadLockers == null) {
            threadLockers = new ArrayList<ShpFilesLocker>();
            this.lockers.put(Thread.currentThread(), threadLockers);
        }
        return threadLockers;
    }

    private void relinquishReadLocks(Collection<ShpFilesLocker> threadLockers) {
        for (ShpFilesLocker shpFilesLocker : threadLockers) {
            if (shpFilesLocker.reader == null || shpFilesLocker.upgraded) continue;
            this.readWriteLock.readLock().unlock();
            shpFilesLocker.upgraded = true;
        }
    }

    private void regainReadLocks(Collection<ShpFilesLocker> threadLockers) {
        for (ShpFilesLocker shpFilesLocker : threadLockers) {
            if (shpFilesLocker.reader == null || !shpFilesLocker.upgraded) continue;
            this.readWriteLock.readLock().lock();
            shpFilesLocker.upgraded = false;
        }
    }

    public boolean isLocal() {
        return this.urls.get((Object)ShpFileType.SHP).toExternalForm().toLowerCase().startsWith("file:");
    }

    public boolean isWritable() {
        if (!this.isLocal()) {
            return false;
        }
        return DataUtilities.urlToFile(this.urls.get((Object)ShpFileType.SHP)).canWrite() && DataUtilities.urlToFile(this.urls.get((Object)ShpFileType.DBF)).canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() {
        BasicShpFileWriter requestor = new BasicShpFileWriter("ShpFiles for deleting all files");
        URL writeLockURL = this.acquireWrite(ShpFileType.SHP, requestor);
        boolean retVal = true;
        try {
            if (this.isLocal()) {
                Collection<URL> values = this.urls.values();
                for (URL url : values) {
                    File f = DataUtilities.urlToFile(url);
                    if (f.delete()) continue;
                    retVal = false;
                }
            } else {
                retVal = false;
            }
        }
        finally {
            this.unlockWrite(writeLockURL, (FileWriter)requestor);
        }
        return retVal;
    }

    public InputStream getInputStream(ShpFileType type, final FileReader requestor) throws IOException {
        final URL url = this.acquireRead(type, requestor);
        try {
            FilterInputStream input = new FilterInputStream(url.openStream()){
                private volatile boolean closed;
                {
                    super(x0);
                    this.closed = false;
                }

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        if (!this.closed) {
                            this.closed = true;
                            ShpFiles.this.unlockRead(url, requestor);
                        }
                    }
                }
            };
            return input;
        }
        catch (Throwable e) {
            this.unlockRead(url, requestor);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
    }

    public OutputStream getOutputStream(ShpFileType type, final FileWriter requestor) throws IOException {
        final URL url = this.acquireWrite(type, requestor);
        try {
            OutputStream out;
            if (this.isLocal()) {
                File file = DataUtilities.urlToFile(url);
                out = new FileOutputStream(file);
            } else {
                URLConnection connection = url.openConnection();
                connection.setDoOutput(true);
                out = connection.getOutputStream();
            }
            FilterOutputStream output = new FilterOutputStream(out){
                private volatile boolean closed;
                {
                    super(x0);
                    this.closed = false;
                }

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        if (!this.closed) {
                            this.closed = true;
                            ShpFiles.this.unlockWrite(url, requestor);
                        }
                    }
                }
            };
            return output;
        }
        catch (Throwable e) {
            this.unlockWrite(url, requestor);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
    }

    public ReadableByteChannel getReadChannel(ShpFileType type, FileReader requestor) throws IOException {
        URL url = this.acquireRead(type, requestor);
        ReadableByteChannel channel = null;
        try {
            if (this.isLocal()) {
                File file = DataUtilities.urlToFile(url);
                RandomAccessFile raf = new RandomAccessFile(file, "r");
                channel = new FileChannelDecorator(raf.getChannel(), this, url, requestor);
            } else {
                InputStream in = url.openConnection().getInputStream();
                channel = new ReadableByteChannelDecorator(Channels.newChannel(in), this, url, requestor);
            }
        }
        catch (Throwable e) {
            this.unlockRead(url, requestor);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
        return channel;
    }

    public WritableByteChannel getWriteChannel(ShpFileType type, FileWriter requestor) throws IOException {
        URL url = this.acquireWrite(type, requestor);
        try {
            WritableByteChannel channel;
            if (this.isLocal()) {
                File file = DataUtilities.urlToFile(url);
                RandomAccessFile raf = new RandomAccessFile(file, "rw");
                channel = new FileChannelDecorator(raf.getChannel(), this, url, requestor);
                ((FileChannel)channel).lock();
            } else {
                OutputStream out = url.openConnection().getOutputStream();
                channel = new WritableByteChannelDecorator(Channels.newChannel(out), this, url, requestor);
            }
            return channel;
        }
        catch (Throwable e) {
            this.unlockWrite(url, requestor);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
    }

    public StorageFile getStorageFile(ShpFileType type) throws IOException {
        String baseName = this.getTypeName();
        if (baseName.length() < 3) {
            baseName = baseName + "___".substring(0, 3 - baseName.length());
        }
        File tmp = File.createTempFile(baseName, type.extensionWithPeriod);
        return new StorageFile(this, tmp, type);
    }

    public String getTypeName() {
        String path = ShpFileType.SHP.toBase(this.urls.get((Object)ShpFileType.SHP));
        int slash = Math.max(0, path.lastIndexOf(47) + 1);
        return path.substring(slash);
    }

    MappedByteBuffer map(FileChannel wrapped, URL url, FileChannel.MapMode mode, long position, long size) throws IOException {
        if (this.memoryMapCacheEnabled) {
            return this.mapCache.map(wrapped, url, mode, position, size);
        }
        return wrapped.map(mode, position, size);
    }

    public boolean isMemoryMapCacheEnabled() {
        return this.memoryMapCacheEnabled;
    }

    public void setMemoryMapCacheEnabled(boolean memoryMapCacheEnabled) {
        this.memoryMapCacheEnabled = memoryMapCacheEnabled;
        if (!memoryMapCacheEnabled) {
            this.mapCache.clean();
        }
    }

    public boolean exists(ShpFileType fileType) throws IllegalArgumentException {
        if (!this.isLocal()) {
            throw new IllegalArgumentException("This method only makes sense if the files are local");
        }
        URL url = this.urls.get((Object)fileType);
        if (url == null) {
            return false;
        }
        File file = DataUtilities.urlToFile(url);
        return file.exists();
    }

    public static enum State {
        NOT_EXIST,
        LOCKED,
        GOOD;

    }
}

