/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs;

import org.apache.jcs.access.GroupCacheAccess;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;

public class JCS
extends GroupCacheAccess {
    private static String configFilename = null;
    private static CompositeCacheManager cacheMgr;

    protected JCS(CompositeCache cacheControl) {
        super(cacheControl);
    }

    public static JCS getInstance(String region) throws CacheException {
        JCS.ensureCacheManager();
        return new JCS(cacheMgr.getCache(region));
    }

    public static JCS getInstance(String region, ICompositeCacheAttributes icca) throws CacheException {
        JCS.ensureCacheManager();
        return new JCS(cacheMgr.getCache(region, icca));
    }

    protected static synchronized void ensureCacheManager() {
        if (cacheMgr == null) {
            if (configFilename == null) {
                cacheMgr = CompositeCacheManager.getInstance();
            } else {
                cacheMgr = CompositeCacheManager.getUnconfiguredInstance();
                cacheMgr.configure(configFilename);
            }
        }
    }

    public static void setConfigFilename(String configFilename) {
        JCS.configFilename = configFilename;
    }
}

