/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.htmlunit;

import com.gargoylesoftware.htmlunit.CookieManager;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.util.Cookie;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.springframework.beans.Mergeable;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.SmartRequestBuilder;
import org.springframework.test.web.servlet.htmlunit.MockMvcWebConnection;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

final class HtmlUnitRequestBuilder
implements RequestBuilder,
Mergeable {
    private static final Pattern LOCALE_PATTERN = Pattern.compile("^\\s*(\\w{2})(?:-(\\w{2}))?(?:;q=(\\d+\\.\\d+))?$");
    private final Map<String, MockHttpSession> sessions;
    private final WebClient webClient;
    private final WebRequest webRequest;
    private String contextPath;
    private RequestBuilder parentBuilder;
    private SmartRequestBuilder parentPostProcessor;
    private RequestPostProcessor forwardPostProcessor;

    public HtmlUnitRequestBuilder(Map<String, MockHttpSession> sessions, WebClient webClient, WebRequest webRequest) {
        Assert.notNull(sessions, (String)"Sessions Map must not be null");
        Assert.notNull((Object)webClient, (String)"WebClient must not be null");
        Assert.notNull((Object)webRequest, (String)"WebRequest must not be null");
        this.sessions = sessions;
        this.webClient = webClient;
        this.webRequest = webRequest;
    }

    @Override
    public MockHttpServletRequest buildRequest(ServletContext servletContext) {
        String charset = this.getCharset();
        String httpMethod = this.webRequest.getHttpMethod().name();
        UriComponents uriComponents = this.uriComponents();
        HtmlUnitMockHttpServletRequest request = new HtmlUnitMockHttpServletRequest(servletContext, httpMethod, uriComponents.getPath());
        this.parent(request, this.parentBuilder);
        request.setServerName(uriComponents.getHost());
        this.authType(request);
        request.setCharacterEncoding(charset);
        this.content(request, charset);
        this.contextPath(request, uriComponents);
        this.contentType(request);
        this.cookies(request);
        this.headers(request);
        this.locales(request);
        this.servletPath(uriComponents, request);
        this.params(request, uriComponents);
        this.ports(uriComponents, request);
        request.setProtocol("HTTP/1.1");
        request.setQueryString(uriComponents.getQuery());
        request.setScheme(uriComponents.getScheme());
        this.pathInfo(uriComponents, request);
        return this.postProcess(request);
    }

    private MockHttpServletRequest postProcess(MockHttpServletRequest request) {
        if (this.parentPostProcessor != null) {
            request = this.parentPostProcessor.postProcessRequest(request);
        }
        if (this.forwardPostProcessor != null) {
            request = this.forwardPostProcessor.postProcessRequest(request);
        }
        return request;
    }

    private void parent(MockHttpServletRequest request, RequestBuilder parent) {
        String attrName;
        if (parent == null) {
            return;
        }
        MockHttpServletRequest parentRequest = parent.buildRequest(request.getServletContext());
        HttpSession parentSession = parentRequest.getSession(false);
        if (parentSession != null) {
            Enumeration attrNames = parentSession.getAttributeNames();
            while (attrNames.hasMoreElements()) {
                attrName = (String)attrNames.nextElement();
                Object attrValue = parentSession.getAttribute(attrName);
                request.getSession().setAttribute(attrName, attrValue);
            }
        }
        Enumeration<String> headerNames = parentRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            attrName = headerNames.nextElement();
            Enumeration<String> attrValues = parentRequest.getHeaders(attrName);
            while (attrValues.hasMoreElements()) {
                String string = (String)attrValues.nextElement();
                request.addHeader(attrName, string);
            }
        }
        Map<String, String[]> parentParams = parentRequest.getParameterMap();
        for (Map.Entry entry : parentParams.entrySet()) {
            String paramName = (String)entry.getKey();
            String[] paramValues = (String[])entry.getValue();
            request.addParameter(paramName, paramValues);
        }
        Object[] parentCookies = parentRequest.getCookies();
        if (!ObjectUtils.isEmpty((Object[])parentCookies)) {
            request.setCookies((javax.servlet.http.Cookie[])parentCookies);
        }
        Enumeration<String> enumeration = parentRequest.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String parentAttrName = enumeration.nextElement();
            request.setAttribute(parentAttrName, parentRequest.getAttribute(parentAttrName));
        }
    }

    public void setContextPath(String contextPath) {
        MockMvcWebConnection.validateContextPath(contextPath);
        this.contextPath = contextPath;
    }

    public void setForwardPostProcessor(RequestPostProcessor forwardPostProcessor) {
        this.forwardPostProcessor = forwardPostProcessor;
    }

    private void authType(MockHttpServletRequest request) {
        String authorization = this.header("Authorization");
        if (authorization != null) {
            String[] authzParts = authorization.split(": ");
            request.setAuthType(authzParts[0]);
        }
    }

    private void content(MockHttpServletRequest request, String charset) {
        String requestBody = this.webRequest.getRequestBody();
        if (requestBody == null) {
            return;
        }
        try {
            request.setContent(requestBody.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void contentType(MockHttpServletRequest request) {
        String contentType = this.header("Content-Type");
        request.setContentType(contentType == null ? "*/*".toString() : contentType);
    }

    private void contextPath(MockHttpServletRequest request, UriComponents uriComponents) {
        if (this.contextPath == null) {
            List pathSegments = uriComponents.getPathSegments();
            if (pathSegments.isEmpty()) {
                request.setContextPath("");
            } else {
                request.setContextPath("/" + (String)pathSegments.get(0));
            }
        } else {
            if (!uriComponents.getPath().startsWith(this.contextPath)) {
                throw new IllegalArgumentException(uriComponents.getPath() + " should start with contextPath " + this.contextPath);
            }
            request.setContextPath(this.contextPath);
        }
    }

    private void cookies(MockHttpServletRequest request) {
        ArrayList<javax.servlet.http.Cookie> cookies = new ArrayList<javax.servlet.http.Cookie>();
        String cookieHeaderValue = this.header("Cookie");
        if (cookieHeaderValue != null) {
            StringTokenizer tokens = new StringTokenizer(cookieHeaderValue, "=;");
            while (tokens.hasMoreTokens()) {
                String cookieName = tokens.nextToken().trim();
                if (!tokens.hasMoreTokens()) {
                    throw new IllegalArgumentException("Expected value for cookie name '" + (String)cookieName + "'. Full cookie was " + cookieHeaderValue);
                }
                String cookieValue = tokens.nextToken().trim();
                this.processCookie(request, cookies, new javax.servlet.http.Cookie(cookieName, cookieValue));
            }
        }
        Set managedCookies = this.webClient.getCookies(this.webRequest.getUrl());
        for (Cookie cookie : managedCookies) {
            this.processCookie(request, cookies, new javax.servlet.http.Cookie(cookie.getName(), cookie.getValue()));
        }
        javax.servlet.http.Cookie[] parentCookies = request.getCookies();
        if (parentCookies != null) {
            for (javax.servlet.http.Cookie cookie : parentCookies) {
                cookies.add(cookie);
            }
        }
        if (!ObjectUtils.isEmpty(cookies)) {
            request.setCookies(cookies.toArray(new javax.servlet.http.Cookie[cookies.size()]));
        }
    }

    private void processCookie(MockHttpServletRequest request, List<javax.servlet.http.Cookie> cookies, javax.servlet.http.Cookie cookie) {
        cookies.add(cookie);
        if ("JSESSIONID".equals(cookie.getName())) {
            request.setRequestedSessionId(cookie.getValue());
            request.setSession(this.httpSession(request, cookie.getValue()));
        }
    }

    private String getCharset() {
        String charset = this.webRequest.getCharset();
        if (charset == null) {
            return "ISO-8859-1";
        }
        return charset;
    }

    private String header(String headerName) {
        return (String)this.webRequest.getAdditionalHeaders().get(headerName);
    }

    private void headers(MockHttpServletRequest request) {
        for (Map.Entry header : this.webRequest.getAdditionalHeaders().entrySet()) {
            request.addHeader((String)header.getKey(), header.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MockHttpSession httpSession(MockHttpServletRequest request, String sessionid) {
        MockHttpSession session;
        Map<String, MockHttpSession> map = this.sessions;
        synchronized (map) {
            session = this.sessions.get(sessionid);
            if (session == null) {
                session = new HtmlUnitMockHttpSession(request, sessionid);
                session.setNew(true);
                Map<String, MockHttpSession> map2 = this.sessions;
                synchronized (map2) {
                    this.sessions.put(sessionid, session);
                }
                this.addSessionCookie(request, sessionid);
            } else {
                session.setNew(false);
            }
        }
        return session;
    }

    private void addSessionCookie(MockHttpServletRequest request, String sessionid) {
        this.getCookieManager().addCookie(this.createCookie(request, sessionid));
    }

    private void removeSessionCookie(MockHttpServletRequest request, String sessionid) {
        this.getCookieManager().removeCookie(this.createCookie(request, sessionid));
    }

    private Cookie createCookie(MockHttpServletRequest request, String sessionid) {
        return new Cookie(request.getServerName(), "JSESSIONID", sessionid, request.getContextPath() + "/", null, request.isSecure(), true);
    }

    private void locales(MockHttpServletRequest request) {
        String locale = this.header("Accept-Language");
        if (locale == null) {
            request.addPreferredLocale(Locale.getDefault());
        } else {
            String[] locales = locale.split(", ");
            for (int i = locales.length - 1; i >= 0; --i) {
                request.addPreferredLocale(this.parseLocale(locales[i]));
            }
        }
    }

    private void params(MockHttpServletRequest request, UriComponents uriComponents) {
        for (Map.Entry entry : uriComponents.getQueryParams().entrySet()) {
            String name = (String)entry.getKey();
            String urlDecodedName = this.urlDecode(name);
            for (String value : (List)entry.getValue()) {
                value = value != null ? this.urlDecode(value) : "";
                request.addParameter(urlDecodedName, value);
            }
        }
        for (NameValuePair param : this.webRequest.getRequestParameters()) {
            request.addParameter(param.getName(), param.getValue());
        }
    }

    private String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private Locale parseLocale(String locale) {
        String qualifier;
        Matcher matcher = LOCALE_PATTERN.matcher(locale);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid locale " + locale);
        }
        String language = matcher.group(1);
        String country = matcher.group(2);
        if (country == null) {
            country = "";
        }
        if ((qualifier = matcher.group(3)) == null) {
            qualifier = "";
        }
        return new Locale(language, country, qualifier);
    }

    private void pathInfo(UriComponents uriComponents, MockHttpServletRequest request) {
        request.setPathInfo(null);
    }

    private void servletPath(MockHttpServletRequest request, String requestPath) {
        String servletPath = requestPath.substring(request.getContextPath().length());
        if ("".equals(servletPath)) {
            servletPath = null;
        }
        request.setServletPath(servletPath);
    }

    private void servletPath(UriComponents uriComponents, MockHttpServletRequest request) {
        if ("".equals(request.getPathInfo())) {
            request.setPathInfo(null);
        }
        this.servletPath(request, uriComponents.getPath());
    }

    private void ports(UriComponents uriComponents, MockHttpServletRequest request) {
        int serverPort = uriComponents.getPort();
        request.setServerPort(serverPort);
        if (serverPort == -1) {
            int portConnection = this.webRequest.getUrl().getDefaultPort();
            request.setLocalPort(serverPort);
            request.setRemotePort(portConnection);
        } else {
            request.setRemotePort(serverPort);
        }
    }

    private UriComponents uriComponents() {
        URL url = this.webRequest.getUrl();
        UriComponentsBuilder uriBldr = UriComponentsBuilder.fromUriString((String)url.toExternalForm());
        return uriBldr.build();
    }

    public boolean isMergeEnabled() {
        return true;
    }

    public Object merge(Object parent) {
        if (parent == null) {
            return this;
        }
        if (parent instanceof RequestBuilder) {
            this.parentBuilder = (RequestBuilder)parent;
        }
        if (parent instanceof SmartRequestBuilder) {
            this.parentPostProcessor = (SmartRequestBuilder)parent;
        }
        return this;
    }

    private CookieManager getCookieManager() {
        return this.webClient.getCookieManager();
    }

    private final class HtmlUnitMockHttpSession
    extends MockHttpSession {
        private final MockHttpServletRequest request;

        private HtmlUnitMockHttpSession(MockHttpServletRequest request) {
            super(request.getServletContext());
            this.request = request;
        }

        private HtmlUnitMockHttpSession(MockHttpServletRequest request, String id) {
            super(request.getServletContext(), id);
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidate() {
            super.invalidate();
            Map map = HtmlUnitRequestBuilder.this.sessions;
            synchronized (map) {
                HtmlUnitRequestBuilder.this.sessions.remove(this.getId());
            }
            HtmlUnitRequestBuilder.this.removeSessionCookie(this.request, this.getId());
        }
    }

    private final class HtmlUnitMockHttpServletRequest
    extends MockHttpServletRequest {
        private HtmlUnitMockHttpServletRequest(ServletContext servletContext, String method, String requestURI) {
            super(servletContext, method, requestURI);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HttpSession getSession(boolean create) {
            HttpSession session = super.getSession(false);
            if (session == null && create) {
                HtmlUnitMockHttpSession newSession = new HtmlUnitMockHttpSession((MockHttpServletRequest)this);
                this.setSession(newSession);
                newSession.setNew(true);
                String sessionid = newSession.getId();
                Map map = HtmlUnitRequestBuilder.this.sessions;
                synchronized (map) {
                    HtmlUnitRequestBuilder.this.sessions.put(sessionid, newSession);
                }
                HtmlUnitRequestBuilder.this.addSessionCookie(this, sessionid);
                session = newSession;
            }
            return session;
        }

        @Override
        public HttpSession getSession() {
            return super.getSession();
        }

        @Override
        public void setSession(HttpSession session) {
            super.setSession(session);
        }
    }
}

